/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.googleapps.GAuthenticator;
import com.liferay.portal.kernel.googleapps.GoogleAppsException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class GHelperUtil {
    public static final String APPS_URL = "https://apps-apis.google.com/a/feeds";
    private static final String _APPS_PREFIX = "apps";
    private static final String _APPS_URI = "http://schemas.google.com/apps/2006";
    private static final String _ATOM_PREFIX = "atom";
    private static final String _ATOM_URI = "http://www.w3.org/2005/Atom";
    private static Log _log = LogFactoryUtil.getLog(GHelperUtil.class);

    public static Element addAppsProperty(Element parentElement, String name, String value) {
        Element element = parentElement.addElement("apps:property");
        element.addAttribute("name", name);
        element.addAttribute("value", value);
        return element;
    }

    public static Element addAtomCategory(Element parentElement, String type) {
        Element element = parentElement.addElement("atom:category");
        element.addAttribute("scheme", "http://schemas.google.com/g/2005#kind");
        element.addAttribute("term", "http://schemas.google.com/apps/2006#" + type);
        return element;
    }

    public static Element addAtomEntry(Document document) {
        Element element = document.addElement("atom:entry");
        element.add(GHelperUtil.getAppsNamespace());
        element.add(GHelperUtil.getAtomNamespace());
        return element;
    }

    public static Namespace getAppsNamespace() {
        return SAXReaderUtil.createNamespace((String)_APPS_PREFIX, (String)_APPS_URI);
    }

    public static QName getAppsQName(String localName) {
        return SAXReaderUtil.createQName((String)localName, (Namespace)GHelperUtil.getAppsNamespace());
    }

    public static Namespace getAtomNamespace() {
        return SAXReaderUtil.createNamespace((String)_ATOM_PREFIX, (String)_ATOM_URI);
    }

    public static QName getAtomQName(String localName) {
        return SAXReaderUtil.createQName((String)localName, (Namespace)GHelperUtil.getAtomNamespace());
    }

    public static Document getDocument(GAuthenticator gAuthenticator, String url) throws GoogleAppsException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("getDocument request " + url));
            }
            Http.Options options = GHelperUtil._getOptions(gAuthenticator);
            options.setLocation(url);
            String xml = HttpUtil.URLtoString((Http.Options)options);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("getDocument response " + xml));
            }
            return SAXReaderUtil.read((Reader)new UnsyncStringReader(xml));
        }
        catch (DocumentException de) {
            throw new GoogleAppsException((Throwable)de);
        }
        catch (IOException ioe) {
            throw new GoogleAppsException((Throwable)ioe);
        }
    }

    public static String getErrorMessage(Document document) {
        Element rootElement = document.getRootElement();
        Element errorElement = rootElement.element("error");
        List attributes = errorElement.attributes();
        StringBundler sb = new StringBundler(attributes.size() * 4 + 1);
        sb.append("{");
        int i = 0;
        while (i < attributes.size()) {
            Attribute attribute = (Attribute)attributes.get(i);
            sb.append(attribute.getName());
            sb.append("=");
            sb.append(attribute.getValue());
            if (i + 1 <= attributes.size()) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public static boolean hasError(Document document) {
        Element rootElement = document.getRootElement();
        return rootElement.element("error") != null;
    }

    public static void submitAdd(GAuthenticator gAuthenticator, String url, Document document) throws GoogleAppsException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("submitAdd request " + url));
            }
            Http.Options options = GHelperUtil._getOptions(gAuthenticator);
            options.setBody(document.formattedString(), "application/atom+xml", "UTF-8");
            options.setLocation(url);
            options.setPost(true);
            String response = HttpUtil.URLtoString((Http.Options)options);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("submitAdd response " + response));
            }
        }
        catch (IOException ioe) {
            throw new GoogleAppsException((Throwable)ioe);
        }
    }

    public static void submitDelete(GAuthenticator gAuthenticator, String url) throws GoogleAppsException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("submitDelete request " + url));
            }
            Http.Options options = GHelperUtil._getOptions(gAuthenticator);
            options.setDelete(true);
            options.setLocation(url);
            String response = HttpUtil.URLtoString((Http.Options)options);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("submitDelete response " + response));
            }
        }
        catch (IOException ioe) {
            throw new GoogleAppsException((Throwable)ioe);
        }
    }

    public static void submitUpdate(GAuthenticator gAuthenticator, String url, Document document) throws GoogleAppsException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("submitUpdate request " + url));
            }
            Http.Options options = GHelperUtil._getOptions(gAuthenticator);
            options.setBody(document.formattedString(), "application/atom+xml", "UTF-8");
            options.setLocation(url);
            options.setPut(true);
            String response = HttpUtil.URLtoString((Http.Options)options);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("submitUpdate response " + response));
            }
        }
        catch (IOException ioe) {
            throw new GoogleAppsException((Throwable)ioe);
        }
    }

    private static Http.Options _getOptions(GAuthenticator gAuthenticator) {
        Http.Options options = new Http.Options();
        options.addHeader("Authorization", "GoogleLogin auth=" + gAuthenticator.getAuthenticationToken());
        return options;
    }
}

