/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.googleapps.GAuthenticator;
import com.liferay.portal.googleapps.GBaseManagerImpl;
import com.liferay.portal.googleapps.GetNextItems;
import com.liferay.portal.googleapps.GoogleApps;
import com.liferay.portal.kernel.googleapps.GGroup;
import com.liferay.portal.kernel.googleapps.GGroupManager;
import com.liferay.portal.kernel.googleapps.GGroupMember;
import com.liferay.portal.kernel.googleapps.GGroupOwner;
import com.liferay.portal.kernel.googleapps.GUser;
import com.liferay.portal.kernel.googleapps.GUserManager;
import com.liferay.portal.kernel.googleapps.GoogleAppsException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGroupManagerImpl
extends GBaseManagerImpl
implements GGroupManager {
    protected String groupURL;
    private static Log _log = LogFactoryUtil.getLog(GGroupManagerImpl.class);

    public GGroupManagerImpl(GoogleApps googleApps) {
        super(googleApps);
        GAuthenticator gAuthenticator = googleApps.getGAuthenticator();
        this.groupURL = "https://apps-apis.google.com/a/feeds".concat("/group/2.0/").concat(gAuthenticator.getDomain());
    }

    public void addGGroupMember(String groupEmailAddress, String memberEmailAddress) throws GoogleAppsException {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntryElement = this.addAtomEntry(document);
        this.addAppsProperty(atomEntryElement, "memberId", memberEmailAddress);
        StringBundler sb = new StringBundler(4);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(groupEmailAddress);
        sb.append("/member");
        this.submitAdd(sb.toString(), document);
    }

    public void addGGroupOwner(String groupEmailAddress, String ownerEmailAddress) throws GoogleAppsException {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntryElement = this.addAtomEntry(document);
        this.addAppsProperty(atomEntryElement, "email", ownerEmailAddress);
        StringBundler sb = new StringBundler(4);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(groupEmailAddress);
        sb.append("/owner");
        this.submitAdd(sb.toString(), document);
    }

    public void deleteGGroup(String emailAddress) throws GoogleAppsException {
        this.submitDelete(this.getGroupURL(emailAddress));
    }

    public void deleteGGroupMember(String groupEmailAddress, String memberEmailAddress) throws GoogleAppsException {
        StringBundler sb = new StringBundler(5);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(groupEmailAddress);
        sb.append("/member/");
        sb.append(memberEmailAddress);
        this.submitDelete(sb.toString());
    }

    public void deleteGGroupOwner(String groupEmailAddress, String ownerEmailAddress) throws GoogleAppsException {
        StringBundler sb = new StringBundler(5);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(groupEmailAddress);
        sb.append("/owner/");
        sb.append(ownerEmailAddress);
        this.submitDelete(sb.toString());
    }

    public GGroup getGGroup(String emailAddress) throws GoogleAppsException {
        Document document = this.getDocument(this.getGroupURL(emailAddress));
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return null;
        }
        Element atomEntryElement = document.getRootElement();
        return this.getGGroup(atomEntryElement);
    }

    public GGroupMember getGGroupMember(String groupEmailAddress, String memberEmailAddress) throws GoogleAppsException {
        StringBundler sb = new StringBundler(5);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(groupEmailAddress);
        sb.append("/member/");
        sb.append(memberEmailAddress);
        Document document = this.getDocument(sb.toString());
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return null;
        }
        Element atomEntryElement = document.getRootElement();
        return this.getGGroupMember(atomEntryElement);
    }

    public List<GGroupMember> getGGroupMembers(String emailAddress) throws GoogleAppsException {
        ArrayList<GGroupMember> gGroupMembers = new ArrayList<GGroupMember>();
        StringBundler sb = new StringBundler(4);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(emailAddress);
        sb.append("/member");
        this.getGGroupMembers(gGroupMembers, sb.toString());
        return gGroupMembers;
    }

    public GGroupOwner getGGroupOwner(String groupEmailAddress, String ownerEmailAddress) throws GoogleAppsException {
        StringBundler sb = new StringBundler(5);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(groupEmailAddress);
        sb.append("/owner/");
        sb.append(ownerEmailAddress);
        Document document = this.getDocument(sb.toString());
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return null;
        }
        Element atomEntryElement = document.getRootElement();
        return this.getGGroupOwner(atomEntryElement);
    }

    public List<GGroupOwner> getGGroupOwners(String emailAddress) throws GoogleAppsException {
        ArrayList<GGroupOwner> gGroupOwners = new ArrayList<GGroupOwner>();
        StringBundler sb = new StringBundler(4);
        sb.append(this.groupURL);
        sb.append("/");
        sb.append(emailAddress);
        sb.append("/owner");
        this.getGGroupOwners(gGroupOwners, sb.toString());
        return gGroupOwners;
    }

    public List<GGroup> getGGroups() throws GoogleAppsException {
        ArrayList<GGroup> gGroups = new ArrayList<GGroup>();
        this.getGGroups(gGroups, this.groupURL);
        return gGroups;
    }

    public List<GGroup> getGGroups(long userId, boolean directOnly) throws GoogleAppsException {
        ArrayList<GGroup> gGroups = new ArrayList<GGroup>();
        StringBundler sb = new StringBundler(4);
        sb.append(this.groupURL);
        sb.append("?member=");
        sb.append(userId);
        sb.append("&directOnly=");
        sb.append(directOnly);
        this.getGGroups(gGroups, sb.toString());
        return gGroups;
    }

    public void updateDescription(String emailAddress, String description) throws GoogleAppsException {
        Document document = this.getDocument(this.getGroupURL(emailAddress));
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return;
        }
        Element atomEntryElement = document.getRootElement();
        List appsPropertyElements = atomEntryElement.elements(this.getAppsQName("property"));
        for (Element appsPropertyElement : appsPropertyElements) {
            String name = appsPropertyElement.attributeValue("name");
            if (!name.equals("description")) continue;
            Attribute valueAttribute = appsPropertyElement.attribute("value");
            valueAttribute.setValue(description);
        }
        this.submitUpdate(this.getGroupURL(emailAddress), document);
    }

    protected GGroup getGGroup(Element atomEntryElement) {
        GGroup gGroup = new GGroup();
        List appsPropertyElements = atomEntryElement.elements(this.getAppsQName("property"));
        for (Element appsPropertyElement : appsPropertyElements) {
            String name = appsPropertyElement.attributeValue("name");
            String value = appsPropertyElement.attributeValue("value");
            if (name.equals("description")) {
                gGroup.setDescription(value);
                continue;
            }
            if (name.equals("emailPermission")) {
                gGroup.setEmailPermission(value);
                continue;
            }
            if (name.equals("groupId")) {
                gGroup.setEmailAddress(value);
                continue;
            }
            if (name.equals("groupName")) {
                gGroup.setName(value);
                continue;
            }
            if (!name.equals("permissionPreset")) continue;
            gGroup.setPermissionPreset(value);
        }
        return gGroup;
    }

    protected GGroupMember getGGroupMember(Element atomEntryElement) throws GoogleAppsException {
        GGroupMember gGroupMember = new GGroupMember();
        List appsPropertyElements = atomEntryElement.elements(this.getAppsQName("property"));
        for (Element appsPropertyElement : appsPropertyElements) {
            String name = appsPropertyElement.attributeValue("name");
            String value = appsPropertyElement.attributeValue("value");
            if (name.equals("directMember")) {
                gGroupMember.setDirect(GetterUtil.getBoolean((String)value));
                continue;
            }
            if (name.equals("memberId")) {
                gGroupMember.setEmailAddress(value);
                continue;
            }
            if (!name.equals("memberType")) continue;
            gGroupMember.setType(value);
        }
        String type = gGroupMember.getType();
        if (type.equals("Group")) {
            GGroup gGroup = this.getGGroup(gGroupMember.getEmailAddress());
            gGroupMember.setGGroup(gGroup);
        } else if (type.equals("User")) {
            GUserManager gUserManager = this.googleApps.getGUserManager();
            GUser gUser = gUserManager.getGUser(gGroupMember.getEmailAddress());
            gGroupMember.setGUser(gUser);
        }
        return gGroupMember;
    }

    protected void getGGroupMembers(final List<GGroupMember> gGroupMembers, String url) throws GoogleAppsException {
        Document document = this.getDocument(url);
        Element atomFeedElement = document.getRootElement();
        List atomEntryElements = atomFeedElement.elements(this.getAtomQName("entry"));
        for (Element atomEntryElement : atomEntryElements) {
            GGroupMember gGroupMember = this.getGGroupMember(atomEntryElement);
            gGroupMembers.add(gGroupMember);
        }
        new GetNextItems(url, atomFeedElement){

            public void getNextItems(String nextURL) throws GoogleAppsException {
                GGroupManagerImpl.this.getGGroupMembers(gGroupMembers, nextURL);
            }
        };
    }

    protected GGroupOwner getGGroupOwner(Element atomEntryElement) throws GoogleAppsException {
        GGroupOwner gGroupOwner = new GGroupOwner();
        List appsPropertyElements = atomEntryElement.elements(this.getAppsQName("property"));
        for (Element appsPropertyElement : appsPropertyElements) {
            String name = appsPropertyElement.attributeValue("name");
            String value = appsPropertyElement.attributeValue("value");
            if (name.equals("email")) {
                gGroupOwner.setEmailAddress(value);
                continue;
            }
            if (!name.equals("type")) continue;
            gGroupOwner.setType(value);
        }
        String type = gGroupOwner.getType();
        if (type.equals("Group")) {
            GGroup gGroup = this.getGGroup(gGroupOwner.getEmailAddress());
            gGroupOwner.setGGroup(gGroup);
        } else if (type.equals("User")) {
            GUserManager gUserManager = this.googleApps.getGUserManager();
            GUser gUser = gUserManager.getGUser(gGroupOwner.getEmailAddress());
            gGroupOwner.setGUser(gUser);
        }
        return gGroupOwner;
    }

    protected void getGGroupOwners(final List<GGroupOwner> gGroupOwners, String url) throws GoogleAppsException {
        Document document = this.getDocument(url);
        Element atomFeedElement = document.getRootElement();
        List atomEntryElements = atomFeedElement.elements(this.getAtomQName("entry"));
        for (Element atomEntryElement : atomEntryElements) {
            GGroupOwner gGroupOwner = this.getGGroupOwner(atomEntryElement);
            gGroupOwners.add(gGroupOwner);
        }
        new GetNextItems(url, atomFeedElement){

            public void getNextItems(String nextURL) throws GoogleAppsException {
                GGroupManagerImpl.this.getGGroupOwners(gGroupOwners, nextURL);
            }
        };
    }

    protected void getGGroups(final List<GGroup> gGroups, String url) throws GoogleAppsException {
        Document document = this.getDocument(url);
        Element atomFeedElement = document.getRootElement();
        List atomEntryElements = atomFeedElement.elements(this.getAtomQName("entry"));
        for (Element atomEntryElement : atomEntryElements) {
            GGroup gGroup = this.getGGroup(atomEntryElement);
            gGroups.add(gGroup);
        }
        new GetNextItems(url, atomFeedElement){

            public void getNextItems(String nextURL) throws GoogleAppsException {
                GGroupManagerImpl.this.getGGroups(gGroups, nextURL);
            }
        };
    }

    protected String getGroupURL(String emailAddress) {
        return this.groupURL.concat("/").concat(emailAddress);
    }
}

