/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.FreeMarkerContextImpl;
import com.liferay.portal.freemarker.LiferayCacheStorage;
import com.liferay.portal.freemarker.LiferayObjectWrapper;
import com.liferay.portal.freemarker.LiferayTemplateLoader;
import com.liferay.portal.freemarker.StringTemplateLoader;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngine;
import com.liferay.portal.kernel.freemarker.FreeMarkerVariablesUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class FreeMarkerEngineImpl
implements FreeMarkerEngine {
    private static Log _log = LogFactoryUtil.getLog(FreeMarkerEngineImpl.class);
    private Configuration _configuration;
    private FreeMarkerContextImpl _restrictedToolsContext;
    private FreeMarkerContextImpl _standardToolsContext;
    private StringTemplateLoader _stringTemplateLoader;

    public void flushTemplate(String freeMarkerTemplateId) {
        if (this._stringTemplateLoader != null) {
            this._stringTemplateLoader.removeTemplate(freeMarkerTemplateId);
        }
        PortalCache portalCache = LiferayCacheStorage.getPortalCache();
        portalCache.remove((Serializable)((Object)freeMarkerTemplateId));
    }

    public FreeMarkerContext getWrappedRestrictedToolsContext() {
        return new FreeMarkerContextImpl(this._restrictedToolsContext.getWrappedContext());
    }

    public FreeMarkerContext getWrappedStandardToolsContext() {
        return new FreeMarkerContextImpl(this._standardToolsContext.getWrappedContext());
    }

    public void init() throws Exception {
        if (this._configuration != null) {
            return;
        }
        LiferayTemplateLoader liferayTemplateLoader = new LiferayTemplateLoader();
        liferayTemplateLoader.setTemplateLoaders(PropsValues.FREEMARKER_ENGINE_TEMPLATE_LOADERS);
        this._stringTemplateLoader = new StringTemplateLoader();
        MultiTemplateLoader multiTemplateLoader = new MultiTemplateLoader(new TemplateLoader[]{new ClassTemplateLoader(this.getClass(), "/"), this._stringTemplateLoader, liferayTemplateLoader});
        this._configuration = new Configuration();
        this._configuration.setDefaultEncoding("UTF-8");
        this._configuration.setLocalizedLookup(PropsValues.FREEMARKER_ENGINE_LOCALIZED_LOOKUP);
        this._configuration.setObjectWrapper((ObjectWrapper)new LiferayObjectWrapper());
        this._configuration.setSetting("auto_import", PropsValues.FREEMARKER_ENGINE_MACRO_LIBRARY);
        this._configuration.setSetting("cache_storage", PropsValues.FREEMARKER_ENGINE_CACHE_STORAGE);
        this._configuration.setSetting("template_exception_handler", PropsValues.FREEMARKER_ENGINE_TEMPLATE_EXCEPTION_HANDLER);
        this._configuration.setTemplateLoader((TemplateLoader)multiTemplateLoader);
        this._configuration.setTemplateUpdateDelay(PropsValues.FREEMARKER_ENGINE_MODIFICATION_CHECK_INTERVAL);
        this._restrictedToolsContext = new FreeMarkerContextImpl();
        FreeMarkerVariablesUtil.insertHelperUtilities((FreeMarkerContext)this._restrictedToolsContext, (String[])PropsValues.JOURNAL_TEMPLATE_FREEMARKER_RESTRICTED_VARIABLES);
        this._standardToolsContext = new FreeMarkerContextImpl();
        FreeMarkerVariablesUtil.insertHelperUtilities((FreeMarkerContext)this._standardToolsContext, null);
    }

    public boolean mergeTemplate(String freeMarkerTemplateId, FreeMarkerContext freeMarkerContext, Writer writer) throws Exception {
        return this.mergeTemplate(freeMarkerTemplateId, null, freeMarkerContext, writer);
    }

    public boolean mergeTemplate(String freeMarkerTemplateId, String freemarkerTemplateContent, FreeMarkerContext freeMarkerContext, Writer writer) throws Exception {
        if (!(!Validator.isNotNull((String)freemarkerTemplateContent) || PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED && this.stringTemplateExists(freeMarkerTemplateId))) {
            this._stringTemplateLoader.putTemplate(freeMarkerTemplateId, freemarkerTemplateContent);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added " + freeMarkerTemplateId + " to the string based FreeMarker template repository"));
            }
        }
        FreeMarkerContextImpl freeMarkerContextImpl = (FreeMarkerContextImpl)freeMarkerContext;
        Template template = this._configuration.getTemplate(freeMarkerTemplateId, "UTF-8");
        template.process(freeMarkerContextImpl.getWrappedContext(), writer);
        return true;
    }

    public boolean resourceExists(String resource) {
        try {
            Template template = this._configuration.getTemplate(resource);
            return template != null;
        }
        catch (IOException ioe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)ioe, (Throwable)ioe);
            }
            return false;
        }
    }

    protected boolean stringTemplateExists(String freeMarkerTemplateId) {
        Object templateSource = this._stringTemplateLoader.findTemplateSource(freeMarkerTemplateId);
        return templateSource != null;
    }
}

