/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.executor;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorFactory;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalExecutorManagerImpl
implements PortalExecutorManager {
    private static Log _log = LogFactoryUtil.getLog(PortalExecutorManagerImpl.class);
    private PortalExecutorFactory _portalExecutorFactory;
    private Map<String, ThreadPoolExecutor> _portalExecutors = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public void afterPropertiesSet() {
        if (this._portalExecutorFactory == null) {
            throw new IllegalArgumentException("portal executor factory is null");
        }
    }

    public <T> Future<T> execute(String name, Callable<T> callable) {
        ThreadPoolExecutor portalExecutor = this.getPortalExecutor(name);
        return portalExecutor.submit(callable);
    }

    public <T> T execute(String name, Callable<T> callable, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        ThreadPoolExecutor portalExecutor = this.getPortalExecutor(name);
        Future future = portalExecutor.submit(callable);
        return (T)future.get(timeout, timeUnit);
    }

    public ThreadPoolExecutor getPortalExecutor(String name) {
        return this.getPortalExecutor(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getPortalExecutor(String name, boolean createIfAbsent) {
        ThreadPoolExecutor portalExecutor = this._portalExecutors.get(name);
        if (portalExecutor == null && createIfAbsent) {
            Map<String, ThreadPoolExecutor> map = this._portalExecutors;
            synchronized (map) {
                portalExecutor = this._portalExecutors.get(name);
                if (portalExecutor == null) {
                    portalExecutor = this._portalExecutorFactory.createPortalExecutor(name);
                    this._portalExecutors.put(name, portalExecutor);
                }
            }
        }
        return portalExecutor;
    }

    public void setPortalExecutorFactory(PortalExecutorFactory portalExecutorFactory) {
        this._portalExecutorFactory = portalExecutorFactory;
    }

    public void setPortalExecutors(Map<String, ThreadPoolExecutor> portalExecutors) {
        if (portalExecutors != null) {
            this._portalExecutors = new ConcurrentHashMap<String, ThreadPoolExecutor>(portalExecutors);
        }
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean interrupt) {
        for (ThreadPoolExecutor portalExecutor : this._portalExecutors.values()) {
            if (interrupt) {
                portalExecutor.shutdownNow();
                continue;
            }
            portalExecutor.shutdown();
        }
        this._portalExecutors.clear();
    }

    public void shutdown(String name) {
        this.shutdown(name, false);
    }

    public void shutdown(String name, boolean interrupt) {
        ThreadPoolExecutor portalExecutor = this._portalExecutors.remove(name);
        if (portalExecutor == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No portal executor found for name " + name));
            }
            return;
        }
        if (interrupt) {
            portalExecutor.shutdownNow();
        } else {
            portalExecutor.shutdown();
        }
    }
}

