/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThemeServicePreAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(ThemeServicePreAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        try {
            this.servicePre(request, response);
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected void servicePre(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        ColorScheme colorScheme = themeDisplay.getColorScheme();
        if (theme != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Theme is already set");
            }
            return;
        }
        Layout layout = themeDisplay.getLayout();
        boolean wapTheme = BrowserSnifferUtil.isWap((HttpServletRequest)request);
        if (layout != null) {
            if (wapTheme) {
                theme = layout.getWapTheme();
                colorScheme = layout.getWapColorScheme();
            } else {
                theme = layout.getTheme();
                colorScheme = layout.getColorScheme();
            }
        } else {
            String themeId = null;
            String colorSchemeId = null;
            if (wapTheme) {
                themeId = ThemeImpl.getDefaultWapThemeId(themeDisplay.getCompanyId());
                colorSchemeId = ColorSchemeImpl.getDefaultWapColorSchemeId();
            } else {
                themeId = ThemeImpl.getDefaultRegularThemeId(themeDisplay.getCompanyId());
                colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
            }
            theme = ThemeLocalServiceUtil.getTheme((long)themeDisplay.getCompanyId(), (String)themeId, (boolean)wapTheme);
            colorScheme = ThemeLocalServiceUtil.getColorScheme((long)themeDisplay.getCompanyId(), (String)theme.getThemeId(), (String)colorSchemeId, (boolean)wapTheme);
        }
        request.setAttribute("THEME", (Object)theme);
        request.setAttribute("COLOR_SCHEME", (Object)colorScheme);
        themeDisplay.setLookAndFeel(theme, colorScheme);
    }
}

