/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.LayoutPermissionException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.theme.ThemeDisplayFactory;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePreAction
extends Action {
    protected File privateLARFile;
    protected File publicLARFile;
    private static final String _CONTROL_PANEL_CATEGORY_PORTLET_PREFIX = "portlet_";
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static Log _log = LogFactoryUtil.getLog(ServicePreAction.class);

    public ServicePreAction() {
        this.initImportLARFiles();
    }

    public ThemeDisplay initThemeDisplay(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean redirectToDefaultLayout;
        String i18nLanguageId;
        HttpSession session = request.getSession();
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        long companyId = company.getCompanyId();
        String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)request);
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        String contextPath = PortalUtil.getPathContext();
        String friendlyURLPrivateGroupPath = PortalUtil.getPathFriendlyURLPrivateGroup();
        String friendlyURLPrivateUserPath = PortalUtil.getPathFriendlyURLPrivateUser();
        String friendlyURLPublicPath = PortalUtil.getPathFriendlyURLPublic();
        String imagePath = cdnHost.concat(PortalUtil.getPathImage());
        String mainPath = PortalUtil.getPathMain();
        String i18nPath = (String)request.getAttribute("I18N_PATH");
        if (Validator.isNotNull((String)i18nPath)) {
            if (Validator.isNotNull((String)contextPath)) {
                String i18nContextPath = contextPath.concat(i18nPath);
                friendlyURLPrivateGroupPath = StringUtil.replaceFirst((String)friendlyURLPrivateGroupPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPrivateUserPath = StringUtil.replaceFirst((String)friendlyURLPrivateUserPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPublicPath = StringUtil.replaceFirst((String)friendlyURLPublicPath, (String)contextPath, (String)i18nContextPath);
                mainPath = StringUtil.replaceFirst((String)mainPath, (String)contextPath, (String)i18nContextPath);
            } else {
                friendlyURLPrivateGroupPath = i18nPath.concat(friendlyURLPrivateGroupPath);
                friendlyURLPrivateUserPath = i18nPath.concat(friendlyURLPrivateUserPath);
                friendlyURLPublicPath = i18nPath.concat(friendlyURLPublicPath);
                mainPath = i18nPath.concat(mainPath);
            }
        }
        StringBundler sb = new StringBundler(5);
        sb.append(imagePath);
        sb.append("/company_logo?img_id=");
        sb.append(company.getLogoId());
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken((long)company.getLogoId()));
        String companyLogo = sb.toString();
        int companyLogoHeight = 0;
        int companyLogoWidth = 0;
        Image companyLogoImage = ImageLocalServiceUtil.getCompanyLogo((long)company.getLogoId());
        if (companyLogoImage != null) {
            companyLogoHeight = companyLogoImage.getHeight();
            companyLogoWidth = companyLogoImage.getWidth();
        }
        String realCompanyLogo = companyLogo;
        int realCompanyLogoHeight = companyLogoHeight;
        int realCompanyLogoWidth = companyLogoWidth;
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (NoSuchUserException nsue) {
            long userId;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsue.getMessage());
            }
            if ((userId = PortalUtil.getUserId((HttpServletRequest)request)) > 0L) {
                session.invalidate();
            }
            return null;
        }
        boolean signedIn = false;
        if (user == null) {
            user = company.getDefaultUser();
        } else if (!user.isDefaultUser()) {
            signedIn = true;
        }
        if (PropsValues.BROWSER_CACHE_DISABLED || PropsValues.BROWSER_CACHE_SIGNED_IN_DISABLED && signedIn) {
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
        }
        User realUser = user;
        Long realUserId = (Long)session.getAttribute("USER_ID");
        if (realUserId != null && user.getUserId() != realUserId.longValue()) {
            realUser = UserLocalServiceUtil.getUserById((long)realUserId);
        }
        String doAsUserId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserLanguageId");
        long doAsGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"doAsGroupId");
        long refererPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"refererPlid");
        if (LayoutLocalServiceUtil.fetchLayout((long)refererPlid) == null) {
            refererPlid = 0L;
        }
        String controlPanelCategory = ParamUtil.getString((HttpServletRequest)request, (String)"controlPanelCategory");
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            locale = LocaleUtil.fromLanguageId((String)doAsUserLanguageId);
        }
        if (Validator.isNotNull((String)(i18nLanguageId = (String)request.getAttribute("I18N_LANGUAGE_ID")))) {
            locale = LocaleUtil.fromLanguageId((String)i18nLanguageId);
        } else if (locale == null) {
            if (signedIn) {
                locale = user.getLocale();
            } else {
                String languageId = CookieKeys.getCookie(request, "GUEST_LANGUAGE_ID", false);
                if (Validator.isNotNull((String)languageId)) {
                    locale = LocaleUtil.fromLanguageId((String)languageId);
                }
                if (locale == null && PropsValues.LOCALE_DEFAULT_REQUEST) {
                    locale = request.getLocale();
                }
                if (locale == null) {
                    locale = user.getLocale();
                }
                if (Validator.isNull((String)locale.getCountry())) {
                    locale = LanguageUtil.getLocale((String)locale.getLanguage());
                }
                if (!LanguageUtil.isAvailableLocale((Locale)locale)) {
                    locale = user.getLocale();
                }
            }
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
            LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
        }
        try {
            CookieKeys.validateSupportCookie(request);
        }
        catch (Exception exception) {
            CookieKeys.addSupportCookie(request, response);
        }
        TimeZone timeZone = user.getTimeZone();
        if (timeZone == null) {
            timeZone = company.getTimeZone();
        }
        if (signedIn) {
            this.updateUserLayouts(user);
        }
        Object layout = null;
        List<Object> layouts = null;
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
            long sourceGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_v_l_s_g_id");
            if (sourceGroupId > 0L && sourceGroupId != layout.getGroupId()) {
                Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
                layout = SitesUtil.isUserGroupLayoutSetViewable(permissionChecker, layout.getGroup()) ? new VirtualLayout((Layout)layout, sourceGroup) : null;
            }
        } else {
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
            if (groupId > 0L && layoutId > 0L) {
                layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            }
        }
        if ((redirectToDefaultLayout = (Boolean)request.getAttribute("REDIRECT_TO_DEFAULT_LAYOUT")) == null) {
            redirectToDefaultLayout = Boolean.FALSE;
        }
        if (layout != null) {
            Group group = layout.getGroup();
            if (!signedIn && PropsValues.AUTH_FORWARD_BY_REDIRECT) {
                request.setAttribute("REQUESTED_LAYOUT", layout);
            }
            boolean isViewableGroup = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)controlPanelCategory, (boolean)true, (String)"VIEW");
            boolean isViewableStaging = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"VIEW_STAGING");
            if (isViewableStaging) {
                layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
            } else if (!isViewableGroup && group.isStagingGroup()) {
                layout = null;
            } else {
                if (!(this.isLoginRequest(request) || isViewableGroup && (redirectToDefaultLayout.booleanValue() || LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (boolean)false, (String)"VIEW")))) {
                    if (user.isDefaultUser()) {
                        throw new PrincipalException("User is not authenticated");
                    }
                    sb = new StringBundler(6);
                    sb.append("User ");
                    sb.append(user.getUserId());
                    sb.append(" is not allowed to access the ");
                    sb.append(layout.isPrivateLayout() ? "private" : "public");
                    sb.append(" pages of group ");
                    sb.append(layout.getGroupId());
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)sb.toString());
                    }
                    throw new NoSuchLayoutException(sb.toString());
                }
                if (group.isLayoutPrototype()) {
                    layouts = new ArrayList();
                } else {
                    layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
                    if (!group.isControlPanel()) {
                        doAsGroupId = 0L;
                    }
                }
            }
        }
        ArrayList unfilteredLayouts = layouts;
        if (layout == null) {
            Object[] defaultLayout = this.getDefaultLayout(request, user, signedIn);
            layout = (Layout)defaultLayout[0];
            layouts = (ArrayList)defaultLayout[1];
            request.setAttribute("LAYOUT_DEFAULT", (Object)Boolean.TRUE);
        }
        Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, (Layout)layout, (List<Layout>)layouts);
        String layoutSetLogo = null;
        layout = (Layout)viewableLayouts[0];
        layouts = (List)viewableLayouts[1];
        Group group = null;
        if (layout != null && !(group = layout.getGroup()).isControlPanel()) {
            this.rememberVisitedGroupIds(request, group.getGroupId());
        }
        LayoutTypePortlet layoutTypePortlet = null;
        layouts = this.mergeAdditionalLayouts(request, user, permissionChecker, (Layout)layout, (List<Layout>)layouts);
        LayoutSet layoutSet = null;
        boolean hasCustomizeLayoutPermission = false;
        boolean hasUpdateLayoutPermission = false;
        boolean customizedView = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"customized_view", (boolean)true);
        if (layout != null) {
            String typeSettings;
            LayoutClone layoutClone;
            hasCustomizeLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE");
            hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
            layoutSet = layout.getLayoutSet();
            if (company.isSiteLogo()) {
                long logoId = 0L;
                if (layoutSet.isLogo()) {
                    logoId = layoutSet.getLogoId();
                } else {
                    LayoutSet siblingLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)layout.getGroupId(), (!layout.isPrivateLayout() ? 1 : 0) != 0);
                    if (siblingLayoutSet.isLogo()) {
                        logoId = siblingLayoutSet.getLogoId();
                    }
                }
                if (logoId > 0L) {
                    sb = new StringBundler(5);
                    sb.append(imagePath);
                    sb.append("/layout_set_logo?img_id=");
                    sb.append(logoId);
                    sb.append("&t=");
                    sb.append(WebServerServletTokenUtil.getToken((long)logoId));
                    layoutSetLogo = sb.toString();
                    Image layoutSetLogoImage = ImageLocalServiceUtil.getCompanyLogo((long)logoId);
                    companyLogo = layoutSetLogo;
                    companyLogoHeight = layoutSetLogoImage.getHeight();
                    companyLogoWidth = layoutSetLogoImage.getWidth();
                }
            }
            plid = layout.getPlid();
            layoutTypePortlet = (LayoutTypePortlet)(layout = (Layout)layout.clone()).getLayoutType();
            boolean customizable = layoutTypePortlet.isCustomizable();
            if (!customizable || group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
                customizedView = false;
            }
            layoutTypePortlet.setCustomizedView(customizedView);
            layoutTypePortlet.setUpdatePermission(hasUpdateLayoutPermission);
            if (signedIn && customizable && customizedView && hasCustomizeLayoutPermission) {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((long)companyId, (long)user.getUserId(), (boolean)true);
                layoutTypePortlet.setPortalPreferences(portalPreferences);
            }
            if ((layoutClone = LayoutCloneFactory.getInstance()) != null && (typeSettings = layoutClone.get(request, plid)) != null) {
                UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
                typeSettingsProperties.load(typeSettings);
                String stateMax = typeSettingsProperties.getProperty("state-max");
                String stateMin = typeSettingsProperties.getProperty("state-min");
                String modeAbout = typeSettingsProperties.getProperty("mode-about");
                String modeConfig = typeSettingsProperties.getProperty("mode-config");
                String modeEdit = typeSettingsProperties.getProperty("mode-edit");
                String modeEditDefaults = typeSettingsProperties.getProperty("mode-edit-defaults");
                String modeEditGuest = typeSettingsProperties.getProperty("mode-edit-guest");
                String modeHelp = typeSettingsProperties.getProperty("mode-help");
                String modePreview = typeSettingsProperties.getProperty("mode-preview");
                String modePrint = typeSettingsProperties.getProperty("mode-print");
                layoutTypePortlet.setStateMax(stateMax);
                layoutTypePortlet.setStateMin(stateMin);
                layoutTypePortlet.setModeAbout(modeAbout);
                layoutTypePortlet.setModeConfig(modeConfig);
                layoutTypePortlet.setModeEdit(modeEdit);
                layoutTypePortlet.setModeEditDefaults(modeEditDefaults);
                layoutTypePortlet.setModeEditGuest(modeEditGuest);
                layoutTypePortlet.setModeHelp(modeHelp);
                layoutTypePortlet.setModePreview(modePreview);
                layoutTypePortlet.setModePrint(modePrint);
            }
            request.setAttribute("LAYOUT", layout);
            request.setAttribute("LAYOUTS", layouts);
            if (layout.isPrivateLayout()) {
                permissionChecker.setCheckGuest(false);
            }
        }
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request);
        long parentGroupId = PortalUtil.getParentGroupId((long)scopeGroupId);
        Theme theme = null;
        ColorScheme colorScheme = null;
        boolean wapTheme = BrowserSnifferUtil.isWap((HttpServletRequest)request);
        if (layout != null && group.isControlPanel()) {
            String themeId = PrefsPropsUtil.getString(companyId, "control.panel.layout.regular.theme.id");
            String colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
            theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)wapTheme);
            colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)theme.getThemeId(), (String)colorSchemeId, (boolean)wapTheme);
            if (!wapTheme && theme.isWapTheme()) {
                theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)PropsValues.CONTROL_PANEL_LAYOUT_REGULAR_THEME_ID, (boolean)false);
                colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)theme.getThemeId(), (String)colorSchemeId, (boolean)false);
            }
            request.setAttribute("THEME", (Object)theme);
            request.setAttribute("COLOR_SCHEME", (Object)colorScheme);
        }
        boolean themeCssFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"css_fast_load", (boolean)PropsValues.THEME_CSS_FAST_LOAD);
        boolean themeImagesFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"images_fast_load", (boolean)PropsValues.THEME_IMAGES_FAST_LOAD);
        boolean themeJsBarebone = PropsValues.JAVASCRIPT_BAREBONE_ENABLED;
        if (themeJsBarebone && signedIn) {
            themeJsBarebone = false;
        }
        boolean themeJsFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"js_fast_load", (boolean)PropsValues.JAVASCRIPT_FAST_LOAD);
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle", (String)"0");
        lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_t_lifecycle", (String)lifecycle);
        boolean isolated = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_isolated");
        String facebookCanvasPageURL = (String)request.getAttribute("FACEBOOK_CANVAS_PAGE_URL");
        boolean widget = false;
        Boolean widgetObj = (Boolean)request.getAttribute("WIDGET");
        if (widgetObj != null) {
            widget = widgetObj;
        }
        ThemeDisplay themeDisplay = ThemeDisplayFactory.create();
        themeDisplay.setCDNHost(cdnHost);
        themeDisplay.setPortalURL(portalURL);
        themeDisplay.setFacebookCanvasPageURL(facebookCanvasPageURL);
        themeDisplay.setWidget(widget);
        themeDisplay.setCompany(company);
        themeDisplay.setCompanyLogo(companyLogo);
        themeDisplay.setCompanyLogoHeight(companyLogoHeight);
        themeDisplay.setCompanyLogoWidth(companyLogoWidth);
        themeDisplay.setRealCompanyLogo(realCompanyLogo);
        themeDisplay.setRealCompanyLogoHeight(realCompanyLogoHeight);
        themeDisplay.setRealCompanyLogoWidth(realCompanyLogoWidth);
        themeDisplay.setUser(user);
        themeDisplay.setRealUser(realUser);
        themeDisplay.setDoAsUserId(doAsUserId);
        themeDisplay.setDoAsUserLanguageId(doAsUserLanguageId);
        themeDisplay.setDoAsGroupId(doAsGroupId);
        themeDisplay.setRefererPlid(refererPlid);
        themeDisplay.setControlPanelCategory(controlPanelCategory);
        themeDisplay.setLayoutSet(layoutSet);
        themeDisplay.setLayoutSetLogo(layoutSetLogo);
        themeDisplay.setLayout(layout);
        themeDisplay.setLayouts(layouts);
        themeDisplay.setUnfilteredLayouts(unfilteredLayouts);
        themeDisplay.setPlid(plid);
        themeDisplay.setLayoutTypePortlet(layoutTypePortlet);
        themeDisplay.setScopeGroupId(scopeGroupId);
        themeDisplay.setParentGroupId(parentGroupId);
        themeDisplay.setSignedIn(signedIn);
        themeDisplay.setPermissionChecker(permissionChecker);
        themeDisplay.setLocale(locale);
        themeDisplay.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        themeDisplay.setI18nLanguageId(i18nLanguageId);
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setTimeZone(timeZone);
        themeDisplay.setLookAndFeel(theme, colorScheme);
        themeDisplay.setThemeCssFastLoad(themeCssFastLoad);
        themeDisplay.setThemeImagesFastLoad(themeImagesFastLoad);
        themeDisplay.setThemeJsBarebone(themeJsBarebone);
        themeDisplay.setThemeJsFastLoad(themeJsFastLoad);
        themeDisplay.setServerName(request.getServerName());
        themeDisplay.setServerPort(request.getServerPort());
        themeDisplay.setSecure(PortalUtil.isSecure((HttpServletRequest)request));
        themeDisplay.setLifecycle(lifecycle);
        themeDisplay.setLifecycleAction(lifecycle.equals("1"));
        themeDisplay.setLifecycleRender(lifecycle.equals("0"));
        themeDisplay.setLifecycleResource(lifecycle.equals("2"));
        themeDisplay.setStateExclusive(LiferayWindowState.isExclusive((HttpServletRequest)request));
        themeDisplay.setStateMaximized(LiferayWindowState.isMaximized((HttpServletRequest)request));
        themeDisplay.setStatePopUp(LiferayWindowState.isPopUp((HttpServletRequest)request));
        themeDisplay.setIsolated(isolated);
        themeDisplay.setPathApplet(contextPath.concat("/applets"));
        themeDisplay.setPathCms(contextPath.concat("/cms"));
        themeDisplay.setPathContext(contextPath);
        themeDisplay.setPathFlash(contextPath.concat("/flash"));
        themeDisplay.setPathFriendlyURLPrivateGroup(friendlyURLPrivateGroupPath);
        themeDisplay.setPathFriendlyURLPrivateUser(friendlyURLPrivateUserPath);
        themeDisplay.setPathFriendlyURLPublic(friendlyURLPublicPath);
        themeDisplay.setPathImage(imagePath);
        themeDisplay.setPathJavaScript(cdnHost.concat(contextPath).concat("/html/js"));
        themeDisplay.setPathMain(mainPath);
        themeDisplay.setPathSound(contextPath.concat("/html/sound"));
        themeDisplay.setShowAddContentIcon(false);
        themeDisplay.setShowControlPanelIcon(signedIn);
        themeDisplay.setShowHomeIcon(true);
        themeDisplay.setShowMyAccountIcon(signedIn);
        themeDisplay.setShowPageSettingsIcon(false);
        themeDisplay.setShowPortalIcon(true);
        themeDisplay.setShowSignInIcon(!signedIn);
        themeDisplay.setShowSignOutIcon(signedIn);
        boolean showSiteContentIcon = false;
        long controlPanelPlid = 0L;
        if (signedIn) {
            Group controlPanelGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Control Panel");
            controlPanelPlid = LayoutLocalServiceUtil.getDefaultPlid((long)controlPanelGroup.getGroupId(), (boolean)true);
            List siteContentPortlets = PortalUtil.getControlPanelPortlets((String)"content", (ThemeDisplay)themeDisplay);
            Portlet groupPagesPortlet = PortletLocalServiceUtil.getPortletById((String)"156");
            siteContentPortlets.remove(groupPagesPortlet);
            Portlet siteMembershipsAdminPortlet = PortletLocalServiceUtil.getPortletById((String)"174");
            siteContentPortlets.remove(siteMembershipsAdminPortlet);
            Portlet siteSettingsPortlet = PortletLocalServiceUtil.getPortletById((String)"165");
            siteContentPortlets.remove(siteSettingsPortlet);
            showSiteContentIcon = PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (long)controlPanelPlid, (Collection)siteContentPortlets, (String)"VIEW");
        }
        themeDisplay.setShowSiteContentIcon(showSiteContentIcon);
        themeDisplay.setShowStagingIcon(false);
        if (PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID && !CookieKeys.hasSessionId(request)) {
            themeDisplay.setAddSessionIdToURL(true);
            themeDisplay.setSessionId(session.getId());
        }
        String urlControlPanel = friendlyURLPrivateGroupPath.concat("/control_panel");
        if (Validator.isNotNull((String)doAsUserId)) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"doAsUserId", (String)doAsUserId);
        }
        if (scopeGroupId > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"doAsGroupId", (long)scopeGroupId);
        }
        if (refererPlid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)refererPlid);
        } else if (plid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)plid);
        }
        if (themeDisplay.isAddSessionIdToURL()) {
            urlControlPanel = PortalUtil.getURLWithSessionId((String)urlControlPanel, (String)session.getId());
        }
        themeDisplay.setURLControlPanel(urlControlPanel);
        String siteContentURL = urlControlPanel;
        siteContentURL = HttpUtil.addParameter((String)siteContentURL, (String)"controlPanelCategory", (String)"content");
        themeDisplay.setURLSiteContent(siteContentURL);
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        themeDisplay.setURLCurrent(currentURL);
        String urlHome = PortalUtil.getHomeURL((HttpServletRequest)request);
        themeDisplay.setURLHome(urlHome);
        if (layout != null) {
            if (layout.isTypePortlet()) {
                boolean freeformLayout = layoutTypePortlet.getLayoutTemplateId().equals("freeform");
                themeDisplay.setFreeformLayout(freeformLayout);
                if (hasUpdateLayoutPermission) {
                    themeDisplay.setShowAddContentIconPermission(true);
                    if (!LiferayWindowState.isMaximized((HttpServletRequest)request)) {
                        themeDisplay.setShowAddContentIcon(true);
                    }
                    themeDisplay.setShowLayoutTemplatesIcon(true);
                    if (!group.isUser()) {
                        themeDisplay.setShowPageCustomizationIcon(true);
                    }
                    themeDisplay.setURLAddContent("Liferay.LayoutConfiguration.toggle('".concat("87").concat("');"));
                    themeDisplay.setURLLayoutTemplates("Liferay.LayoutConfiguration.showTemplates();");
                }
                if (hasCustomizeLayoutPermission && customizedView) {
                    themeDisplay.setShowAddContentIconPermission(true);
                    if (!LiferayWindowState.isMaximized((HttpServletRequest)request)) {
                        themeDisplay.setShowAddContentIcon(true);
                    }
                    themeDisplay.setURLAddContent("Liferay.LayoutConfiguration.toggle('".concat("87").concat("');"));
                }
            }
            if (signedIn && group.isUser() && (layout.isPrivateLayout() && !PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_MODIFIABLE || layout.isPublicLayout() && !PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_MODIFIABLE)) {
                hasUpdateLayoutPermission = false;
            }
            if (hasUpdateLayoutPermission) {
                themeDisplay.setShowPageSettingsIcon(true);
                PortletURLImpl pageSettingsURL = new PortletURLImpl(request, "88", controlPanelPlid, "RENDER_PHASE");
                pageSettingsURL.setControlPanelCategory("portlet_88");
                pageSettingsURL.setParameter("struts_action", "/layouts_admin/edit_layouts");
                if (layout.isPrivateLayout()) {
                    pageSettingsURL.setParameter("tabs1", "private-pages");
                } else {
                    pageSettingsURL.setParameter("tabs1", "public-pages");
                }
                pageSettingsURL.setParameter("closeRedirect", currentURL);
                pageSettingsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                pageSettingsURL.setParameter("selPlid", String.valueOf(plid));
                pageSettingsURL.setPortletMode(PortletMode.VIEW);
                pageSettingsURL.setWindowState(LiferayWindowState.POP_UP);
                themeDisplay.setURLPageSettings((PortletURL)pageSettingsURL);
                boolean site = group.isSite();
                if (!site && group.isStagingGroup()) {
                    Group liveGroup = group.getLiveGroup();
                    site = liveGroup.isSite();
                }
                if (site && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"ASSIGN_MEMBERS")) {
                    themeDisplay.setShowManageSiteMembershipsIcon(true);
                    PortletURLImpl manageSiteMembershipsURL = new PortletURLImpl(request, "174", controlPanelPlid, "RENDER_PHASE");
                    manageSiteMembershipsURL.setControlPanelCategory("portlet_174");
                    manageSiteMembershipsURL.setParameter("struts_action", "/sites_admin/edit_site_assignments");
                    manageSiteMembershipsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                    manageSiteMembershipsURL.setParameter("selPlid", String.valueOf(plid));
                    manageSiteMembershipsURL.setPortletMode(PortletMode.VIEW);
                    manageSiteMembershipsURL.setWindowState(LiferayWindowState.POP_UP);
                    themeDisplay.setURLManageSiteMemberships((PortletURL)manageSiteMembershipsURL);
                } else {
                    themeDisplay.setShowManageSiteMembershipsIcon(false);
                }
            }
            boolean hasAddLayoutGroupPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"ADD_LAYOUT");
            boolean hasAddLayoutLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"ADD_LAYOUT");
            boolean hasManageLayoutsGroupPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"MANAGE_LAYOUTS");
            boolean hasManageStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"MANAGE_STAGING");
            boolean hasPublishStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"PUBLISH_STAGING");
            boolean hasUpdateGroupPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"UPDATE");
            boolean hasViewStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"VIEW_STAGING");
            if (!group.isControlPanel() && !group.isUser() && !group.isUserGroup() && hasUpdateGroupPermission) {
                themeDisplay.setShowSiteSettingsIcon(true);
                PortletURLImpl siteSettingsURL = new PortletURLImpl(request, "165", controlPanelPlid, "RENDER_PHASE");
                siteSettingsURL.setControlPanelCategory("portlet_165");
                siteSettingsURL.setParameter("struts_action", "/sites_admin/edit_site");
                siteSettingsURL.setParameter("closeRedirect", currentURL);
                siteSettingsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                siteSettingsURL.setPortletMode(PortletMode.VIEW);
                siteSettingsURL.setWindowState(LiferayWindowState.POP_UP);
                themeDisplay.setURLSiteSettings((PortletURL)siteSettingsURL);
            }
            if (!group.isLayoutPrototype() && (hasAddLayoutGroupPermission || hasAddLayoutLayoutPermission || hasManageLayoutsGroupPermission || hasUpdateGroupPermission)) {
                themeDisplay.setShowSiteMapSettingsIcon(true);
                PortletURLImpl siteMapSettingsURL = new PortletURLImpl(request, "88", controlPanelPlid, "RENDER_PHASE");
                siteMapSettingsURL.setControlPanelCategory("portlet_88");
                siteMapSettingsURL.setParameter("struts_action", "/layouts_admin/edit_layouts");
                if (layout.isPrivateLayout()) {
                    siteMapSettingsURL.setParameter("tabs1", "private-pages");
                } else {
                    siteMapSettingsURL.setParameter("tabs1", "public-pages");
                }
                siteMapSettingsURL.setParameter("closeRedirect", currentURL);
                siteMapSettingsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                siteMapSettingsURL.setPortletMode(PortletMode.VIEW);
                siteMapSettingsURL.setWindowState(LiferayWindowState.POP_UP);
                themeDisplay.setURLSiteMapSettings((PortletURL)siteMapSettingsURL);
            }
            if (group.hasStagingGroup() && !group.isStagingGroup()) {
                themeDisplay.setShowAddContentIcon(false);
                themeDisplay.setShowLayoutTemplatesIcon(false);
                themeDisplay.setShowPageSettingsIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isControlPanel()) {
                themeDisplay.setShowPageSettingsIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isStaged() || group.isStagingGroup()) {
                if (hasManageStagingPermission || hasPublishStagingPermission || hasUpdateLayoutPermission || hasViewStagingPermission) {
                    themeDisplay.setShowStagingIcon(true);
                }
                if (hasPublishStagingPermission) {
                    PortletURLImpl publishToLiveURL = new PortletURLImpl(request, "88", plid, "RENDER_PHASE");
                    publishToLiveURL.setParameter("struts_action", "/layouts_admin/publish_layouts");
                    if (layout.isPrivateLayout()) {
                        publishToLiveURL.setParameter("tabs1", "private-pages");
                    } else {
                        publishToLiveURL.setParameter("tabs1", "public-pages");
                    }
                    publishToLiveURL.setParameter("pagesRedirect", currentURL);
                    publishToLiveURL.setParameter("groupId", String.valueOf(scopeGroupId));
                    publishToLiveURL.setParameter("selPlid", String.valueOf(plid));
                    publishToLiveURL.setPortletMode(PortletMode.VIEW);
                    publishToLiveURL.setWindowState(LiferayWindowState.EXCLUSIVE);
                    themeDisplay.setURLPublishToLive((PortletURL)publishToLiveURL);
                }
            }
            PortletURLImpl myAccountURL = new PortletURLImpl(request, "2", controlPanelPlid, "RENDER_PHASE");
            if (scopeGroupId > 0L) {
                myAccountURL.setDoAsGroupId(scopeGroupId);
            }
            myAccountURL.setParameter("struts_action", "/my_account/edit_user");
            myAccountURL.setPortletMode(PortletMode.VIEW);
            if (refererPlid > 0L) {
                myAccountURL.setRefererPlid(refererPlid);
            } else {
                myAccountURL.setRefererPlid(plid);
            }
            myAccountURL.setWindowState(WindowState.MAXIMIZED);
            themeDisplay.setURLMyAccount((PortletURL)myAccountURL);
        }
        if (!user.isActive() || PrefsPropsUtil.getBoolean(companyId, "terms.of.use.required") && !user.isAgreedToTermsOfUse()) {
            themeDisplay.setShowAddContentIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageSettingsIcon(false);
        }
        if (group.isLayoutPrototype()) {
            themeDisplay.setShowControlPanelIcon(false);
            themeDisplay.setShowHomeIcon(false);
            themeDisplay.setShowManageSiteMembershipsIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowPageSettingsIcon(true);
            themeDisplay.setShowPortalIcon(false);
            themeDisplay.setShowSignInIcon(false);
            themeDisplay.setShowSignOutIcon(false);
            themeDisplay.setShowSiteContentIcon(false);
            themeDisplay.setShowSiteSettingsIcon(false);
            themeDisplay.setShowStagingIcon(false);
        }
        if (group.isLayoutSetPrototype()) {
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowSiteSettingsIcon(false);
        }
        if (group.hasStagingGroup() && !group.isStagingGroup()) {
            themeDisplay.setShowLayoutTemplatesIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowPageSettingsIcon(false);
            themeDisplay.setShowSiteContentIcon(false);
            themeDisplay.setShowSiteMapSettingsIcon(false);
            themeDisplay.setShowSiteSettingsIcon(false);
        }
        themeDisplay.setURLPortal(portalURL.concat(contextPath));
        String urlSignIn = mainPath.concat("/portal/login");
        if (layout != null) {
            urlSignIn = HttpUtil.addParameter((String)urlSignIn, (String)"p_l_id", (long)layout.getPlid());
        }
        themeDisplay.setURLSignIn(urlSignIn);
        themeDisplay.setURLSignOut(mainPath.concat("/portal/logout"));
        PortletURLImpl updateManagerURL = new PortletURLImpl(request, "104", plid, "RENDER_PHASE");
        updateManagerURL.setParameter("struts_action", "/update_manager/view");
        updateManagerURL.setPortletMode(PortletMode.VIEW);
        updateManagerURL.setWindowState(WindowState.MAXIMIZED);
        themeDisplay.setURLUpdateManager((PortletURL)updateManagerURL);
        return themeDisplay;
    }

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            this.servicePre(request, response);
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Running takes " + stopWatch.getTime() + " ms"));
        }
    }

    protected void addDefaultLayoutsByLAR(long userId, long groupId, boolean privateLayout, File larFile) throws PortalException, SystemException {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_CONTROL_DEFAULT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        LayoutLocalServiceUtil.importLayouts((long)userId, (long)groupId, (boolean)privateLayout, parameterMap, (File)larFile);
    }

    protected void addDefaultUserPrivateLayoutByProperties(long userId, long groupId) throws PortalException, SystemException {
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)true, (long)0L, (String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_TEMPLATE_ID, false);
        int i = 0;
        while (i < 10) {
            String columnId = "column-" + i;
            String portletIds = PropsUtil.get("default.user.private.layout.column-" + i);
            String[] portletIdsArray = StringUtil.split((String)portletIds);
            layoutTypePortlet.addPortletIds(0L, portletIdsArray, columnId, false);
            ++i;
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    protected void addDefaultUserPrivateLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        if (this.privateLARFile != null) {
            this.addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), true, this.privateLARFile);
        } else {
            this.addDefaultUserPrivateLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    protected void addDefaultUserPublicLayoutByProperties(long userId, long groupId) throws PortalException, SystemException {
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)false, (long)0L, (String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        int i = 0;
        while (i < 10) {
            String columnId = "column-" + i;
            String portletIds = PropsUtil.get("default.user.public.layout.column-" + i);
            String[] portletIdsArray = StringUtil.split((String)portletIds);
            layoutTypePortlet.addPortletIds(0L, portletIdsArray, columnId, false);
            ++i;
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    protected void addDefaultUserPublicLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        if (this.publicLARFile != null) {
            this.addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), false, this.publicLARFile);
        } else {
            this.addDefaultUserPublicLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    protected void deleteDefaultUserPrivateLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts((long)userGroup.getGroupId(), (boolean)true, (ServiceContext)serviceContext);
    }

    protected void deleteDefaultUserPublicLayouts(User user) throws PortalException, SystemException {
        Group userGroup = user.getGroup();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts((long)userGroup.getGroupId(), (boolean)false, (ServiceContext)serviceContext);
    }

    protected Object[] getDefaultLayout(HttpServletRequest request, User user, boolean signedIn) throws PortalException, SystemException {
        Group guestGroup;
        List layouts;
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null && (layouts = LayoutLocalServiceUtil.getLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)0L)).size() > 0) {
            Layout layout = (Layout)layouts.get(0);
            return new Object[]{layout, layouts};
        }
        Layout layout = null;
        List layouts2 = null;
        if (signedIn) {
            Group userGroup = user.getGroup();
            layouts2 = LayoutLocalServiceUtil.getLayouts((long)userGroup.getGroupId(), (boolean)true, (long)0L);
            if (layouts2.size() == 0) {
                layouts2 = LayoutLocalServiceUtil.getLayouts((long)userGroup.getGroupId(), (boolean)false, (long)0L);
            }
            if (layouts2.size() > 0) {
                layout = (Layout)layouts2.get(0);
            }
            if (layout == null) {
                LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
                groupParams.put("usersGroups", new Long(user.getUserId()));
                List groups = GroupLocalServiceUtil.search((long)user.getCompanyId(), null, null, groupParams, (int)-1, (int)-1);
                for (Group group : groups) {
                    layouts2 = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)true, (long)0L);
                    if (layouts2.size() == 0) {
                        layouts2 = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                    }
                    if (layouts2.size() <= 0) continue;
                    layout = (Layout)layouts2.get(0);
                    break;
                }
            }
        }
        if (layout == null && (layouts2 = LayoutLocalServiceUtil.getLayouts((long)(guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest")).getGroupId(), (boolean)false, (long)0L)).size() > 0) {
            layout = (Layout)layouts2.get(0);
        }
        return new Object[]{layout, layouts2};
    }

    protected String getFriendlyURL(String friendlyURL) {
        friendlyURL = GetterUtil.getString((String)friendlyURL);
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    protected Object[] getViewableLayouts(HttpServletRequest request, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts) throws PortalException, SystemException {
        boolean hasViewStagingPermission;
        if (layouts == null || layouts.isEmpty()) {
            return new Object[]{layout, layouts};
        }
        Group group = layout.getGroup();
        boolean hasViewLayoutPermission = false;
        boolean bl = hasViewStagingPermission = (group.isStagingGroup() || group.isStagedRemotely()) && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"VIEW_STAGING");
        if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (boolean)false, (String)"VIEW") || hasViewStagingPermission) {
            hasViewLayoutPermission = true;
        }
        ArrayList<Layout> accessibleLayouts = new ArrayList<Layout>();
        int i = 0;
        while (i < layouts.size()) {
            Layout curLayout = layouts.get(i);
            if (!curLayout.isHidden() && (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)curLayout, (boolean)false, (String)"VIEW") || hasViewStagingPermission)) {
                if (accessibleLayouts.isEmpty() && !hasViewLayoutPermission) {
                    layout = curLayout;
                }
                accessibleLayouts.add(curLayout);
            }
            ++i;
        }
        if (accessibleLayouts.isEmpty()) {
            layouts = null;
            if (!hasViewLayoutPermission) {
                SessionErrors.add((HttpServletRequest)request, (String)LayoutPermissionException.class.getName());
            }
        } else {
            layouts = accessibleLayouts;
        }
        return new Object[]{layout, layouts};
    }

    protected Boolean hasPowerUserRole(User user) throws Exception {
        return RoleLocalServiceUtil.hasUserRole((long)user.getUserId(), (long)user.getCompanyId(), (String)"Power User", (boolean)true);
    }

    protected void initImportLARFiles() {
        String privateLARFileName = PropsValues.DEFAULT_USER_PRIVATE_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading private LAR file " + privateLARFileName));
        }
        if (Validator.isNotNull((String)privateLARFileName)) {
            this.privateLARFile = new File(privateLARFileName);
            if (!this.privateLARFile.exists()) {
                _log.error((Object)("Private LAR file " + this.privateLARFile + " does not exist"));
                this.privateLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using private LAR file " + privateLARFileName));
            }
        }
        String publicLARFileName = PropsValues.DEFAULT_USER_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    protected boolean isLoginRequest(HttpServletRequest request) {
        String mainPath;
        String requestURI = request.getRequestURI();
        return requestURI.startsWith((mainPath = PortalUtil.getPathMain()).concat("/portal/login"));
    }

    protected boolean isViewableCommunity(User user, long groupId, boolean privateLayout, PermissionChecker permissionChecker) throws PortalException, SystemException {
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)0L, (String)"VIEW");
    }

    protected boolean isViewableGroup(User user, long groupId, boolean privateLayout, long layoutId, String controlPanelCategory, PermissionChecker permissionChecker) throws PortalException, SystemException {
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)layoutId, (String)controlPanelCategory, (String)"VIEW");
    }

    protected List<Layout> mergeAdditionalLayouts(HttpServletRequest request, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts) throws PortalException, SystemException {
        Group guestGroup;
        if (layout == null || layout.isPrivateLayout()) {
            return layouts;
        }
        long layoutGroupId = layout.getGroupId();
        if (layoutGroupId != (guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest")).getGroupId()) {
            Group layoutGroup = GroupLocalServiceUtil.getGroup((long)layoutGroupId);
            UnicodeProperties typeSettingsProperties = layoutGroup.getTypeSettingsProperties();
            boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("mergeGuestPublicPages"));
            if (!mergeGuestPublicPages) {
                return layouts;
            }
            List guestLayouts = LayoutLocalServiceUtil.getLayouts((long)guestGroup.getGroupId(), (boolean)false, (long)0L);
            Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, layout, guestLayouts);
            guestLayouts = (List)viewableLayouts[1];
            if (layouts == null) {
                return guestLayouts;
            }
            layouts.addAll(0, guestLayouts);
        } else {
            HttpSession session = request.getSession();
            Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
            if (previousGroupId != null && previousGroupId != layoutGroupId) {
                Group previousGroup = null;
                try {
                    previousGroup = GroupLocalServiceUtil.getGroup((long)previousGroupId);
                }
                catch (NoSuchGroupException nsge) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)nsge);
                    }
                    return layouts;
                }
                UnicodeProperties typeSettingsProperties = previousGroup.getTypeSettingsProperties();
                boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("mergeGuestPublicPages"));
                if (!mergeGuestPublicPages) {
                    return layouts;
                }
                List previousLayouts = LayoutLocalServiceUtil.getLayouts((long)previousGroupId, (boolean)false, (long)0L);
                Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, layout, previousLayouts);
                if ((previousLayouts = (List)viewableLayouts[1]) != null) {
                    layouts.addAll(previousLayouts);
                }
            }
        }
        return layouts;
    }

    protected void rememberVisitedGroupIds(HttpServletRequest request, long currentGroupId) {
        String requestURI = GetterUtil.getString((String)request.getRequestURI());
        if (!requestURI.endsWith(_PATH_PORTAL_LAYOUT)) {
            return;
        }
        HttpSession session = request.getSession();
        Long recentGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT");
        Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
        if (recentGroupId == null) {
            recentGroupId = new Long(currentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
        } else if (recentGroupId != currentGroupId) {
            previousGroupId = new Long(recentGroupId);
            recentGroupId = new Long(currentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS", (Object)previousGroupId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Current group id " + currentGroupId));
            _log.debug((Object)("Recent group id " + recentGroupId));
            _log.debug((Object)("Previous group id " + previousGroupId));
        }
    }

    protected void servicePre(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block5: {
            String portletId;
            Portlet portlet;
            LayoutTypePortlet layoutTypePortlet;
            List portletIds;
            ThemeDisplay themeDisplay = this.initThemeDisplay(request, response);
            if (themeDisplay == null) {
                return;
            }
            request.setAttribute("THEME_DISPLAY", (Object)themeDisplay);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            boolean parallelRenderEnable = true;
            Layout layout = themeDisplay.getLayout();
            if (layout != null && (portletIds = (layoutTypePortlet = themeDisplay.getLayoutTypePortlet()).getPortletIds()).size() == 1 && (portlet = PortletLocalServiceUtil.getPortletById((String)(portletId = (String)portletIds.get(0)))) != null && !portlet.isAjaxable()) {
                parallelRenderEnable = false;
            }
            Boolean parallelRenderEnableObj = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_parallel", (boolean)parallelRenderEnable);
            request.setAttribute("PORTLET_PARALLEL_RENDER", (Object)parallelRenderEnableObj);
            long mainJournalArticleId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_j_a_id");
            if (mainJournalArticleId > 0L) {
                try {
                    JournalArticle mainJournalArticle = JournalArticleServiceUtil.getArticle((long)mainJournalArticleId);
                    AssetEntry layoutAssetEntry = AssetEntryLocalServiceUtil.getEntry((String)JournalArticle.class.getName(), (long)mainJournalArticle.getResourcePrimKey());
                    request.setAttribute("LAYOUT_ASSET_ENTRY", (Object)layoutAssetEntry);
                }
                catch (NoSuchArticleException nsae) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)nsae.getMessage());
                }
            }
        }
    }

    protected void updateUserLayouts(User user) throws Exception {
        Boolean hasPowerUserRole = null;
        boolean addDefaultUserPrivateLayouts = false;
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPrivateLayouts = true;
            if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED && !(hasPowerUserRole = this.hasPowerUserRole(user)).booleanValue()) {
                addDefaultUserPrivateLayouts = false;
            }
        }
        Boolean hasPrivateLayouts = null;
        if (addDefaultUserPrivateLayouts && !(hasPrivateLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)true))).booleanValue()) {
            this.addDefaultUserPrivateLayouts(user);
        }
        boolean deleteDefaultUserPrivateLayouts = false;
        if (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED) {
            deleteDefaultUserPrivateLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this.hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPrivateLayouts = true;
            }
        }
        if (deleteDefaultUserPrivateLayouts) {
            if (hasPrivateLayouts == null) {
                hasPrivateLayouts = LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)true);
            }
            if (hasPrivateLayouts.booleanValue()) {
                this.deleteDefaultUserPrivateLayouts(user);
            }
        }
        boolean addDefaultUserPublicLayouts = false;
        if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPublicLayouts = true;
            if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this.hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPublicLayouts = false;
                }
            }
        }
        Boolean hasPublicLayouts = null;
        if (addDefaultUserPublicLayouts && !(hasPublicLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)false))).booleanValue()) {
            this.addDefaultUserPublicLayouts(user);
        }
        boolean deleteDefaultUserPublicLayouts = false;
        if (!PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            deleteDefaultUserPublicLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this.hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPublicLayouts = true;
            }
        }
        if (deleteDefaultUserPublicLayouts) {
            if (hasPublicLayouts == null) {
                hasPublicLayouts = LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)false);
            }
            if (hasPublicLayouts.booleanValue()) {
                this.deleteDefaultUserPublicLayouts(user);
            }
        }
    }
}

