/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.BaseDefaultDDMStructureAction;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryTypeException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDefaultDocumentLibraryStructuresAction
extends BaseDefaultDDMStructureAction {
    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(GetterUtil.getLong((String)ids[0]));
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected void addDLFileEntryType(long userId, long groupId, String dlFileEntryTypeName, String dlFileEntryTypeDescription, String dynamicDDMStructureName, List<String> ddmStructureNames, ServiceContext serviceContext) throws Exception {
        ArrayList<Long> ddmStructureIds = new ArrayList<Long>();
        for (String ddmStructureName : ddmStructureNames) {
            String ddmStructureKey = ddmStructureName;
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (String)ddmStructureKey);
            if (ddmStructure == null) continue;
            ddmStructureIds.add(ddmStructure.getStructureId());
        }
        String xsd = this.getDynamicDDMStructureXSD("document-library-structures.xml", dynamicDDMStructureName);
        serviceContext.setAttribute("xsd", (Serializable)((Object)xsd));
        try {
            DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)groupId, (String)dlFileEntryTypeName);
        }
        catch (NoSuchFileEntryTypeException noSuchFileEntryTypeException) {
            DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)groupId, (String)dlFileEntryTypeName, (String)dlFileEntryTypeDescription, (long[])ArrayUtil.toArray((Long[])ddmStructureIds.toArray(new Long[ddmStructureIds.size()])), (ServiceContext)serviceContext);
        }
    }

    protected void addDLFileEntryTypes(long userId, long groupId, ServiceContext serviceContext) throws Exception {
        ArrayList<String> ddmStructureNames = new ArrayList<String>();
        this.addDLFileEntryType(userId, groupId, "Contract", "Legal Contracts", "Contract", ddmStructureNames, serviceContext);
        ddmStructureNames.clear();
        ddmStructureNames.add("Marketing Campaign Theme Metadata");
        this.addDLFileEntryType(userId, groupId, "Marketing Banner", "Marketing Banner", "Marketing Banner", ddmStructureNames, serviceContext);
        ddmStructureNames.clear();
        ddmStructureNames.add("Learning Module Metadata");
        this.addDLFileEntryType(userId, groupId, "Online Training", "Online Training", "Online Training", ddmStructureNames, serviceContext);
        ddmStructureNames.clear();
        ddmStructureNames.add("Meeting Metadata");
        this.addDLFileEntryType(userId, groupId, "Sales Presentation", "Sales Presentation", "Sales Presentation", ddmStructureNames, serviceContext);
    }

    protected void addDLRawMetadataStructures(long userId, long groupId, ServiceContext serviceContext) throws Exception {
        String xsd = this.buildDLRawMetadataXML(RawMetadataProcessorUtil.getFields());
        Document document = SAXReaderUtil.read((Reader)new StringReader(xsd));
        Element rootElement = document.getRootElement();
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            String name = structureElement.elementText("name");
            String description = structureElement.elementText("description");
            Element structureElementRootElement = structureElement.element("root");
            String structureElementRootXML = structureElementRootElement.asXML();
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (String)name);
            if (ddmStructure != null) {
                ddmStructure.setXsd(structureElementRootXML);
                DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)ddmStructure);
                continue;
            }
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(LocaleUtil.getDefault(), name);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), description);
            DDMStructureLocalServiceUtil.addStructure((long)userId, (long)groupId, (long)PortalUtil.getClassNameId(DLFileEntry.class), (String)name, nameMap, descriptionMap, (String)structureElementRootXML, (String)"xml", (int)0, (ServiceContext)serviceContext);
        }
    }

    protected String buildDLRawMetadataElementXML(String name, Field field) {
        StringBundler sb = new StringBundler(14);
        sb.append("<dynamic-element dataType=\"string\" name=\"");
        Class<?> fieldClass = field.getDeclaringClass();
        sb.append(fieldClass.getSimpleName());
        sb.append("_");
        sb.append(field.getName());
        sb.append("\" type=\"text\">");
        sb.append("<meta-data locale=\"en_US\">");
        sb.append("<entry name=\"label\"><![CDATA[metadata.");
        sb.append(fieldClass.getSimpleName());
        sb.append(".");
        sb.append(field.getName());
        sb.append("]]></entry><entry name=\"predefinedValue\">");
        sb.append("<![CDATA[]]></entry><entry name=\"required\">");
        sb.append("<![CDATA[false]]></entry><entry name=\"showLabel\">");
        sb.append("<![CDATA[true]]></entry></meta-data></dynamic-element>");
        return sb.toString();
    }

    protected String buildDLRawMetadataStructureXML(String name, Field[] fields) {
        StringBundler sb = new StringBundler(8 + fields.length);
        sb.append("<structure><name><![CDATA[");
        sb.append(name);
        sb.append("]]></name>");
        sb.append("<description><![CDATA[");
        sb.append(name);
        sb.append("]]></description>");
        sb.append("<root available-locales=\"en_US\" default-locale=\"en_US\">");
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            sb.append(this.buildDLRawMetadataElementXML(name, field));
            ++n2;
        }
        sb.append("</root></structure>");
        return sb.toString();
    }

    protected String buildDLRawMetadataXML(Map<String, Field[]> fields) {
        StringBundler sb = new StringBundler(2 + fields.size());
        sb.append("<?xml version=\"1.0\"?><root>");
        for (String key : fields.keySet()) {
            sb.append(this.buildDLRawMetadataStructureXML(key, fields.get(key)));
        }
        sb.append("</root>");
        return sb.toString();
    }

    protected void doRun(long companyId) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        Group group = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
        serviceContext.setScopeGroupId(group.getGroupId());
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        serviceContext.setUserId(defaultUserId);
        this.addDDMStructures(defaultUserId, group.getGroupId(), PortalUtil.getClassNameId(DLFileEntryMetadata.class), "document-library-structures.xml", serviceContext);
        this.addDLFileEntryTypes(defaultUserId, group.getGroupId(), serviceContext);
        this.addDLRawMetadataStructures(defaultUserId, group.getGroupId(), serviceContext);
    }
}

