/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.impl.BaseCommandReceiver;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PageCommandReceiver
extends BaseCommandReceiver {
    protected String createFolder(CommandArgument commandArgument) {
        return "0";
    }

    protected String fileUpload(CommandArgument commandArgument, String fileName, InputStream inputStream, String extension, long size) {
        return "0";
    }

    protected void getFolders(CommandArgument commandArgument, Document document, Node rootNode) {
        try {
            this._getFolders(commandArgument, document, rootNode);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    protected void getFoldersAndFiles(CommandArgument commandArgument, Document document, Node rootNode) {
        try {
            this._getFolders(commandArgument, document, rootNode);
            this._getFiles(commandArgument, document, rootNode);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    private Layout _getLayout(String layoutName, Layout layout) throws Exception {
        String friendlyURL = layout.getFriendlyURL();
        if (layoutName.equals(friendlyURL)) {
            return layout;
        }
        List layoutChildren = layout.getChildren();
        if (layoutChildren.size() == 0) {
            return null;
        }
        for (Layout layoutChild : layoutChildren) {
            Layout currentLayout = this._getLayout(layoutName, layoutChild);
            if (currentLayout == null) continue;
            return currentLayout;
        }
        return null;
    }

    private String _getLayoutName(Layout layout) {
        return layout.getFriendlyURL();
    }

    private String _getLayoutName(String folderName) {
        String layoutName = folderName.substring(folderName.lastIndexOf(126) + 1, folderName.length() - 1);
        layoutName = layoutName.replace('>', '/');
        return layoutName;
    }

    private void _getFiles(CommandArgument commandArgument, Document document, Node rootNode) throws Exception {
        if (commandArgument.getCurrentFolder().equals("/")) {
            return;
        }
        Element filesElement = document.createElement("Files");
        rootNode.appendChild(filesElement);
        Group group = commandArgument.getCurrentGroup();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
        if (("/" + commandArgument.getCurrentGroupName() + "/").equals(commandArgument.getCurrentFolder())) {
            for (Layout layout : layouts) {
                Element fileElement = document.createElement("File");
                filesElement.appendChild(fileElement);
                fileElement.setAttribute("name", this._getLayoutName(layout));
                fileElement.setAttribute("desc", this._getLayoutName(layout));
                fileElement.setAttribute("size", "");
                fileElement.setAttribute("url", PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)commandArgument.getThemeDisplay(), (boolean)false));
            }
        } else {
            String layoutName = this._getLayoutName(commandArgument.getCurrentFolder());
            Layout layout = null;
            int i = 0;
            while (i < layouts.size()) {
                layout = this._getLayout(layoutName, (Layout)layouts.get(i));
                if (layout != null) break;
                ++i;
            }
            if (layout == null) {
                return;
            }
            List layoutChildren = layout.getChildren();
            int i2 = 0;
            while (i2 < layoutChildren.size()) {
                layout = (Layout)layoutChildren.get(i2);
                Element fileElement = document.createElement("File");
                filesElement.appendChild(fileElement);
                fileElement.setAttribute("name", this._getLayoutName(layout));
                fileElement.setAttribute("desc", this._getLayoutName(layout));
                fileElement.setAttribute("size", this.getSize());
                fileElement.setAttribute("url", PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)commandArgument.getThemeDisplay(), (boolean)false));
                ++i2;
            }
        }
    }

    private void _getFolders(CommandArgument commandArgument, Document document, Node rootNode) throws Exception {
        block4: {
            List layouts;
            Element foldersElement;
            block5: {
                block3: {
                    foldersElement = document.createElement("Folders");
                    rootNode.appendChild(foldersElement);
                    if (!commandArgument.getCurrentFolder().equals("/")) break block3;
                    this.getRootFolders(commandArgument, document, foldersElement);
                    break block4;
                }
                Group group = commandArgument.getCurrentGroup();
                layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                if (!("/" + commandArgument.getCurrentGroupName() + "/").equals(commandArgument.getCurrentFolder())) break block5;
                for (Layout layout : layouts) {
                    Element folderElement = document.createElement("Folder");
                    foldersElement.appendChild(folderElement);
                    folderElement.setAttribute("name", "~" + this._getLayoutName(layout).replace('/', '>'));
                }
                break block4;
            }
            String layoutName = this._getLayoutName(commandArgument.getCurrentFolder());
            Layout layout = null;
            int i = 0;
            while (i < layouts.size()) {
                layout = this._getLayout(layoutName, (Layout)layouts.get(i));
                if (layout != null) break;
                ++i;
            }
            if (layout == null) break block4;
            List layoutChildren = layout.getChildren();
            int i2 = 0;
            while (i2 < layoutChildren.size()) {
                layout = (Layout)layoutChildren.get(i2);
                Element folderElement = document.createElement("Folder");
                foldersElement.appendChild(folderElement);
                folderElement.setAttribute("name", "~" + this._getLayoutName(layout).replace('/', '>'));
                ++i2;
            }
        }
    }
}

