/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.velocity.LiferayResourceCacheUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(ThemeHotDeployListener.class);
    private static Map<String, List<String>> _vars = new HashMap<String, List<String>>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering themes for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering themes for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml"))})[0] == null) {
            return;
        }
        this.logRegistration(servletContextName);
        List themeIds = ThemeLocalServiceUtil.init((String)servletContextName, (ServletContext)servletContext, null, (boolean)true, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        FileTimestampUtil.reset();
        _vars.put(servletContextName, themeIds);
        if (_log.isInfoEnabled()) {
            if (themeIds.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)(String.valueOf(themeIds.size()) + " themes for " + servletContextName + " are available for use"));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<String> themeIds;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((themeIds = _vars.remove(servletContextName)) != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unregistering themes for " + servletContextName));
            }
            try {
                ThemeLocalServiceUtil.uninstallThemes(themeIds);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        } else {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            LiferayResourceCacheUtil.clear();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        if (_log.isInfoEnabled()) {
            if (themeIds.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)(String.valueOf(themeIds.size()) + " themes for " + servletContextName + " was unregistered"));
            }
        }
    }

    protected void logRegistration(String servletContextName) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering themes for " + servletContextName));
        }
    }
}

