/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portlet.social.model.SocialAchievement;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.util.SocialConfigurationUtil;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class SocialHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(SocialHotDeployListener.class);
    private static Map<String, Object> _vars = new HashMap<String, Object>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering social for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering social for ", t);
        }
    }

    protected void logRegistration(String servletContextName) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering social for " + servletContextName));
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-social.xml"))})[0] == null) {
            return;
        }
        this.logRegistration(servletContextName);
        List<Object> objects = SocialConfigurationUtil.read(hotDeployEvent.getContextClassLoader(), xmls);
        _vars.put(servletContextName, objects);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Social for " + servletContextName + " is available for use"));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List objects;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((objects = (List)_vars.get(servletContextName)) == null) {
            return;
        }
        for (Object object : objects) {
            if (object instanceof SocialActivityDefinition) {
                SocialActivityDefinition activityDefinition = (SocialActivityDefinition)object;
                SocialConfigurationUtil.removeActivityDefinition(activityDefinition);
                continue;
            }
            Tuple tuple = (Tuple)object;
            SocialActivityDefinition activityDefinition = (SocialActivityDefinition)tuple.getObject(0);
            Object tupleObject1 = tuple.getObject(1);
            if (tupleObject1 instanceof SocialAchievement) {
                List achievements = activityDefinition.getAchievements();
                achievements.remove(tupleObject1);
                continue;
            }
            if (!(tupleObject1 instanceof SocialActivityCounterDefinition)) continue;
            Collection activityCounterDefinitions = activityDefinition.getActivityCounterDefinitions();
            activityCounterDefinitions.remove(tupleObject1);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Social for " + servletContextName + " was unregistered"));
        }
    }
}

