/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.apache.bridges.struts.LiferayServletContextProvider;
import com.liferay.portal.kernel.atom.AtomCollectionAdapterRegistryUtil;
import com.liferay.portal.kernel.concurrent.LockRegistry;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistry;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.spring.context.PortletContextLoaderListener;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portal.xmlrpc.XmlRpcServlet;
import com.liferay.portlet.CustomUserAttributes;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletResourceBundles;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.social.model.SocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import com.liferay.portlet.social.service.SocialActivityInterpreterLocalServiceUtil;
import com.liferay.portlet.social.service.SocialRequestInterpreterLocalServiceUtil;
import com.liferay.util.log4j.Log4JUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.Portlet;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletContext;
import org.apache.portals.bridges.struts.StrutsPortlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(PortletHotDeployListener.class);
    private static Map<String, ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>> _vars = new HashMap<String, ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>>();
    private boolean _portletAppInitialized;
    private boolean _strutsBridges;

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering portlets for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering portlets for ", t);
        }
    }

    protected void destroyPortlet(com.liferay.portal.model.Portlet portlet, Set<String> portletIds) throws Exception {
        List workflowHandlers;
        List atomCollectionAdapters;
        List schedulerEntries;
        PortletApp portletApp = portlet.getPortletApp();
        Set portletFilters = portletApp.getPortletFilters();
        for (com.liferay.portal.model.PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.destroy(portletFilter);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.destroy(portletURLListener);
        }
        List indexers = portlet.getIndexerInstances();
        for (Indexer indexer : indexers) {
            IndexerRegistryUtil.unregister((Indexer)indexer);
        }
        if (PropsValues.SCHEDULER_ENABLED && (schedulerEntries = portlet.getSchedulerEntries()) != null && !schedulerEntries.isEmpty()) {
            for (SchedulerEntry schedulerEntry : schedulerEntries) {
                SchedulerEngineUtil.unschedule((SchedulerEntry)schedulerEntry, (StorageType)StorageType.MEMORY_CLUSTERED);
            }
        }
        PollerProcessorUtil.deletePollerProcessor(portlet.getPortletId());
        POPServerUtil.deleteListener(portlet.getPopMessageListenerInstance());
        SocialActivityInterpreterLocalServiceUtil.deleteActivityInterpreter((SocialActivityInterpreter)portlet.getSocialActivityInterpreterInstance());
        SocialRequestInterpreterLocalServiceUtil.deleteRequestInterpreter((SocialRequestInterpreter)portlet.getSocialRequestInterpreterInstance());
        WebDAVUtil.deleteStorage((WebDAVStorage)portlet.getWebDAVStorageInstance());
        XmlRpcServlet.unregisterMethod(portlet.getXmlRpcMethodInstance());
        List assetRendererFactories = portlet.getAssetRendererFactoryInstances();
        if (assetRendererFactories != null) {
            AssetRendererFactoryRegistryUtil.unregister((List)assetRendererFactories);
        }
        if ((atomCollectionAdapters = portlet.getAtomCollectionAdapterInstances()) != null) {
            AtomCollectionAdapterRegistryUtil.unregister((List)atomCollectionAdapters);
        }
        if ((workflowHandlers = portlet.getWorkflowHandlerInstances()) != null) {
            WorkflowHandlerRegistryUtil.unregister((List)workflowHandlers);
        }
        PortletInstanceFactoryUtil.destroy((com.liferay.portal.model.Portlet)portlet);
        portletIds.add(portlet.getPortletId());
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        String configLocation = servletContext.getInitParameter("portalContextConfigLocation");
        Properties serviceBuilderProperties = (Properties)servletContext.getAttribute("SERVICE_BUILDER_PROPERTIES");
        if (Validator.isNotNull((String)configLocation) || serviceBuilderProperties != null) {
            String lockKey = PortletContextLoaderListener.getLockKey(servletContext);
            ReentrantLock lock = LockRegistry.allocateLock((String)lockKey, (String)lockKey);
            lock.lock();
        }
        long[] companyIds = PortalInstances.getCompanyIds();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-custom.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"))};
        if (xmls[0] == null && xmls[1] == null) {
            return;
        }
        this.logRegistration(servletContextName);
        List portlets = PortletLocalServiceUtil.initWAR((String)servletContextName, (ServletContext)servletContext, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        ClassLoader portletClassLoader = hotDeployEvent.getContextClassLoader();
        servletContext.setAttribute("PORTLET_CLASS_LOADER", (Object)portletClassLoader);
        this.initLogger(portletClassLoader);
        this._portletAppInitialized = false;
        this._strutsBridges = false;
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(portletClassLoader);
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(true);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            com.liferay.portal.model.Portlet portlet = (com.liferay.portal.model.Portlet)itr.next();
            PortletBag portletBag = this.initPortlet(portlet, portletBagFactory);
            if (portletBag == null) {
                itr.remove();
                continue;
            }
            if (this._portletAppInitialized) continue;
            this.initPortletApp(portlet, servletContextName, servletContext, portletClassLoader);
            this._portletAppInitialized = true;
        }
        if (!this._strutsBridges) {
            this._strutsBridges = GetterUtil.getBoolean((String)servletContext.getInitParameter("struts-bridges-context-provider"));
        }
        if (this._strutsBridges) {
            servletContext.setAttribute("STRUTS_BRIDGES_CONTEXT_PROVIDER", (Object)new LiferayServletContextProvider());
        }
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-display.xml"));
        PortletCategory newPortletCategory = PortletLocalServiceUtil.getWARDisplay((String)servletContextName, (String)xml);
        Object object = companyIds;
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = object[n2];
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
            if (portletCategory != null) {
                portletCategory.merge(newPortletCategory);
            } else {
                _log.error((Object)("Unable to register portlet for company " + companyId + " because it does not exist"));
            }
            ++n2;
        }
        this.processPortletProperties(servletContextName, portletClassLoader);
        for (com.liferay.portal.model.Portlet portlet : portlets) {
            List modelNames = ResourceActionsUtil.getPortletModelResources((String)portlet.getPortletId());
            long[] lArray = companyIds;
            int portletCategory = companyIds.length;
            int n3 = 0;
            while (n3 < portletCategory) {
                long companyId = lArray[n3];
                ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)portlet.getPortletId());
                for (String modelName : modelNames) {
                    ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)modelName);
                }
                ++n3;
            }
            List portletActions = ResourceActionsUtil.getPortletResourceActions((String)portlet.getPortletId());
            ResourceActionLocalServiceUtil.checkResourceActions((String)portlet.getPortletId(), (List)portletActions);
            object = modelNames.iterator();
            while (object.hasNext()) {
                String modelName = (String)object.next();
                List modelActions = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)modelActions);
            }
            long[] lArray2 = companyIds;
            int n4 = companyIds.length;
            int n5 = 0;
            while (n5 < n4) {
                long companyId = lArray2[n5];
                com.liferay.portal.model.Portlet curPortlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portlet.getPortletId());
                PortletLocalServiceUtil.checkPortlet((com.liferay.portal.model.Portlet)curPortlet);
                ++n5;
            }
        }
        for (com.liferay.portal.model.Portlet portlet : portlets) {
            boolean ready = GetterUtil.getBoolean((String)servletContext.getInitParameter("portlets-ready-by-default"), (boolean)true);
            portlet.setReady(ready);
        }
        this.registerClpMessageListeners(servletContext, portletClassLoader);
        JavadocManagerUtil.load((String)servletContextName, (ClassLoader)portletClassLoader);
        DirectServletRegistry.clearServlets();
        FileTimestampUtil.reset();
        _vars.put(servletContextName, (ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>)new ObjectValuePair((Object)companyIds, (Object)portlets));
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)(String.valueOf(portlets.size()) + " portlets for " + servletContextName + " are available for use"));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>> ovp;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((ovp = _vars.remove(servletContextName)) == null) {
            return;
        }
        long[] companyIds = (long[])ovp.getKey();
        List portlets = (List)ovp.getValue();
        HashSet<String> portletIds = new HashSet<String>();
        if (portlets != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unregistering portlets for " + servletContextName));
            }
            for (com.liferay.portal.model.Portlet portlet : portlets) {
                this.destroyPortlet(portlet, portletIds);
            }
        }
        ServletContextPool.remove((String)servletContextName);
        if (portletIds.size() > 0) {
            long[] lArray = companyIds;
            int n = companyIds.length;
            int n2 = 0;
            while (n2 < n) {
                long companyId = lArray[n2];
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                portletCategory.separate(portletIds);
                ++n2;
            }
        }
        PortletContextBagPool.remove(servletContextName);
        PortletResourceBundles.remove(servletContextName);
        this.unregisterClpMessageListeners(servletContext);
        JavadocManagerUtil.unload((String)servletContextName);
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)(String.valueOf(portlets.size()) + " portlets for " + servletContextName + " was unregistered"));
            }
        }
    }

    protected void initLogger(ClassLoader portletClassLoader) {
        Log4JUtil.configureLog4J((URL)portletClassLoader.getResource("META-INF/portal-log4j.xml"));
    }

    protected PortletBag initPortlet(com.liferay.portal.model.Portlet portlet, PortletBagFactory portletBagFactory) throws Exception {
        PortletBag portletBag = portletBagFactory.create(portlet);
        if (portletBag == null) {
            return null;
        }
        Portlet portletInstance = portletBag.getPortletInstance();
        if (ClassUtil.isSubclass(portletInstance.getClass(), (String)StrutsPortlet.class.getName())) {
            this._strutsBridges = true;
        }
        return portletBag;
    }

    protected void initPortletApp(com.liferay.portal.model.Portlet portlet, String servletContextName, ServletContext servletContext, ClassLoader portletClassLoader) throws Exception {
        PortletContextBag portletContextBag = new PortletContextBag(servletContextName);
        PortletContextBagPool.put(servletContextName, portletContextBag);
        PortletApp portletApp = portlet.getPortletApp();
        servletContext.setAttribute("com.liferay.portal.model.PortletApp", (Object)portletApp);
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Map.Entry entry : customUserAttributes.entrySet()) {
            String attrCustomClass = (String)entry.getValue();
            CustomUserAttributes customUserAttributesInstance = (CustomUserAttributes)portletClassLoader.loadClass(attrCustomClass).newInstance();
            portletContextBag.getCustomUserAttributes().put(attrCustomClass, customUserAttributesInstance);
        }
        Set portletFilters = portletApp.getPortletFilters();
        for (com.liferay.portal.model.PortletFilter portletFilter : portletFilters) {
            PortletFilter portletFilterInstance = (PortletFilter)this.newInstance(portletClassLoader, new Class[]{ActionFilter.class, EventFilter.class, PortletFilter.class, RenderFilter.class, ResourceFilter.class}, portletFilter.getFilterClass());
            portletContextBag.getPortletFilters().put(portletFilter.getFilterName(), portletFilterInstance);
        }
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((com.liferay.portal.model.Portlet)portlet, (ServletContext)servletContext);
        invokerPortlet.setPortletFilters();
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLGenerationListener portletURLListenerInstance = (PortletURLGenerationListener)this.newInstance(portletClassLoader, PortletURLGenerationListener.class, portletURLListener.getListenerClass());
            portletContextBag.getPortletURLListeners().put(portletURLListener.getListenerClass(), portletURLListenerInstance);
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected void logRegistration(String servletContextName) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering portlets for " + servletContextName));
        }
    }

    protected void processPortletProperties(String servletContextName, ClassLoader portletClassLoader) throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        Configuration portletPropertiesConfiguration = null;
        try {
            portletPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)portletClassLoader, (String)"portlet");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read portlet.properties");
            }
            return;
        }
        Properties portletProperties = portletPropertiesConfiguration.getProperties();
        if (portletProperties.size() == 0) {
            return;
        }
        String languageBundleName = portletProperties.getProperty("language.bundle");
        if (Validator.isNotNull((String)languageBundleName)) {
            Locale[] locales = LanguageUtil.getAvailableLocales();
            objectArray = locales;
            n2 = locales.length;
            n = 0;
            while (n < n2) {
                Object locale = objectArray[n];
                ResourceBundle resourceBundle = ResourceBundle.getBundle(languageBundleName, (Locale)locale, portletClassLoader);
                PortletResourceBundles.put(servletContextName, LocaleUtil.toLanguageId((Locale)locale), resourceBundle);
                ++n;
            }
        }
        String[] resourceActionConfigs = StringUtil.split((String)portletProperties.getProperty("resource.actions.configs"));
        objectArray = resourceActionConfigs;
        n2 = resourceActionConfigs.length;
        n = 0;
        while (n < n2) {
            Object resourceActionConfig = objectArray[n];
            ResourceActionsUtil.read((String)servletContextName, (ClassLoader)portletClassLoader, (String)resourceActionConfig);
            ++n;
        }
    }
}

