/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.WebDirDetector;
import com.liferay.portal.kernel.servlet.taglib.FileAvailabilityUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.tools.WebXMLBuilder;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.ant.CopyTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class ExtHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(ExtHotDeployListener.class);

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering extension environment for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering extension environment for ", t);
        }
    }

    protected void copyJar(ServletContext servletContext, String dir, String jarName) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        String jarFullName = "/WEB-INF/" + jarName + "/" + jarName + ".jar";
        InputStream is = servletContext.getResourceAsStream(jarFullName);
        if (is == null) {
            throw new HotDeployException(String.valueOf(jarFullName) + " does not exist");
        }
        String newJarFullName = String.valueOf(dir) + "ext-" + servletContextName + jarName.substring(3) + ".jar";
        StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(new File(newJarFullName)));
    }

    protected void installExt(ServletContext servletContext, ClassLoader portletClassLoader) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        String globalLibDir = PortalUtil.getGlobalLibDir();
        String portalWebDir = PortalUtil.getPortalWebDir();
        String portalLibDir = PortalUtil.getPortalLibDir();
        String pluginWebDir = WebDirDetector.getRootDir((ClassLoader)portletClassLoader);
        this.copyJar(servletContext, globalLibDir, "ext-service");
        this.copyJar(servletContext, portalLibDir, "ext-impl");
        this.copyJar(servletContext, portalLibDir, "ext-util-bridges");
        this.copyJar(servletContext, portalLibDir, "ext-util-java");
        this.copyJar(servletContext, portalLibDir, "ext-util-taglib");
        this.mergeWebXml(portalWebDir, pluginWebDir);
        CopyTask.copyDirectory((String)(String.valueOf(pluginWebDir) + "WEB-INF/ext-web/docroot"), (String)portalWebDir, (String)"", (String)"**/WEB-INF/web.xml", (boolean)true, (boolean)false);
        FileUtil.copyFile((String)(String.valueOf(pluginWebDir) + "WEB-INF/ext-" + servletContextName + ".xml"), (String)(String.valueOf(portalWebDir) + "WEB-INF/ext-" + servletContextName + ".xml"));
        ExtRegistry.registerExt(servletContext);
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String xml;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/ext-" + servletContextName + ".xml"))) == null) {
            return;
        }
        this.logRegistration(servletContextName);
        if (ExtRegistry.isRegistered(servletContextName)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Extension environment for " + servletContextName + " has been applied."));
            }
            return;
        }
        Map<String, Set<String>> conflicts = ExtRegistry.getConflicts(servletContext);
        if (!conflicts.isEmpty()) {
            StringBundler sb = new StringBundler();
            sb.append("Extension environment for " + servletContextName + " cannot be applied because of detected conflicts:");
            for (Map.Entry<String, Set<String>> entry : conflicts.entrySet()) {
                String conflictServletContextName = entry.getKey();
                Set<String> conflictFiles = entry.getValue();
                sb.append("\n\t");
                sb.append(conflictServletContextName);
                sb.append(":");
                for (String conflictFile : conflictFiles) {
                    sb.append("\n\t\t");
                    sb.append(conflictFile);
                }
            }
            _log.error((Object)sb.toString());
            return;
        }
        this.installExt(servletContext, hotDeployEvent.getContextClassLoader());
        FileAvailabilityUtil.reset();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Extension environment for " + servletContextName + " has been applied. You must reboot the server and " + "redeploy all other plugins."));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String xml;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/ext-" + servletContextName + ".xml"))) == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Extension environment for " + servletContextName + " will not be undeployed"));
        }
    }

    protected void logRegistration(String servletContextName) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering extension environment for " + servletContextName));
        }
    }

    protected void mergeWebXml(String portalWebDir, String pluginWebDir) {
        if (!FileUtil.exists((String)(String.valueOf(pluginWebDir) + "WEB-INF/ext-web/docroot/WEB-INF/web.xml"))) {
            return;
        }
        String tmpDir = String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + "/" + Time.getTimestamp();
        WebXMLBuilder.main(new String[]{String.valueOf(portalWebDir) + "WEB-INF/web.xml", String.valueOf(pluginWebDir) + "WEB-INF/ext-web/docroot/WEB-INF/web.xml", String.valueOf(tmpDir) + "/web.xml"});
        File portalWebXml = new File(String.valueOf(portalWebDir) + "WEB-INF/web.xml");
        File tmpWebXml = new File(String.valueOf(tmpDir) + "/web.xml");
        tmpWebXml.setLastModified(portalWebXml.lastModified());
        CopyTask.copyFile((File)tmpWebXml, (File)new File(String.valueOf(portalWebDir) + "WEB-INF"), (boolean)true, (boolean)true);
        FileUtil.deltree((String)tmpDir);
    }
}

