/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto.exploded.tomcat;

import com.liferay.portal.deploy.auto.exploded.tomcat.BaseExplodedTomcatListener;
import com.liferay.portal.deploy.auto.exploded.tomcat.ExplodedTomcatDeployer;
import com.liferay.portal.deploy.auto.exploded.tomcat.PHPPortletExplodedTomcatDeployer;
import com.liferay.portal.deploy.auto.exploded.tomcat.PortletExplodedTomcatDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;

public class PortletExplodedTomcatListener
extends BaseExplodedTomcatListener {
    private static Log _log = LogFactoryUtil.getLog(PortletExplodedTomcatListener.class);
    private ExplodedTomcatDeployer _deployer = new PortletExplodedTomcatDeployer();
    private PHPPortletExplodedTomcatDeployer _phpDeployer;

    protected void deploy(File file) throws AutoDeployException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + file.getPath()));
        }
        ExplodedTomcatDeployer deployer = null;
        File docBaseDir = this.getDocBaseDir(file, "index.php");
        if (docBaseDir != null) {
            deployer = this.getPhpDeployer();
        } else {
            docBaseDir = this.getDocBaseDir(file, "WEB-INF/portlet.xml");
            if (docBaseDir != null) {
                deployer = this._deployer;
            } else {
                return;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modifying portlets for " + file.getPath()));
        }
        deployer.explodedTomcatDeploy(file, docBaseDir, null);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Portlets for " + file.getPath() + " modified successfully"));
        }
        this.copyContextFile(file);
    }

    protected ExplodedTomcatDeployer getPhpDeployer() throws AutoDeployException {
        if (this._phpDeployer == null) {
            this._phpDeployer = new PHPPortletExplodedTomcatDeployer();
        }
        return this._phpDeployer;
    }
}

