/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.tools.deploy.PortletDeployer;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;

public class PortletAutoDeployer
extends PortletDeployer
implements AutoDeployer {
    private static Log _log = LogFactoryUtil.getLog(PortletAutoDeployer.class);

    public PortletAutoDeployer() {
        try {
            this.baseDir = PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
            this.destDir = DeployUtil.getAutoDeployDestDir();
            this.appServerType = ServerDetector.getServerId();
            this.auiTaglibDTD = DeployUtil.getResourcePath("aui.tld");
            this.portletTaglibDTD = DeployUtil.getResourcePath("liferay-portlet.tld");
            this.portletExtTaglibDTD = DeployUtil.getResourcePath("liferay-portlet-ext.tld");
            this.securityTaglibDTD = DeployUtil.getResourcePath("liferay-security.tld");
            this.themeTaglibDTD = DeployUtil.getResourcePath("liferay-theme.tld");
            this.uiTaglibDTD = DeployUtil.getResourcePath("liferay-ui.tld");
            this.utilTaglibDTD = DeployUtil.getResourcePath("liferay-util.tld");
            this.unpackWar = PrefsPropsUtil.getBoolean("auto.deploy.unpack.war", PropsValues.AUTO_DEPLOY_UNPACK_WAR);
            this.filePattern = "";
            this.jbossPrefix = PrefsPropsUtil.getString("auto.deploy.jboss.prefix", PropsValues.AUTO_DEPLOY_JBOSS_PREFIX);
            this.tomcatLibDir = PrefsPropsUtil.getString("auto.deploy.tomcat.lib.dir", PropsValues.AUTO_DEPLOY_TOMCAT_LIB_DIR);
            ArrayList<String> jars = new ArrayList<String>();
            this.addExtJar(jars, "ext-util-bridges.jar");
            this.addExtJar(jars, "ext-util-java.jar");
            this.addExtJar(jars, "ext-util-taglib.jar");
            this.addRequiredJar(jars, "util-bridges.jar");
            this.addRequiredJar(jars, "util-java.jar");
            this.addRequiredJar(jars, "util-taglib.jar");
            this.jars = jars;
            this.checkArguments();
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    public void autoDeploy(File file, String context) throws AutoDeployException {
        ArrayList<String> wars = new ArrayList<String>();
        wars.add(file.getName());
        this.wars = wars;
        try {
            this.deployFile(file, context);
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
    }
}

