/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import aQute.libg.header.OSGiHeader;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.osgi.service.OSGiServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

public class OSGiAutoDeployListener
implements AutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(OSGiAutoDeployListener.class);

    public void deploy(File file, String context) throws AutoDeployException {
        try {
            this.doDeploy(file, context);
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
    }

    protected void cleanUp(ZipReader zipReader, InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            inputStream = null;
        }
        if (zipReader != null) {
            try {
                zipReader.close();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void doDeploy(File file, String context) throws Exception {
        InputStream inputStream;
        ZipReader zipReader;
        Framework framework;
        block7: {
            framework = OSGiServiceUtil.getFramework();
            if (framework == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"OSGi framework is disabled or not installed");
                }
                return;
            }
            String fileName = file.getName();
            fileName = fileName.toLowerCase();
            if (file.isDirectory() || !fileName.endsWith(".jar") && !fileName.endsWith(".war")) {
                return;
            }
            zipReader = null;
            inputStream = null;
            try {
                zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
                inputStream = zipReader.getEntryAsInputStream("/META-INF/MANIFEST.MF");
                if (inputStream != null) break block7;
                this.cleanUp(zipReader, inputStream);
                return;
            }
            catch (Throwable throwable) {
                this.cleanUp(zipReader, inputStream);
                throw throwable;
            }
        }
        Manifest manifest = new Manifest(inputStream);
        Attributes attributes = manifest.getMainAttributes();
        String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
        if (Validator.isNotNull((String)bundleSymbolicName)) {
            this.installBundle(framework, file, manifest);
        }
        this.cleanUp(zipReader, inputStream);
    }

    protected Bundle getBundle(Framework framework, Manifest manifest) {
        BundleContext bundleContext = framework.getBundleContext();
        Attributes attributes = manifest.getMainAttributes();
        String bundleSymbolicNameAttribute = attributes.getValue("Bundle-SymbolicName");
        Map bundleSymbolicNamesMap = OSGiHeader.parseHeader((String)bundleSymbolicNameAttribute);
        Set bundleSymbolicNamesSet = bundleSymbolicNamesMap.keySet();
        Iterator bundleSymbolicNamesIterator = bundleSymbolicNamesSet.iterator();
        String bundleSymbolicName = (String)bundleSymbolicNamesIterator.next();
        String bundleVersionAttribute = attributes.getValue("Bundle-Version");
        Version bundleVersion = Version.parseVersion((String)bundleVersionAttribute);
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundleSymbolicName.equals(bundle.getSymbolicName()) && bundleVersion.equals((Object)bundle.getVersion())) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    protected void installBundle(Framework framework, File file, Manifest manifest) throws Exception {
        Bundle bundle = this.getBundle(framework, manifest);
        FileInputStream inputStream = new FileInputStream(file);
        if (bundle != null) {
            bundle.update((InputStream)inputStream);
        } else {
            try {
                BundleContext bundleContext = framework.getBundleContext();
                URI uri = file.toURI();
                bundle = bundleContext.installBundle(uri.toString(), (InputStream)inputStream);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (bundle == null) {
            return;
        }
        Dictionary headers = bundle.getHeaders();
        if (headers.get("Fragment-Host") != null) {
            return;
        }
        bundle.start();
    }
}

