/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LiferayPackageAutoDeployer
implements AutoDeployer {
    protected String baseDir;
    private static Log _log = LogFactoryUtil.getLog(LiferayPackageAutoDeployer.class);

    public LiferayPackageAutoDeployer() {
        try {
            this.baseDir = PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    public void autoDeploy(File file, String context) throws AutoDeployException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> enu = zipFile.entries();
                while (enu.hasMoreElements()) {
                    ZipEntry zipEntry = enu.nextElement();
                    String zipEntryFileName = zipEntry.getName();
                    if (!zipEntryFileName.endsWith(".war") && !zipEntryFileName.endsWith(".xml") && !zipEntryFileName.endsWith(".zip")) continue;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Extracting " + zipEntryFileName + " from " + file.getName()));
                    }
                    InputStream inputStream = null;
                    try {
                        inputStream = zipFile.getInputStream(zipEntry);
                        FileUtil.write((String)(String.valueOf(this.baseDir) + "/" + zipEntryFileName), (InputStream)inputStream);
                    }
                    finally {
                        StreamUtil.cleanUp((InputStream)inputStream);
                    }
                }
            }
            catch (Exception e) {
                throw new AutoDeployException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }
}

