/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard.advice;

import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.dao.shard.ShardSelector;
import com.liferay.portal.dao.shard.ShardSessionFactoryTargetSource;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Shard;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ShardLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardAdvice {
    private static Log _log = LogFactoryUtil.getLog(ShardAdvice.class);
    private static ThreadLocal<Stack<String>> _companyServiceStack = new ThreadLocal();
    private static ThreadLocal<Object> _globalCall = new ThreadLocal();
    private static ThreadLocal<String> _shardName = new InitialThreadLocal(ShardAdvice.class + "._shardName", (Object)PropsValues.SHARD_DEFAULT_NAME);
    private static ShardSelector _shardSelector;
    private ShardDataSourceTargetSource _shardDataSourceTargetSource;
    private ShardSessionFactoryTargetSource _shardSessionFactoryTargetSource;

    static {
        try {
            _shardSelector = (ShardSelector)Class.forName(PropsValues.SHARD_SELECTOR).newInstance();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        if (this._shardDataSourceTargetSource == null) {
            this._shardDataSourceTargetSource = (ShardDataSourceTargetSource)InfrastructureUtil.getShardDataSourceTargetSource();
        }
        if (this._shardSessionFactoryTargetSource == null) {
            this._shardSessionFactoryTargetSource = (ShardSessionFactoryTargetSource)InfrastructureUtil.getShardSessionFactoryTargetSource();
        }
    }

    public String getCompanyShardName(String webId, String virtualHostname, String mx, String shardName) {
        HashMap<String, String> shardParams = new HashMap<String, String>();
        shardParams.put("webId", webId);
        shardParams.put("mx", mx);
        if (virtualHostname != null) {
            shardParams.put("virtualHostname", virtualHostname);
        }
        shardName = _shardSelector.getShardName("COMPANY_SCOPE", shardName, shardParams);
        return shardName;
    }

    public String getCurrentShardName() {
        String shardName = null;
        try {
            shardName = this._getCompanyServiceStack().peek();
        }
        catch (EmptyStackException emptyStackException) {}
        if (shardName == null) {
            shardName = PropsValues.SHARD_DEFAULT_NAME;
        }
        return shardName;
    }

    public DataSource getDataSource() {
        return this._shardDataSourceTargetSource.getDataSource();
    }

    public Object getGlobalCall() {
        return _globalCall.get();
    }

    public ShardDataSourceTargetSource getShardDataSourceTargetSource() {
        return this._shardDataSourceTargetSource;
    }

    public String getShardName() {
        return _shardName.get();
    }

    public ShardSessionFactoryTargetSource getShardSessionFactoryTargetSource() {
        return this._shardSessionFactoryTargetSource;
    }

    public String popCompanyService() {
        return this._getCompanyServiceStack().pop();
    }

    public void pushCompanyService(long companyId) {
        try {
            Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)companyId);
            String shardName = shard.getName();
            this.pushCompanyService(shardName);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void pushCompanyService(String shardName) {
        this._getCompanyServiceStack().push(shardName);
    }

    public void setGlobalCall(Object obj) {
        _globalCall.set(obj);
    }

    public void setShardDataSourceTargetSource(ShardDataSourceTargetSource shardDataSourceTargetSource) {
        this._shardDataSourceTargetSource = shardDataSourceTargetSource;
    }

    public void setShardNameByCompany() throws Throwable {
        Stack<String> companyServiceStack = this._getCompanyServiceStack();
        if (companyServiceStack.isEmpty()) {
            long companyId = CompanyThreadLocal.getCompanyId();
            this._setShardNameByCompanyId(companyId);
        } else {
            String shardName = companyServiceStack.peek();
            this._setShardName(shardName);
        }
    }

    public void setShardSessionFactoryTargetSource(ShardSessionFactoryTargetSource shardSessionFactoryTargetSource) {
        this._shardSessionFactoryTargetSource = shardSessionFactoryTargetSource;
    }

    private Stack<String> _getCompanyServiceStack() {
        Stack<String> companyServiceStack = _companyServiceStack.get();
        if (companyServiceStack == null) {
            companyServiceStack = new Stack();
            _companyServiceStack.set(companyServiceStack);
        }
        return companyServiceStack;
    }

    private void _setShardName(String shardName) {
        _shardName.set(shardName);
    }

    private void _setShardNameByCompanyId(long companyId) throws PortalException, SystemException {
        if (companyId == 0L) {
            this._setShardName(PropsValues.SHARD_DEFAULT_NAME);
        } else {
            Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)companyId);
            String shardName = shard.getName();
            this._setShardName(shardName);
        }
    }
}

