/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.aop.TargetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardDataSourceTargetSource
implements TargetSource {
    private static ThreadLocal<DataSource> _dataSource = new ThreadLocal<DataSource>(){

        @Override
        protected DataSource initialValue() {
            return (DataSource)_dataSources.get(PropsValues.SHARD_DEFAULT_NAME);
        }
    };
    private static Log _log = LogFactoryUtil.getLog(ShardDataSourceTargetSource.class);
    private static String[] _availableShardNames;
    private static Map<String, DataSource> _dataSources;

    public String[] getAvailableShardNames() {
        return _availableShardNames;
    }

    public DataSource getDataSource() {
        return _dataSource.get();
    }

    public Map<String, DataSource> getDataSources() {
        return _dataSources;
    }

    public Object getTarget() throws Exception {
        return this.getDataSource();
    }

    public Class<DataSource> getTargetClass() {
        return DataSource.class;
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    public void setDataSource(String shardName) {
        _dataSource.set(_dataSources.get(shardName));
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        _dataSources = dataSources;
        Set<String> shardNames = _dataSources.keySet();
        _availableShardNames = shardNames.toArray(new String[shardNames.size()]);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Sharding configured with " + _availableShardNames.length + " data sources"));
        }
    }
}

