/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.DB2DB;
import com.liferay.portal.dao.db.DerbyDB;
import com.liferay.portal.dao.db.FirebirdDB;
import com.liferay.portal.dao.db.HypersonicDB;
import com.liferay.portal.dao.db.InformixDB;
import com.liferay.portal.dao.db.IngresDB;
import com.liferay.portal.dao.db.InterBaseDB;
import com.liferay.portal.dao.db.JDataStoreDB;
import com.liferay.portal.dao.db.MySQLDB;
import com.liferay.portal.dao.db.OracleDB;
import com.liferay.portal.dao.db.PostgreSQLDB;
import com.liferay.portal.dao.db.SAPDB;
import com.liferay.portal.dao.db.SQLServerDB;
import com.liferay.portal.dao.db.SybaseDB;
import com.liferay.portal.dao.orm.hibernate.DialectImpl;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.util.PropsValues;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.FirebirdDialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.InterbaseDialect;
import org.hibernate.dialect.JDataStoreDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SAPDBDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.Sybase11Dialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.SybaseAnywhereDialect;
import org.hibernate.dialect.SybaseDialect;

public class DBFactoryImpl
implements DBFactory {
    private static Log _log = LogFactoryUtil.getLog(DBFactoryImpl.class);
    private static DB _db;

    public DB getDB() {
        if (_db == null) {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Using dialect " + PropsValues.HIBERNATE_DIALECT));
                }
                Dialect dialect = (Dialect)InstanceFactory.newInstance((String)PropsValues.HIBERNATE_DIALECT);
                this.setDB(dialect);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return _db;
    }

    public DB getDB(Object dialect) {
        DB db = null;
        if (dialect instanceof DialectImpl) {
            DialectImpl dialectImpl = (DialectImpl)dialect;
            dialect = dialectImpl.getWrappedDialect();
        }
        if (dialect instanceof DB2Dialect) {
            db = dialect instanceof DerbyDialect ? DerbyDB.getInstance() : DB2DB.getInstance();
        } else if (dialect instanceof HSQLDialect) {
            db = HypersonicDB.getInstance();
        } else if (dialect instanceof InformixDialect) {
            db = InformixDB.getInstance();
        } else if (dialect instanceof IngresDialect) {
            db = IngresDB.getInstance();
        } else if (dialect instanceof InterbaseDialect) {
            db = dialect instanceof FirebirdDialect ? FirebirdDB.getInstance() : InterBaseDB.getInstance();
        } else if (dialect instanceof JDataStoreDialect) {
            db = JDataStoreDB.getInstance();
        } else if (dialect instanceof MySQLDialect) {
            db = MySQLDB.getInstance();
        } else if (dialect instanceof Oracle8iDialect || dialect instanceof Oracle9Dialect) {
            db = OracleDB.getInstance();
        } else if (dialect instanceof PostgreSQLDialect) {
            db = PostgreSQLDB.getInstance();
        } else if (dialect instanceof SAPDBDialect) {
            db = SAPDB.getInstance();
        } else if (dialect instanceof SQLServerDialect) {
            db = SQLServerDB.getInstance();
        } else if (dialect instanceof SybaseDialect || dialect instanceof Sybase11Dialect || dialect instanceof SybaseAnywhereDialect || dialect instanceof SybaseASE15Dialect) {
            db = SybaseDB.getInstance();
        }
        return db;
    }

    public DB getDB(String type) {
        DB db = null;
        if (type.equals("db2")) {
            db = DB2DB.getInstance();
        } else if (type.equals("derby")) {
            db = DerbyDB.getInstance();
        } else if (type.equals("firebird")) {
            db = FirebirdDB.getInstance();
        } else if (type.equals("hypersonic")) {
            db = HypersonicDB.getInstance();
        } else if (type.equals("informix")) {
            db = InformixDB.getInstance();
        } else if (type.equals("ingres")) {
            db = IngresDB.getInstance();
        } else if (type.equals("interbase")) {
            db = InterBaseDB.getInstance();
        } else if (type.equals("jdatastore")) {
            db = JDataStoreDB.getInstance();
        } else if (type.equals("mysql")) {
            db = MySQLDB.getInstance();
        } else if (type.equals("oracle")) {
            db = OracleDB.getInstance();
        } else if (type.equals("postgresql")) {
            db = PostgreSQLDB.getInstance();
        } else if (type.equals("sap")) {
            db = SAPDB.getInstance();
        } else if (type.equals("sqlserver")) {
            db = SQLServerDB.getInstance();
        } else if (type.equals("sybase")) {
            db = SybaseDB.getInstance();
        }
        return db;
    }

    public void setDB(Object dialect) {
        _db = this.getDB(dialect);
        if (_db == null) {
            Class<?> clazz = dialect.getClass();
            _log.error((Object)("No DB implementation exists for " + clazz.getName()));
        } else if (_log.isDebugEnabled()) {
            Class<?> dbClazz = _db.getClass();
            Class<?> dialectClazz = dialect.getClass();
            _log.debug((Object)("Using DB implementation " + dbClazz.getName() + " for " + dialectClazz.getName()));
        }
    }

    public void setDB(String type) {
        if (_db != null) {
            return;
        }
        _db = this.getDB(type);
        if (_db == null) {
            _log.error((Object)("No DB implementation exists for " + type));
        } else if (_log.isDebugEnabled()) {
            Class<?> clazz = _db.getClass();
            _log.debug((Object)("Using DB implementation " + clazz.getName() + " for " + type));
        }
    }
}

