/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;

public class DB2DB
extends BaseDB {
    private static String[] _DB2 = new String[]{"--", "1", "0", "'1970-01-01-00.00.00.000000'", "current timestamp", " blob", " blob", " smallint", " timestamp", " double", " integer", " bigint", " varchar(500)", " clob", " varchar", " generated always as identity", "commit"};
    private static final boolean _SUPPORTS_ALTER_COLUMN_TYPE = false;
    private static final boolean _SUPPORTS_INLINE_DISTINCT = false;
    private static final boolean _SUPPORTS_SCROLLABLE_RESULTS = false;
    private static DB2DB _instance = new DB2DB();

    public static DB getInstance() {
        return _instance;
    }

    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeLongInserts(template);
        template = this.removeNull(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    public boolean isSupportsAlterColumnType() {
        return false;
    }

    public boolean isSupportsInlineDistinct() {
        return false;
    }

    public boolean isSupportsScrollableResults() {
        return false;
    }

    public void runSQL(String template) throws IOException, SQLException {
        if (template.startsWith(ALTER_COLUMN_NAME) || template.startsWith(ALTER_COLUMN_TYPE)) {
            String[] alterSqls;
            String sql = this.buildSQL(template);
            String[] stringArray = alterSqls = StringUtil.split((String)sql, (char)';');
            int n = alterSqls.length;
            int n2 = 0;
            while (n2 < n) {
                String alterSql = stringArray[n2];
                if (!alterSql.startsWith("-- ")) {
                    this.runSQL(alterSql);
                }
                ++n2;
            }
        } else {
            super.runSQL(template);
        }
    }

    public void runSQL(String[] templates) throws IOException, SQLException {
        super.runSQL(templates);
        this._reorgTables(templates);
    }

    protected DB2DB() {
        super("db2");
    }

    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(14);
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(" pagesize 8192;\n");
        sb.append("connect to ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/portal" + suffix + "/portal" + suffix + "-db2.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/indexes/indexes-db2.sql"));
        sb.append("\n\n");
        sb.append(this.readFile(String.valueOf(sqlDir) + "/sequences/sequences-db2.sql"));
        return sb.toString();
    }

    protected String getServerName() {
        return "db2";
    }

    protected String[] getTemplate() {
        return _DB2;
    }

    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith(ALTER_COLUMN_NAME)) {
                String[] template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ add column @new-column@ @type@;\n", (String[])REWORD_TEMPLATE, (String[])template);
                line = String.valueOf(line) + StringUtil.replace((String)"update @table@ set @new-column@ = @old-column@;\n", (String[])REWORD_TEMPLATE, (String[])template);
                line = String.valueOf(line) + StringUtil.replace((String)"alter table @table@ drop column @old-column@", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith(ALTER_COLUMN_TYPE)) {
                line = "-- " + line;
            } else if (line.indexOf(DROP_INDEX) != -1) {
                String[] tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }

    private void _reorgTables(String[] templates) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        String[] stringArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            String template = stringArray[n2];
            if (template.startsWith("alter table")) {
                tableNames.add(template.split(" ")[2]);
            }
            ++n2;
        }
        if (tableNames.size() == 0) {
            return;
        }
        Connection con = null;
        CallableStatement callStmt = null;
        try {
            con = DataAccess.getConnection();
            for (String tableName : tableNames) {
                String sql = "call sysproc.admin_cmd(?)";
                callStmt = con.prepareCall(sql);
                String param = "reorg table " + tableName;
                callStmt.setString(1, param);
                callStmt.execute();
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, callStmt);
        }
    }
}

