/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.store.AdvancedFileSystemStore;
import com.liferay.portlet.documentlibrary.store.CMISStore;
import com.liferay.portlet.documentlibrary.store.FileSystemStore;
import com.liferay.portlet.documentlibrary.store.JCRStore;
import com.liferay.portlet.documentlibrary.store.S3Store;
import com.liferay.portlet.documentlibrary.store.Store;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertDocumentLibrary
extends ConvertProcess {
    private static final String[] _HOOKS = new String[]{AdvancedFileSystemStore.class.getName(), CMISStore.class.getName(), FileSystemStore.class.getName(), JCRStore.class.getName(), S3Store.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(ConvertDocumentLibrary.class);
    private Store _sourceStore;
    private Store _targetStore;

    @Override
    public String getDescription() {
        return "migrate-documents-from-one-repository-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    @Override
    public String[] getParameterNames() {
        StringBundler sb = new StringBundler(_HOOKS.length * 2 + 2);
        sb.append("dl.store.impl");
        sb.append("=");
        String[] stringArray = _HOOKS;
        int n = _HOOKS.length;
        int n2 = 0;
        while (n2 < n) {
            String hook = stringArray[n2];
            if (!hook.equals(PropsValues.DL_STORE_IMPL)) {
                sb.append(hook);
                sb.append(";");
            }
            ++n2;
        }
        return new String[]{sb.toString()};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doConvert() throws Exception {
        this._sourceStore = StoreFactory.getInstance();
        String[] values = this.getParameterValues();
        String targetStoreClassName = values[0];
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        this._targetStore = (Store)classLoader.loadClass(targetStoreClassName).newInstance();
        this.migratePortlets();
        StoreFactory.setInstance(this._targetStore);
        MaintenanceUtil.appendStatus("Please set dl.store.impl in your portal-ext.properties to use " + targetStoreClassName);
        PropsValues.DL_STORE_IMPL = targetStoreClassName;
    }

    protected List<DLFileVersion> getDLFileVersions(DLFileEntry dlFileEntry) throws SystemException {
        List dlFileVersions = dlFileEntry.getFileVersions(-1);
        return ListUtil.sort((List)dlFileVersions, (Comparator)new FileVersionVersionComparator(true));
    }

    protected void migrateDL() throws Exception {
        int count = DLFileEntryLocalServiceUtil.getFileEntriesCount();
        MaintenanceUtil.appendStatus("Migrating " + count + " document library files");
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            List dlFileEntries = DLFileEntryLocalServiceUtil.getFileEntries((int)start, (int)end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                long companyId = dlFileEntry.getCompanyId();
                long repositoryId = dlFileEntry.getDataRepositoryId();
                this.migrateDLFileEntry(companyId, repositoryId, dlFileEntry);
            }
            ++i;
        }
    }

    protected void migrateDLFileEntry(long companyId, long repositoryId, DLFileEntry fileEntry) throws Exception {
        String fileName = fileEntry.getName();
        List<DLFileVersion> dlFileVersions = this.getDLFileVersions(fileEntry);
        if (dlFileVersions.isEmpty()) {
            String versionNumber = "1.0";
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
            return;
        }
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            String versionNumber = dlFileVersion.getVersion();
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
        }
    }

    protected void migrateFile(long companyId, long repositoryId, String fileName, String versionNumber) {
        try {
            InputStream is = this._sourceStore.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
            if (versionNumber.equals("1.0")) {
                this._targetStore.addFile(companyId, repositoryId, fileName, is);
            } else {
                this._targetStore.updateFile(companyId, repositoryId, fileName, versionNumber, is);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Migration failed for " + fileName), (Throwable)e);
        }
    }

    protected void migrateFiles(long companyId, String dirName, String[] fileNames) throws Exception {
        long repositoryId = 0L;
        String versionNumber = "1.0";
        try {
            this._targetStore.addDirectory(companyId, repositoryId, dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
            ++n2;
        }
    }

    protected void migrateMB() throws Exception {
        int count = MBMessageLocalServiceUtil.getMBMessagesCount();
        MaintenanceUtil.appendStatus("Migrating message boards attachments in " + count + " messages");
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            List messages = MBMessageLocalServiceUtil.getMBMessages((int)start, (int)end);
            for (MBMessage message : messages) {
                this.migrateFiles(message.getCompanyId(), message.getAttachmentsDir(), message.getAttachmentsFiles());
            }
            ++i;
        }
    }

    protected void migratePortlets() throws Exception {
        this.migrateDL();
        this.migrateMB();
        this.migrateWiki();
    }

    protected void migrateWiki() throws Exception {
        int count = WikiPageLocalServiceUtil.getWikiPagesCount();
        MaintenanceUtil.appendStatus("Migrating wiki page attachments in " + count + " pages");
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            List wikiPages = WikiPageLocalServiceUtil.getWikiPages((int)start, (int)end);
            for (WikiPage wikiPage : wikiPages) {
                if (!wikiPage.isHead()) continue;
                this.migrateFiles(wikiPage.getCompanyId(), wikiPage.getAttachmentsDir(), wikiPage.getAttachmentsFiles());
            }
            ++i;
        }
    }
}

