/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.aop.Swallowable;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.util.PropsValues;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterableAdvice
extends AnnotationChainableMethodAdvice<Clusterable> {
    private static Log _log = LogFactoryUtil.getLog(ClusterableAdvice.class);
    private static Clusterable _nullClusterable = new Clusterable(){

        public Class<? extends Annotation> annotationType() {
            return Clusterable.class;
        }
    };
    private String _servletContextName;

    @Override
    public void afterPropertiesSet() {
        if (PropsValues.CLUSTER_LINK_ENABLED) {
            super.afterPropertiesSet();
        }
    }

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        Clusterable clusterable = (Clusterable)this.findAnnotation(methodInvocation);
        if (clusterable == _nullClusterable) {
            return;
        }
        Object thisObject = methodInvocation.getThis();
        if (!(thisObject instanceof IdentifiableBean)) {
            _log.error((Object)("Not clustering calls for " + thisObject.getClass().getName() + " because it does not implement " + IdentifiableBean.class.getName()));
            return;
        }
        Method method = methodInvocation.getMethod();
        MethodHandler methodHandler = new MethodHandler(method, methodInvocation.getArguments());
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)methodHandler, (boolean)true);
        IdentifiableBean identifiableBean = (IdentifiableBean)thisObject;
        clusterRequest.setBeanIdentifier(identifiableBean.getBeanIdentifier());
        clusterRequest.setServletContextName(this._servletContextName);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
    }

    @Override
    public boolean afterThrowing(MethodInvocation methodInvocation, Throwable throwable) throws Throwable {
        if (!(throwable instanceof Swallowable)) {
            return true;
        }
        Swallowable swallowable = (Swallowable)throwable;
        return !swallowable.isSwallowable();
    }

    @Override
    public Clusterable getNullAnnotation() {
        return _nullClusterable;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
    }
}

