/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.BaseReceiver;
import com.liferay.portal.cluster.ClusterExecutorImpl;
import com.liferay.portal.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;

public class ClusterRequestReceiver
extends BaseReceiver {
    private static Log _log = LogFactoryUtil.getLog(ClusterRequestReceiver.class);
    private ClusterExecutorImpl _clusterExecutorImpl;
    private ExecutorService _parallelExecutorService;
    private ExecutorService _serialExecutorService;

    public ClusterRequestReceiver(ClusterExecutorImpl clusterExecutorImpl) {
        this._clusterExecutorImpl = clusterExecutorImpl;
    }

    public void destroy() {
        this._parallelExecutorService.shutdownNow();
        this._serialExecutorService.shutdownNow();
    }

    public void initialize() {
        this._parallelExecutorService = PortalExecutorManagerUtil.getPortalExecutor((String)(String.valueOf(ClusterRequestReceiver.class.getName()) + "_parallel"));
        this._serialExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(String.valueOf(ClusterRequestReceiver.class.getName()) + "_serial", 5, PortalClassLoaderUtil.getClassLoader()));
    }

    public void receive(Message message) {
        boolean isProcessed;
        org.jgroups.Address sourceAddress = message.getSrc();
        JChannel controlChannel = this._clusterExecutorImpl.getControlChannel();
        org.jgroups.Address localAddress = controlChannel.getAddress();
        Object obj = message.getObject();
        if (obj == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Message content is null");
            }
            return;
        }
        if (localAddress.equals(sourceAddress) && (isProcessed = this.processLocalMessage(obj, sourceAddress))) {
            return;
        }
        if (obj instanceof ClusterRequest) {
            ClusterRequest clusterRequest = (ClusterRequest)obj;
            RequestTask requestTask = new RequestTask(clusterRequest, sourceAddress, localAddress);
            if (clusterRequest.isParallelized()) {
                this._parallelExecutorService.execute(requestTask);
            } else {
                this._serialExecutorService.execute(requestTask);
            }
        } else if (obj instanceof ClusterNodeResponse) {
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)obj;
            this.processClusterResponse(clusterNodeResponse, sourceAddress, localAddress);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to process message content of type " + obj.getClass()));
        }
    }

    protected Object invoke(String servletContextName, String beanIdentifier, MethodHandler methodHandler) throws Exception {
        if (servletContextName == null) {
            if (Validator.isNull((String)beanIdentifier)) {
                return methodHandler.invoke(true);
            }
            Object bean = PortalBeanLocatorUtil.locate((String)beanIdentifier);
            return methodHandler.invoke(bean);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader classLoader = (ClassLoader)PortletBeanLocatorUtil.locate((String)servletContextName, (String)"portletClassLoader");
            currentThread.setContextClassLoader(classLoader);
            if (Validator.isNull((String)beanIdentifier)) {
                Object object = methodHandler.invoke(true);
                return object;
            }
            Object bean = PortletBeanLocatorUtil.locate((String)servletContextName, (String)beanIdentifier);
            Object object = methodHandler.invoke(bean);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected void processClusterRequest(ClusterRequest clusterRequest, org.jgroups.Address sourceAddress, org.jgroups.Address localAddress) {
        ClusterNodeResponse clusterNodeResponse;
        block19: {
            ClusterMessageType clusterMessageType = clusterRequest.getClusterMessageType();
            if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY)) {
                ClusterNode originatingClusterNode = clusterRequest.getOriginatingClusterNode();
                if (originatingClusterNode != null) {
                    long expirationTime = System.currentTimeMillis() + PropsValues.CLUSTER_EXECUTOR_HEARTBEAT_INTERVAL * 2L;
                    this._clusterExecutorImpl.notify(new AddressImpl(sourceAddress), originatingClusterNode, expirationTime);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Content of notify message does not contain cluster node information");
                }
                return;
            }
            clusterNodeResponse = new ClusterNodeResponse();
            AddressImpl address = new AddressImpl(localAddress);
            clusterNodeResponse.setAddress((Address)address);
            clusterNodeResponse.setClusterMessageType(ClusterMessageType.EXECUTE);
            try {
                ClusterNode localClusterNode = this._clusterExecutorImpl.getLocalClusterNode();
                clusterNodeResponse.setClusterNode(localClusterNode);
            }
            catch (Exception e) {
                clusterNodeResponse.setException(e);
            }
            clusterNodeResponse.setMulticast(clusterRequest.isMulticast());
            clusterNodeResponse.setUuid(clusterRequest.getUuid());
            MethodHandler methodHandler = clusterRequest.getMethodHandler();
            if (methodHandler != null) {
                try {
                    try {
                        ClusterInvokeThreadLocal.setEnabled(false);
                        Object returnValue = this.invoke(clusterRequest.getServletContextName(), clusterRequest.getBeanIdentifier(), methodHandler);
                        if (returnValue instanceof Serializable) {
                            clusterNodeResponse.setResult(returnValue);
                        } else if (returnValue != null) {
                            clusterNodeResponse.setException((Exception)new ClusterException("Return value is not serializable"));
                        }
                    }
                    catch (Exception e) {
                        clusterNodeResponse.setException(e);
                        _log.error((Object)("Failed to invoke method " + methodHandler), (Throwable)e);
                        ClusterInvokeThreadLocal.setEnabled(true);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    ClusterInvokeThreadLocal.setEnabled(true);
                    throw throwable;
                }
                ClusterInvokeThreadLocal.setEnabled(true);
            } else {
                clusterNodeResponse.setException((Exception)new ClusterException("Payload is not of type " + MethodHandler.class.getName()));
            }
        }
        JChannel controlChannel = this._clusterExecutorImpl.getControlChannel();
        try {
            controlChannel.send(sourceAddress, localAddress, (Serializable)clusterNodeResponse);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send response message " + clusterNodeResponse), (Throwable)ce);
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    protected void processClusterResponse(ClusterNodeResponse clusterNodeResponse, org.jgroups.Address sourceAddress, org.jgroups.Address localAddress) {
        String uuid = clusterNodeResponse.getUuid();
        FutureClusterResponses futureClusterResponses = this._clusterExecutorImpl.getExecutionResults(uuid);
        if (futureClusterResponses == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to find response container for " + uuid));
            }
            return;
        }
        AddressImpl address = new AddressImpl(sourceAddress);
        if (futureClusterResponses.expectsReply((Address)address)) {
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unknown uuid " + uuid + " from " + sourceAddress));
        }
    }

    protected boolean processLocalMessage(Object message, org.jgroups.Address sourceAddress) {
        ClusterRequest clusterRequest;
        if (message instanceof ClusterRequest && (clusterRequest = (ClusterRequest)message).isSkipLocal()) {
            return true;
        }
        return this._clusterExecutorImpl.isShortcutLocalMethod();
    }

    private class RequestTask
    implements Runnable {
        private ClusterRequest _clusterRequest;
        private org.jgroups.Address _localAddress;
        private org.jgroups.Address _sourceAddress;

        public RequestTask(ClusterRequest clusterRequest, org.jgroups.Address sourceAddress, org.jgroups.Address localAddress) {
            this._clusterRequest = clusterRequest;
            this._sourceAddress = sourceAddress;
            this._localAddress = localAddress;
        }

        public void run() {
            ClusterRequestReceiver.this.processClusterRequest(this._clusterRequest, this._sourceAddress, this._localAddress);
        }
    }
}

