/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.ClusterBase;
import com.liferay.portal.cluster.ClusterForwardReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.cluster.messaging.ClusterForwardMessageListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterLinkImpl
extends ClusterBase
implements ClusterLink {
    private static final String _LIFERAY_TRANSPORT_CHANNEL = "LIFERAY-TRANSPORT-CHANNEL-";
    private static final int _MAX_CHANNEL_COUNT = Priority.values().length;
    private static Log _log = LogFactoryUtil.getLog(ClusterLinkImpl.class);
    private int _channelCount;
    private ClusterForwardMessageListener _clusterForwardMessageListener;
    private List<org.jgroups.Address> _localTransportAddresses;
    private List<JChannel> _transportChannels;

    @Override
    public void destroy() {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return;
        }
        for (JChannel jChannel : this._transportChannels) {
            jChannel.close();
        }
    }

    public List<Address> getLocalTransportAddresses() {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return Collections.emptyList();
        }
        ArrayList<Address> addresses = new ArrayList<Address>(this._localTransportAddresses.size());
        for (org.jgroups.Address address : this._localTransportAddresses) {
            addresses.add(new AddressImpl(address));
        }
        return addresses;
    }

    public List<Address> getTransportAddresses(Priority priority) {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return Collections.emptyList();
        }
        JChannel jChannel = this.getChannel(priority);
        return this.getAddresses(jChannel);
    }

    public void sendMulticastMessage(Message message, Priority priority) {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return;
        }
        JChannel jChannel = this.getChannel(priority);
        try {
            jChannel.send(null, null, (Serializable)message);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send multicast message " + message), (Throwable)ce);
        }
    }

    public void sendUnicastMessage(Address address, Message message, Priority priority) {
        if (!PropsValues.CLUSTER_LINK_ENABLED) {
            return;
        }
        org.jgroups.Address jGroupsAddress = (org.jgroups.Address)address.getRealAddress();
        JChannel jChannel = this.getChannel(priority);
        try {
            jChannel.send(jGroupsAddress, null, (Serializable)message);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send unicast message:" + message), (Throwable)ce);
        }
    }

    public void setClusterForwardMessageListener(ClusterForwardMessageListener clusterForwardMessageListener) {
        this._clusterForwardMessageListener = clusterForwardMessageListener;
    }

    protected JChannel getChannel(Priority priority) {
        int channelIndex = priority.ordinal() * this._channelCount / _MAX_CHANNEL_COUNT;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Select channel number " + channelIndex + " for priority " + priority));
        }
        return this._transportChannels.get(channelIndex);
    }

    @Override
    protected void initChannels() throws ChannelException {
        Properties transportProperties = PropsUtil.getProperties("cluster.link.channel.properties.transport", true);
        this._channelCount = transportProperties.size();
        if (this._channelCount <= 0 || this._channelCount > _MAX_CHANNEL_COUNT) {
            throw new IllegalArgumentException("Channel count must be between 1 and " + _MAX_CHANNEL_COUNT);
        }
        this._localTransportAddresses = new ArrayList<org.jgroups.Address>(this._channelCount);
        this._transportChannels = new ArrayList<JChannel>(this._channelCount);
        ArrayList<String> keys = new ArrayList<String>(this._channelCount);
        for (Object key : transportProperties.keySet()) {
            keys.add((String)key);
        }
        Collections.sort(keys);
        int i = 0;
        while (i < keys.size()) {
            String customName = (String)keys.get(i);
            String value = transportProperties.getProperty(customName);
            JChannel jChannel = this.createJChannel(value, new ClusterForwardReceiver(this._localTransportAddresses, this._clusterForwardMessageListener), _LIFERAY_TRANSPORT_CHANNEL + i);
            this._localTransportAddresses.add(jChannel.getLocalAddress());
            this._transportChannels.add(jChannel);
            ++i;
        }
    }
}

