/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.ClusterBase;
import com.liferay.portal.cluster.ClusterRequestReceiver;
import com.liferay.portal.cluster.DebuggingClusterEventListenerImpl;
import com.liferay.portal.cluster.LiveUsersClusterEventListenerImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.WeakValueConcurrentHashMap;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PortalPortEventListener;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterExecutorImpl
extends ClusterBase
implements ClusterExecutor,
PortalPortEventListener {
    private static final String _DEFAULT_CLUSTER_NAME = "LIFERAY-CONTROL-CHANNEL";
    private static Log _log = LogFactoryUtil.getLog(ClusterExecutorImpl.class);
    public ScheduledExecutorService _scheduledExecutorService;
    private CopyOnWriteArrayList<ClusterEventListener> _clusterEventListeners = new CopyOnWriteArrayList();
    private Map<String, Address> _clusterNodeAddresses = new ConcurrentHashMap<String, Address>();
    private ClusterRequestReceiver _clusterRequestReceiver;
    private JChannel _controlChannel;
    private Map<String, FutureClusterResponses> _futureClusterResponses = new WeakValueConcurrentHashMap();
    private Map<ObjectValuePair<Address, ClusterNode>, Long> _liveInstances = new ConcurrentHashMap<ObjectValuePair<Address, ClusterNode>, Long>();
    private Address _localAddress;
    private ClusterNode _localClusterNode;
    private boolean _shortcutLocalMethod;

    public void addClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addIfAbsent(clusterEventListener);
    }

    @Override
    public void afterPropertiesSet() {
        if (PropsValues.CLUSTER_EXECUTOR_DEBUG_ENABLED) {
            this.addClusterEventListener(new DebuggingClusterEventListenerImpl());
        }
        if (PropsValues.LIVE_USERS_ENABLED) {
            this.addClusterEventListener(new LiveUsersClusterEventListenerImpl());
        }
        super.afterPropertiesSet();
    }

    @Override
    public void destroy() {
        if (!this.isEnabled()) {
            return;
        }
        this._scheduledExecutorService.shutdownNow();
        this._clusterRequestReceiver.destroy();
        this._controlChannel.close();
    }

    public FutureClusterResponses execute(ClusterRequest clusterRequest) throws SystemException {
        if (!this.isEnabled()) {
            return null;
        }
        List<Address> addresses = this.prepareAddresses(clusterRequest);
        FutureClusterResponses futureClusterResponses = new FutureClusterResponses(addresses);
        if (!clusterRequest.isFireAndForget()) {
            String uuid = clusterRequest.getUuid();
            this._futureClusterResponses.put(uuid, futureClusterResponses);
        }
        if (!clusterRequest.isSkipLocal() && this._shortcutLocalMethod && addresses.remove(this.getLocalClusterNodeAddress())) {
            ClusterNodeResponse clusterNodeResponse = this.runLocalMethod(clusterRequest.getMethodHandler());
            clusterNodeResponse.setMulticast(clusterRequest.isMulticast());
            clusterNodeResponse.setUuid(clusterRequest.getUuid());
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        }
        if (clusterRequest.isMulticast()) {
            this.sendMulticastRequest(clusterRequest);
        } else {
            this.sendUnicastRequest(clusterRequest, addresses);
        }
        return futureClusterResponses;
    }

    public List<ClusterEventListener> getClusterEventListeners() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._clusterEventListeners);
    }

    public List<Address> getClusterNodeAddresses() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        this.removeExpiredInstances();
        return new ArrayList<Address>(this._clusterNodeAddresses.values());
    }

    public List<ClusterNode> getClusterNodes() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        this.removeExpiredInstances();
        Set<ObjectValuePair<Address, ClusterNode>> liveInstances = this._liveInstances.keySet();
        ArrayList<ClusterNode> liveClusterNodes = new ArrayList<ClusterNode>(liveInstances.size());
        for (ObjectValuePair<Address, ClusterNode> liveInstance : liveInstances) {
            liveClusterNodes.add((ClusterNode)liveInstance.getValue());
        }
        return liveClusterNodes;
    }

    public ClusterNode getLocalClusterNode() {
        if (!this.isEnabled()) {
            return null;
        }
        return this._localClusterNode;
    }

    public Address getLocalClusterNodeAddress() {
        if (!this.isEnabled()) {
            return null;
        }
        return this._localAddress;
    }

    public void initialize() {
        if (!this.isEnabled()) {
            return;
        }
        PortalUtil.addPortalPortEventListener((PortalPortEventListener)this);
        this._localAddress = new AddressImpl(this._controlChannel.getLocalAddress());
        try {
            this.initLocalClusterNode();
        }
        catch (SystemException se) {
            _log.error((Object)"Unable to determine local network address", (Throwable)se);
        }
        ObjectValuePair localInstance = new ObjectValuePair((Object)this._localAddress, (Object)this._localClusterNode);
        this._liveInstances.put((ObjectValuePair<Address, ClusterNode>)localInstance, Long.MAX_VALUE);
        this._clusterNodeAddresses.put(this._localClusterNode.getClusterNodeId(), this._localAddress);
        this._clusterRequestReceiver.initialize();
        this._scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(ClusterExecutorImpl.class.getName(), 5, Thread.currentThread().getContextClassLoader()));
        this._scheduledExecutorService.scheduleWithFixedDelay(new HeartbeatTask(), 0L, PropsValues.CLUSTER_EXECUTOR_HEARTBEAT_INTERVAL, TimeUnit.MILLISECONDS);
    }

    public boolean isClusterNodeAlive(Address address) {
        if (!this.isEnabled()) {
            return false;
        }
        this.removeExpiredInstances();
        return this._clusterNodeAddresses.containsValue(address);
    }

    public boolean isClusterNodeAlive(String clusterNodeId) {
        if (!this.isEnabled()) {
            return false;
        }
        this.removeExpiredInstances();
        return this._clusterNodeAddresses.containsKey(clusterNodeId);
    }

    @Override
    public boolean isEnabled() {
        return PropsValues.CLUSTER_LINK_ENABLED;
    }

    public void portalPortConfigured(int port) {
        if (!this.isEnabled() || this._localClusterNode.getPort() == PropsValues.PORTAL_INSTANCE_HTTP_PORT) {
            return;
        }
        this._localClusterNode.setPort(port);
    }

    public void removeClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.remove(clusterEventListener);
    }

    public void setClusterEventListeners(List<ClusterEventListener> clusterEventListeners) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addAllAbsent(clusterEventListeners);
    }

    public void setShortcutLocalMethod(boolean shortcutLocalMethod) {
        if (!this.isEnabled()) {
            return;
        }
        this._shortcutLocalMethod = shortcutLocalMethod;
    }

    protected void fireClusterEvent(ClusterEvent clusterEvent) {
        for (ClusterEventListener listener : this._clusterEventListeners) {
            listener.processClusterEvent(clusterEvent);
        }
    }

    protected JChannel getControlChannel() {
        return this._controlChannel;
    }

    protected FutureClusterResponses getExecutionResults(String uuid) {
        return this._futureClusterResponses.get(uuid);
    }

    @Override
    protected void initChannels() {
        Properties controlProperties = PropsUtil.getProperties((String)"cluster.link.channel.properties.control", (boolean)false);
        String controlProperty = controlProperties.getProperty("cluster.link.channel.properties.control");
        this._clusterRequestReceiver = new ClusterRequestReceiver(this);
        try {
            this._controlChannel = this.createJChannel(controlProperty, this._clusterRequestReceiver, _DEFAULT_CLUSTER_NAME);
        }
        catch (ChannelException ce) {
            _log.error((Object)ce, (Throwable)ce);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void initLocalClusterNode() throws SystemException {
        this._localClusterNode = new ClusterNode(PortalUUIDUtil.generate());
        if (PropsValues.PORTAL_INSTANCE_HTTP_PORT > 0) {
            this._localClusterNode.setPort(PropsValues.PORTAL_INSTANCE_HTTP_PORT);
        } else {
            this._localClusterNode.setPort(PortalUtil.getPortalPort((boolean)false));
        }
        try {
            InetAddress inetAddress = this.bindInetAddress;
            if (inetAddress == null) {
                inetAddress = InetAddressUtil.getLocalInetAddress();
            }
            this._localClusterNode.setInetAddress(inetAddress);
            this._localClusterNode.setHostName(inetAddress.getHostName());
        }
        catch (Exception e) {
            throw new SystemException("Unable to determine local network address", (Throwable)e);
        }
    }

    protected boolean isShortcutLocalMethod() {
        return this._shortcutLocalMethod;
    }

    protected void notify(Address address, ClusterNode clusterNode, long expirationTime) {
        this.removeExpiredInstances();
        if (System.currentTimeMillis() > expirationTime) {
            return;
        }
        ObjectValuePair liveInstance = new ObjectValuePair((Object)address, (Object)clusterNode);
        Long oldExpirationTime = this._liveInstances.remove(liveInstance);
        this._liveInstances.put((ObjectValuePair<Address, ClusterNode>)liveInstance, expirationTime);
        if (oldExpirationTime != null || this._localAddress != null && this._localAddress.equals(address)) {
            return;
        }
        this._clusterNodeAddresses.put(clusterNode.getClusterNodeId(), address);
        ClusterEvent clusterEvent = ClusterEvent.join((ClusterNode[])new ClusterNode[]{clusterNode});
        this.fireClusterEvent(clusterEvent);
    }

    protected List<Address> prepareAddresses(ClusterRequest clusterRequest) {
        boolean isMulticast = clusterRequest.isMulticast();
        ArrayList<Address> addresses = null;
        if (isMulticast) {
            addresses = this.getAddresses(this._controlChannel);
        } else {
            Collection clusterNodeIds;
            addresses = new ArrayList();
            Collection clusterNodeAddresses = clusterRequest.getTargetClusterNodeAddresses();
            if (clusterNodeAddresses != null) {
                addresses.addAll(clusterNodeAddresses);
            }
            if ((clusterNodeIds = clusterRequest.getTargetClusterNodeIds()) != null) {
                for (String clusterNodeId : clusterNodeIds) {
                    Address address = this._clusterNodeAddresses.get(clusterNodeId);
                    addresses.add(address);
                }
            }
        }
        return addresses;
    }

    protected void removeExpiredInstances() {
        if (this._liveInstances.isEmpty()) {
            return;
        }
        Set<Map.Entry<ObjectValuePair<Address, ClusterNode>, Long>> liveInstances = this._liveInstances.entrySet();
        Iterator<Map.Entry<ObjectValuePair<Address, ClusterNode>, Long>> itr = liveInstances.iterator();
        long now = System.currentTimeMillis();
        while (itr.hasNext()) {
            ObjectValuePair<Address, ClusterNode> liveInstance;
            ClusterNode clusterNode;
            Map.Entry<ObjectValuePair<Address, ClusterNode>, Long> entry = itr.next();
            long expirationTime = entry.getValue();
            if (now < expirationTime || this._localClusterNode.equals((Object)(clusterNode = (ClusterNode)(liveInstance = entry.getKey()).getValue()))) continue;
            this._clusterNodeAddresses.remove(clusterNode.getClusterNodeId());
            itr.remove();
            ClusterEvent clusterEvent = ClusterEvent.depart((ClusterNode[])new ClusterNode[]{clusterNode});
            this.fireClusterEvent(clusterEvent);
        }
    }

    protected ClusterNodeResponse runLocalMethod(MethodHandler methodHandler) {
        ClusterNodeResponse clusterNodeResponse = new ClusterNodeResponse();
        ClusterNode localClusterNode = this.getLocalClusterNode();
        clusterNodeResponse.setAddress(this.getLocalClusterNodeAddress());
        clusterNodeResponse.setClusterNode(localClusterNode);
        clusterNodeResponse.setClusterMessageType(ClusterMessageType.EXECUTE);
        if (methodHandler == null) {
            clusterNodeResponse.setException((Exception)new ClusterException("Payload is not of type " + MethodHandler.class.getName()));
            return clusterNodeResponse;
        }
        try {
            Object returnValue = methodHandler.invoke(true);
            if (returnValue instanceof Serializable) {
                clusterNodeResponse.setResult(returnValue);
            } else if (returnValue != null) {
                clusterNodeResponse.setException((Exception)new ClusterException("Return value is not serializable"));
            }
        }
        catch (Exception e) {
            clusterNodeResponse.setException(e);
        }
        return clusterNodeResponse;
    }

    protected void sendMulticastRequest(ClusterRequest clusterRequest) throws SystemException {
        try {
            this._controlChannel.send(null, null, (Serializable)clusterRequest);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send multicast message " + clusterRequest), (Throwable)ce);
            throw new SystemException("Unable to send multicast request", (Throwable)ce);
        }
    }

    protected void sendUnicastRequest(ClusterRequest clusterRequest, List<Address> addresses) throws SystemException {
        for (Address address : addresses) {
            org.jgroups.Address jGroupsAddress = (org.jgroups.Address)address.getRealAddress();
            try {
                this._controlChannel.send(jGroupsAddress, null, (Serializable)clusterRequest);
            }
            catch (ChannelException ce) {
                _log.error((Object)("Unable to send unicast message " + clusterRequest), (Throwable)ce);
                throw new SystemException("Unable to send unicast request", (Throwable)ce);
            }
        }
    }

    private class HeartbeatTask
    implements Runnable {
        private HeartbeatTask() {
        }

        public void run() {
            try {
                ClusterRequest clusterNotifyRequest = ClusterRequest.createClusterNotifyRequest((ClusterNode)ClusterExecutorImpl.this._localClusterNode);
                ClusterExecutorImpl.this.sendMulticastRequest(clusterNotifyRequest);
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to send check in request", (Throwable)e);
                }
                ClusterExecutorImpl.this._scheduledExecutorService.scheduleWithFixedDelay(new HeartbeatTask(), 0L, PropsValues.CLUSTER_EXECUTOR_HEARTBEAT_INTERVAL, TimeUnit.MILLISECONDS);
            }
        }
    }
}

