/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memory;

import com.liferay.portal.cache.memory.MemoryPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryPortalCacheManager
implements PortalCacheManager {
    private int _cacheInitialCapacity = 10000;
    private int _cacheManagerInitialCapacity = 10000;
    private Map<String, PortalCache> _portalCaches;

    public void afterPropertiesSet() {
        this._portalCaches = new ConcurrentHashMap<String, PortalCache>(this._cacheManagerInitialCapacity);
    }

    public void clearAll() {
        this._portalCaches.clear();
    }

    public PortalCache getCache(String name) {
        return this.getCache(name, false);
    }

    public PortalCache getCache(String name, boolean blocking) {
        PortalCache portalCache = this._portalCaches.get(name);
        if (portalCache == null) {
            portalCache = new MemoryPortalCache(name, this._cacheInitialCapacity);
            this._portalCaches.put(name, portalCache);
        }
        return portalCache;
    }

    public void reconfigureCaches(URL configurationURL) {
    }

    public void removeCache(String name) {
        this._portalCaches.remove(name);
    }

    public void setCacheInitialCapacity(int cacheInitialCapacity) {
        this._cacheInitialCapacity = cacheInitialCapacity;
    }

    public void setCacheManagerInitialCapacity(int cacheManagerInitialCapacity) {
        this._cacheManagerInitialCapacity = cacheManagerInitialCapacity;
    }
}

