/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memory;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryPortalCache
implements PortalCache {
    private Set<CacheListener> _cacheListeners = new ConcurrentHashSet();
    private Map<Serializable, Object> _map;
    private String _name;

    public MemoryPortalCache(String name, int initialCapacity) {
        this._name = name;
        this._map = new ConcurrentHashMap<Serializable, Object>(initialCapacity);
    }

    public void destroy() {
        this.removeAll();
        this._cacheListeners = null;
        this._map = null;
        this._name = null;
    }

    public Collection<Object> get(Collection<Serializable> keys) {
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (Serializable key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public Object get(Serializable key) {
        return this._map.get(key);
    }

    public String getName() {
        return this._name;
    }

    public void put(Serializable key, Object value) {
        Object oldValue = this._map.put(key, value);
        this.notifyPutEvents(key, value, oldValue != null);
    }

    public void put(Serializable key, Object value, int timeToLive) {
        Object oldValue = this._map.put(key, value);
        this.notifyPutEvents(key, value, oldValue != null);
    }

    public void put(Serializable key, Serializable value) {
        Object oldValue = this._map.put(key, value);
        this.notifyPutEvents(key, value, oldValue != null);
    }

    public void put(Serializable key, Serializable value, int timeToLive) {
        Object oldValue = this._map.put(key, value);
        this.notifyPutEvents(key, value, oldValue != null);
    }

    public void registerCacheListener(CacheListener cacheListener) {
        this._cacheListeners.add(cacheListener);
    }

    public void registerCacheListener(CacheListener cacheListener, CacheListenerScope cacheListenerScope) {
        this.registerCacheListener(cacheListener);
    }

    public void remove(Serializable key) {
        Object value = this._map.remove(key);
        for (CacheListener cacheListener : this._cacheListeners) {
            cacheListener.notifyEntryRemoved((PortalCache)this, key, value);
        }
    }

    public void removeAll() {
        this._map.clear();
        for (CacheListener cacheListener : this._cacheListeners) {
            cacheListener.notifyRemoveAll((PortalCache)this);
        }
    }

    public void unregisterCacheListener(CacheListener cacheListener) {
        this._cacheListeners.remove(cacheListener);
    }

    public void unregisterCacheListeners() {
        this._cacheListeners.clear();
    }

    protected void notifyPutEvents(Serializable key, Object value, boolean updated) {
        if (updated) {
            for (CacheListener cacheListener : this._cacheListeners) {
                cacheListener.notifyEntryUpdated((PortalCache)this, key, value);
            }
        } else {
            for (CacheListener cacheListener : this._cacheListeners) {
                cacheListener.notifyEntryPut((PortalCache)this, key, value);
            }
        }
    }
}

