/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.cache.memcached.MemcachedClientFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMemcachedClientFactory
implements MemcachedClientFactory {
    private static final int _DEFAULT_MEMCACHED_PORT = 11211;
    private ConnectionFactory _connectionFactory;
    private List<InetSocketAddress> _inetSocketAddresses = new ArrayList<InetSocketAddress>();

    @Override
    public void clear() {
    }

    @Override
    public void close() {
    }

    @Override
    public MemcachedClientIF getMemcachedClient() throws Exception {
        return new MemcachedClient(this._connectionFactory, this._inetSocketAddresses);
    }

    @Override
    public int getNumActive() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumIdle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateMemcachedClient(MemcachedClientIF memcachedClient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void returnMemcachedObject(MemcachedClientIF memcachedClient) {
        throw new UnsupportedOperationException();
    }

    public void setAddresses(List<String> addresses) {
        for (String address : addresses) {
            String[] hostAndPort = StringUtil.split((String)address, (char)':');
            String hostName = hostAndPort[0];
            int port = 11211;
            if (hostAndPort.length == 2) {
                port = GetterUtil.getInteger((String)hostAndPort[1]);
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(hostName, port);
            this._inetSocketAddresses.add(inetSocketAddress);
        }
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._connectionFactory = connectionFactory;
    }
}

