/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cluster.BaseReceiver;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsManager
implements CacheManagerPeerProvider,
CachePeer {
    private static Log _log = LogFactoryUtil.getLog(JGroupsManager.class);
    private static final String _SCHEME = "JGroups";
    private CacheManager _cacheManager;
    private JChannel _jChannel;

    public JGroupsManager(CacheManager cacheManager, String clusterName, String channelProperties) {
        block3: {
            try {
                this._jChannel = new JChannel(channelProperties);
                this._jChannel.setReceiver((Receiver)new EhcacheJGroupsReceiver());
                this._jChannel.connect(clusterName);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Create a new channel with properties " + this._jChannel.getProperties()));
                }
            }
            catch (Exception e) {
                if (!_log.isErrorEnabled()) break block3;
                _log.error((Object)"Unable to initialize channels", (Throwable)e);
            }
        }
        this._cacheManager = cacheManager;
    }

    public void dispose() throws CacheException {
        if (this._jChannel != null) {
            this._jChannel.close();
        }
    }

    public Address getBusLocalAddress() {
        return this._jChannel.getAddress();
    }

    public List<Address> getBusMembership() {
        return this._jChannel.getView().getMembers();
    }

    public List getElements(List list) {
        return null;
    }

    public String getGuid() {
        return null;
    }

    public List getKeys() {
        return null;
    }

    public String getName() {
        return null;
    }

    public Element getQuiet(Serializable serializable) {
        return null;
    }

    public String getScheme() {
        return _SCHEME;
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public String getUrl() {
        return null;
    }

    public String getUrlBase() {
        return null;
    }

    public void handleNotification(Serializable serializable) {
        if (serializable instanceof JGroupEventMessage) {
            this.handleJGroupsNotification((JGroupEventMessage)serializable);
        } else if (serializable instanceof List) {
            List valueList = (List)((Object)serializable);
            for (Object object : valueList) {
                if (!(object instanceof JGroupEventMessage)) continue;
                this.handleJGroupsNotification((JGroupEventMessage)object);
            }
        }
    }

    public void init() {
    }

    public List<JGroupsManager> listRemoteCachePeers(Ehcache ehcache) {
        ArrayList<JGroupsManager> cachePeers = new ArrayList<JGroupsManager>();
        cachePeers.add(this);
        return cachePeers;
    }

    public void put(Element element) {
    }

    public void registerPeer(String string) {
    }

    public boolean remove(Serializable serializable) {
        return false;
    }

    public void removeAll() {
    }

    public void send(Address address, List eventMessages) throws RemoteException {
        ArrayList<JGroupEventMessage> jGroupEventMessages = new ArrayList<JGroupEventMessage>();
        for (Object eventMessage : eventMessages) {
            if (eventMessage instanceof JGroupEventMessage) {
                JGroupEventMessage jGroupEventMessage = (JGroupEventMessage)eventMessage;
                jGroupEventMessages.add(jGroupEventMessage);
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)(eventMessage + "is not a JGroupEventMessage type"));
        }
        try {
            this._jChannel.send(address, null, jGroupEventMessages);
        }
        catch (Throwable t) {
            throw new RemoteException(t.getMessage());
        }
    }

    public void send(List eventMessages) throws RemoteException {
        this.send(null, eventMessages);
    }

    public void unregisterPeer(String string) {
    }

    protected void handleJGroupsNotification(JGroupEventMessage jGroupEventMessage) {
        Cache cache = this._cacheManager.getCache(jGroupEventMessage.getCacheName());
        if (cache == null) {
            return;
        }
        int event = jGroupEventMessage.getEvent();
        Serializable key = jGroupEventMessage.getSerializableKey();
        if (event == 1 && cache.getQuiet(key) != null) {
            cache.remove(key, true);
        } else if (event == 3) {
            cache.removeAll(true);
        } else if (event == 0) {
            Element element = jGroupEventMessage.getElement();
            cache.put(new Element(key, element.getValue()), true);
        }
    }

    private class EhcacheJGroupsReceiver
    extends BaseReceiver {
        private EhcacheJGroupsReceiver() {
        }

        public void receive(Message message) {
            Object object = message.getObject();
            if (object == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Message content is null");
                }
                return;
            }
            if (object instanceof Serializable) {
                JGroupsManager.this.handleNotification((Serializable)object);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to process message content of type " + object.getClass().getName()));
            }
        }
    }
}

