/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.PortalCacheCacheEventListener;
import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;
import net.sf.ehcache.event.RegisteredEventListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcachePortalCache
implements PortalCache {
    private Map<CacheListener, CacheEventListener> _cacheEventListeners = new ConcurrentHashMap<CacheListener, CacheEventListener>();
    private Ehcache _ehcache;

    public EhcachePortalCache(Ehcache ehcache) {
        this._ehcache = ehcache;
    }

    public void destroy() {
    }

    public Object get(Serializable key) {
        Element element = this._ehcache.get(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public Collection<Object> get(Collection<Serializable> keys) {
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (Serializable key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public String getName() {
        return this._ehcache.getName();
    }

    public void put(Serializable key, Object value) {
        Element element = new Element((Object)key, value);
        this._ehcache.put(element);
    }

    public void put(Serializable key, Object value, int timeToLive) {
        Element element = new Element((Object)key, value);
        element.setTimeToLive(timeToLive);
        this._ehcache.put(element);
    }

    public void put(Serializable key, Serializable value) {
        Element element = new Element(key, value);
        this._ehcache.put(element);
    }

    public void put(Serializable key, Serializable value, int timeToLive) {
        Element element = new Element(key, value);
        element.setTimeToLive(timeToLive);
        this._ehcache.put(element);
    }

    public void registerCacheListener(CacheListener cacheListener) {
        this.registerCacheListener(cacheListener, CacheListenerScope.ALL);
    }

    public void registerCacheListener(CacheListener cacheListener, CacheListenerScope cacheListenerScope) {
        if (this._cacheEventListeners.containsKey(cacheListener)) {
            return;
        }
        PortalCacheCacheEventListener cacheEventListener = new PortalCacheCacheEventListener(cacheListener, this);
        this._cacheEventListeners.put(cacheListener, cacheEventListener);
        NotificationScope notificationScope = this.getNotificationScope(cacheListenerScope);
        RegisteredEventListeners registeredEventListeners = this._ehcache.getCacheEventNotificationService();
        registeredEventListeners.registerListener((CacheEventListener)cacheEventListener, notificationScope);
    }

    public void remove(Serializable key) {
        this._ehcache.remove(key);
    }

    public void removeAll() {
        this._ehcache.removeAll();
    }

    public void setEhcache(Ehcache ehcache) {
        this._ehcache = ehcache;
    }

    public void unregisterCacheListener(CacheListener cacheListener) {
        CacheEventListener cacheEventListener = this._cacheEventListeners.get(cacheListener);
        if (cacheEventListener != null) {
            RegisteredEventListeners registeredEventListeners = this._ehcache.getCacheEventNotificationService();
            registeredEventListeners.unregisterListener(cacheEventListener);
        }
        this._cacheEventListeners.remove(cacheListener);
    }

    public void unregisterCacheListeners() {
        RegisteredEventListeners registeredEventListeners = this._ehcache.getCacheEventNotificationService();
        for (CacheEventListener cacheEventListener : this._cacheEventListeners.values()) {
            registeredEventListeners.unregisterListener(cacheEventListener);
        }
        this._cacheEventListeners.clear();
    }

    protected NotificationScope getNotificationScope(CacheListenerScope cacheListenerScope) {
        if (cacheListenerScope.equals((Object)CacheListenerScope.ALL)) {
            return NotificationScope.ALL;
        }
        if (cacheListenerScope.equals((Object)CacheListenerScope.LOCAL)) {
            return NotificationScope.LOCAL;
        }
        return NotificationScope.REMOTE;
    }
}

