/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.cluster;

import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEvent;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEventType;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterLinkUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;

public class EhcachePortalCacheClusterReplicator
implements CacheReplicator {
    private static final String _REPLICATE_PUTS = "replicatePuts";
    private static final String _REPLICATE_PUTS_VIA_COPY = "replicatePutsViaCopy";
    private static final String _REPLICATE_REMOVALS = "replicateRemovals";
    private static final String _REPLICATE_UPDATES = "replicateUpdates";
    private static final String _REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private boolean _replicatePuts;
    private boolean _replicatePutsViaCopy;
    private boolean _replicateRemovals = true;
    private boolean _replicateUpdates = true;
    private boolean _replicateUpdatesViaCopy;

    public EhcachePortalCacheClusterReplicator(Properties properties) {
        if (properties != null) {
            this._replicatePuts = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_PUTS));
            this._replicatePutsViaCopy = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_PUTS_VIA_COPY));
            this._replicateRemovals = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_REMOVALS), (boolean)true);
            this._replicateUpdates = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_UPDATES), (boolean)true);
            this._replicateUpdatesViaCopy = GetterUtil.getBoolean((String)properties.getProperty(_REPLICATE_UPDATES_VIA_COPY));
        }
    }

    public boolean alive() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void dispose() {
    }

    public boolean isReplicateUpdatesViaCopy() {
        return false;
    }

    public boolean notAlive() {
        return false;
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        if (!this._replicatePuts) {
            return;
        }
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(ehcache.getName(), element.getKey(), PortalCacheClusterEventType.PUT);
        if (this._replicatePutsViaCopy) {
            portalCacheClusterEvent.setElementValue(element.getValue());
        }
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        if (!this._replicateRemovals) {
            return;
        }
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(ehcache.getName(), element.getKey(), PortalCacheClusterEventType.REMOVE);
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        if (!this._replicateUpdates) {
            return;
        }
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(ehcache.getName(), element.getKey(), PortalCacheClusterEventType.UPDATE);
        if (this._replicateUpdatesViaCopy) {
            portalCacheClusterEvent.setElementValue(element.getValue());
        }
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        if (!this._replicateRemovals) {
            return;
        }
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(ehcache.getName(), (Serializable)((Object)""), PortalCacheClusterEventType.REMOVEALL);
        PortalCacheClusterLinkUtil.sendEvent((PortalCacheClusterEvent)portalCacheClusterEvent);
    }
}

