/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.bean.VelocityBeanHandler;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanLocatorImpl
implements BeanLocator {
    public static final String VELOCITY_SUFFIX = ".velocity";
    private static Log _log = LogFactoryUtil.getLog(BeanLocatorImpl.class);
    private ApplicationContext _applicationContext;
    private ClassLoader _classLoader;
    private Map<String, Object> _velocityBeans = new ConcurrentHashMap<String, Object>();

    public BeanLocatorImpl(ClassLoader classLoader, ApplicationContext applicationContext) {
        this._classLoader = classLoader;
        this._applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String[] getNames() {
        return this._applicationContext.getBeanDefinitionNames();
    }

    public Class<?> getType(String name) {
        try {
            return this._applicationContext.getType(name);
        }
        catch (Exception e) {
            throw new BeanLocatorException((Throwable)e);
        }
    }

    public Object locate(String name) throws BeanLocatorException {
        try {
            return this.doLocate(name);
        }
        catch (Exception e) {
            throw new BeanLocatorException((Throwable)e);
        }
    }

    protected Object doLocate(String name) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Locating " + name));
        }
        if (name.endsWith(VELOCITY_SUFFIX)) {
            Object bean = this._velocityBeans.get(name);
            if (bean == null) {
                String originalName = name.substring(0, name.length() - VELOCITY_SUFFIX.length());
                bean = this._applicationContext.getBean(originalName);
                Class<?> beanClass = bean.getClass();
                Class<?>[] interfaces = beanClass.getInterfaces();
                ArrayList interfacesList = new ArrayList();
                Class<?>[] classArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> clazz = classArray[n2];
                    try {
                        interfacesList.add(this._classLoader.loadClass(clazz.getName()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    ++n2;
                }
                bean = ProxyUtil.newProxyInstance((ClassLoader)this._classLoader, (Class[])interfacesList.toArray(new Class[interfacesList.size()]), (InvocationHandler)new VelocityBeanHandler(bean, this._classLoader));
                this._velocityBeans.put(name, bean);
            }
            return bean;
        }
        return this._applicationContext.getBean(name);
    }
}

