/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Company;
import java.util.Date;
import java.util.List;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEntityCollectionAdapter<T>
extends AbstractEntityCollectionAdapter<T> {
    protected String collectionName;
    private static Log _log = LogFactoryUtil.getLog(BaseEntityCollectionAdapter.class);

    public String getAuthor(RequestContext requestContext) {
        String author = null;
        try {
            Company company = AtomUtil.getCompany();
            author = company.getName();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return author;
    }

    public String getHref(RequestContext requestContext) {
        return requestContext.urlFor((Object)TargetType.TYPE_COLLECTION, (Object)this.collectionName);
    }

    public String getId(RequestContext requestContext) {
        String id = AtomUtil.createIdTagPrefix(this.collectionName);
        id = id.concat("feed");
        return id;
    }

    public String getId(T entry) {
        String id = AtomUtil.createIdTagPrefix(this.collectionName);
        id = id.concat("entry:");
        id = id.concat(this.getName(entry));
        return id;
    }

    public String getName(T entry) {
        return this.getEntryId(entry);
    }

    protected BaseEntityCollectionAdapter(String collectionName) {
        this.collectionName = collectionName;
    }

    protected String addEntryDetails(RequestContext requestContext, Entry entry, IRI feedIri, T entryObj) throws ResponseContextException {
        String link = this.getLink(entryObj, feedIri, requestContext);
        entry.addLink(link);
        List authors = this.getAuthors(entryObj, requestContext);
        if (authors != null) {
            for (Person author : authors) {
                entry.addAuthor(author);
            }
        }
        entry.setId(this.getId(entryObj));
        Text text = this.getSummary(entryObj, requestContext);
        if (text != null) {
            entry.setSummaryElement(text);
        }
        entry.setTitle(this.getTitle(entryObj));
        entry.setUpdated(this.getUpdated(entryObj));
        return link;
    }

    protected void addFeedDetails(Feed feed, RequestContext requestContext) throws ResponseContextException {
        super.addFeedDetails(feed, requestContext);
        AtomPager atomPager = AtomUtil.getPager(requestContext);
        if (atomPager != null) {
            String url = String.valueOf(requestContext.getResolvedUri());
            atomPager.setFeedPagingLinks(feed, url);
        }
    }

    protected Feed createFeedBase(RequestContext requestContext) {
        Factory factory = requestContext.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.addAuthor(this.getAuthor(requestContext));
        String url = String.valueOf(requestContext.getResolvedUri());
        url = AtomUtil.resolveCollectionUrl(url, this.collectionName);
        feed.addLink(url);
        feed.addLink(url, "self");
        feed.setId(this.getId(requestContext));
        feed.setTitle(this.getTitle(requestContext));
        feed.setUpdated(new Date());
        return feed;
    }

    protected abstract String getEntryId(T var1);
}

