/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomCollectionAdapterRegistry;
import com.liferay.portal.kernel.atom.AtomException;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomCollectionAdapterRegistryImpl
implements AtomCollectionAdapterRegistry {
    private Map<String, AtomCollectionAdapter<?>> _atomCollectionAdapters = new ConcurrentHashMap();

    public AtomCollectionAdapter<?> getAtomCollectionAdapter(String collectionName) {
        return this._atomCollectionAdapters.get(collectionName);
    }

    public List<AtomCollectionAdapter<?>> getAtomCollectionAdapters() {
        return ListUtil.fromMapValues(this._atomCollectionAdapters);
    }

    public void register(AtomCollectionAdapter<?> atomCollectionAdapter) throws AtomException {
        if (this._atomCollectionAdapters.containsKey(atomCollectionAdapter.getCollectionName())) {
            throw new AtomException("Duplicate collection name " + atomCollectionAdapter.getCollectionName());
        }
        this._atomCollectionAdapters.put(atomCollectionAdapter.getCollectionName(), atomCollectionAdapter);
    }

    public void unregister(AtomCollectionAdapter<?> atomCollectionAdapter) {
        this._atomCollectionAdapters.remove(atomCollectionAdapter.getCollectionName());
    }
}

