/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asset;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import java.util.Locale;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class LayoutRevisionAssetRenderer
extends BaseAssetRenderer {
    private LayoutRevision _layoutRevision;
    private LayoutSetBranch _layoutSetBranch;

    public LayoutRevisionAssetRenderer(LayoutRevision layoutRevision) {
        this._layoutRevision = layoutRevision;
        try {
            this._layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)this._layoutRevision.getLayoutSetBranchId());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public long getClassPK() {
        return this._layoutRevision.getLayoutRevisionId();
    }

    public long getGroupId() {
        return this._layoutRevision.getGroupId();
    }

    public String getSummary(Locale locale) {
        StringBundler sb = new StringBundler(12);
        sb.append("<strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"layout"));
        sb.append(":</strong> ");
        sb.append(this._layoutRevision.getHTMLTitle(locale));
        sb.append("<br /><strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"branch"));
        sb.append(":</strong> ");
        sb.append(this._layoutSetBranch.getName());
        sb.append("<br /><strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)"revision-id"));
        sb.append(":</strong> ");
        sb.append(this._layoutRevision.getLayoutRevisionId());
        return sb.toString();
    }

    public String getTitle(Locale locale) {
        StringBundler sb = new StringBundler(4);
        sb.append(this._layoutRevision.getHTMLTitle(locale));
        sb.append(" [");
        sb.append(this._layoutSetBranch.getName());
        sb.append("]");
        return sb.toString();
    }

    public long getUserId() {
        return this._layoutRevision.getUserId();
    }

    public String getUuid() {
        return null;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("full_content")) {
            renderRequest.setAttribute("LAYOUT_REVISION", (Object)this._layoutRevision);
            return "/html/portlet/layouts_admin/asset/" + template + ".jsp";
        }
        return null;
    }
}

