/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.action.RenderPortletAction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.util.servlet.DynamicServletRequest;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class UpdateLayoutAction
extends JSONAction {
    public String getJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        boolean updateLayout = true;
        boolean deletePortlet = false;
        if (cmd.equals("add")) {
            String columnId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_col_id", null);
            int columnPos = ParamUtil.getInteger((HttpServletRequest)request, (String)"p_p_col_pos", (int)-1);
            portletId = layoutTypePortlet.addPortletId(userId, portletId, columnId, columnPos);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("delete")) {
            if (layoutTypePortlet.hasPortletId(portletId)) {
                layoutTypePortlet.removePortletId(userId, portletId);
                if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView()) {
                    updateLayout = false;
                    deletePortlet = false;
                } else {
                    deletePortlet = true;
                }
            }
        } else if (cmd.equals("drag")) {
            if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE")) {
                String height = ParamUtil.getString((HttpServletRequest)request, (String)"height");
                String width = ParamUtil.getString((HttpServletRequest)request, (String)"width");
                String top = ParamUtil.getString((HttpServletRequest)request, (String)"top");
                String left = ParamUtil.getString((HttpServletRequest)request, (String)"left");
                PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                StringBundler sb = new StringBundler(12);
                sb.append("height=");
                sb.append(height);
                sb.append("\n");
                sb.append("width=");
                sb.append(width);
                sb.append("\n");
                sb.append("top=");
                sb.append(top);
                sb.append("\n");
                sb.append("left=");
                sb.append(left);
                sb.append("\n");
                preferences.setValue("portlet-freeform-styles", sb.toString());
                preferences.store();
            }
        } else if (cmd.equals("minimize")) {
            boolean restore = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_restore");
            if (restore) {
                layoutTypePortlet.removeStateMinPortletId(portletId);
            } else {
                layoutTypePortlet.addStateMinPortletId(portletId);
            }
            updateLayout = false;
        } else if (cmd.equals("move")) {
            String columnId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_col_id");
            int columnPos = ParamUtil.getInteger((HttpServletRequest)request, (String)"p_p_col_pos");
            layoutTypePortlet.movePortletId(userId, portletId, columnId, columnPos);
            if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView() && !layoutTypePortlet.isColumnDisabled(columnId)) {
                updateLayout = false;
            }
        } else if (cmd.equals("redo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            LayoutRevisionLocalServiceUtil.updateStatus((long)userId, (long)layoutRevisionId, (int)2, (ServiceContext)serviceContext);
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutSetBranchId, (long)layout.getPlid(), (long)layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("select_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutSetBranchId");
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutSetBranchId, (long)layout.getPlid(), (long)layoutRevisionId);
            updateLayout = false;
        } else if (cmd.equals("toggle_customized_view")) {
            updateLayout = false;
        } else if (cmd.equals("update_type_settings")) {
            UnicodeProperties layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
            UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((HttpServletRequest)request, (String)"TypeSettingsProperties--");
            layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
        } else if (cmd.equals("undo_layout_revision")) {
            long layoutRevisionId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutRevisionId");
            long layoutSetBranchId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutSetBranchId");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.updateStatus((long)userId, (long)layoutRevisionId, (int)5, (ServiceContext)serviceContext);
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutSetBranchId, (long)layout.getPlid(), (long)layoutRevision.getParentLayoutRevisionId());
            updateLayout = false;
        }
        if (updateLayout) {
            layoutTypePortlet.resetModes();
            layoutTypePortlet.resetStates();
            layout = LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            if (deletePortlet) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                ResourceLocalServiceUtil.deleteResource((long)layout.getCompanyId(), (String)rootPortletId, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
            }
        } else {
            LayoutClone layoutClone = LayoutCloneFactory.getInstance();
            if (layoutClone != null) {
                layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
            }
        }
        if (cmd.equals("add") && portletId != null) {
            this.addPortlet(mapping, form, request, response, portletId);
        }
        return "";
    }

    protected void addPortlet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String portletId) throws Exception {
        Action renderPortletAction = (Action)InstancePool.get((String)RenderPortletAction.class.getName());
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        DynamicServletRequest dynamicRequest = null;
        if (portlet.isPrivateRequestAttributes()) {
            String portletNamespace = PortalUtil.getPortletNamespace((String)portlet.getPortletId());
            dynamicRequest = new NamespaceServletRequest(request, portletNamespace, portletNamespace);
        } else {
            dynamicRequest = new DynamicServletRequest(request);
        }
        dynamicRequest.setParameter("p_p_id", portletId);
        String dataType = ParamUtil.getString((HttpServletRequest)request, (String)"dataType");
        if (dataType.equals("json")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            StringServletResponse stringResponse = new StringServletResponse(response);
            renderPortletAction.execute(mapping, form, (HttpServletRequest)dynamicRequest, (HttpServletResponse)stringResponse);
            this.populatePortletJSONObject(request, stringResponse, portlet, jsonObject);
            response.setContentType("text/javascript");
            ServletResponseUtil.write((HttpServletResponse)response, (String)jsonObject.toString());
        } else {
            renderPortletAction.execute(mapping, form, (HttpServletRequest)dynamicRequest, response);
        }
    }

    protected String getRootPortletId(Portlet portlet) {
        Portlet rootPortlet = portlet.getRootPortlet();
        return rootPortlet.getPortletId();
    }

    protected void populatePortletJSONObject(HttpServletRequest request, StringServletResponse stringResponse, Portlet portlet, JSONObject jsonObject) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        jsonObject.put("refresh", !portlet.isAjaxable());
        jsonObject.put("portletHTML", stringResponse.getString().trim());
        LinkedHashSet<String> footerCssSet = new LinkedHashSet<String>();
        LinkedHashSet<String> footerJavaScriptSet = new LinkedHashSet<String>();
        LinkedHashSet<String> headerCssSet = new LinkedHashSet<String>();
        LinkedHashSet<String> headerJavaScriptSet = new LinkedHashSet<String>();
        boolean portletOnLayout = false;
        String rootPortletId = this.getRootPortletId(portlet);
        String portletId = portlet.getPortletId();
        for (Portlet layoutPortlet : layoutTypePortlet.getAllPortlets()) {
            String layoutPortletRootPortletId = this.getRootPortletId(layoutPortlet);
            if (!rootPortletId.equals(layoutPortletRootPortletId) || portletId.equals(layoutPortlet.getPortletId())) continue;
            portletOnLayout = true;
            break;
        }
        PortletApp portletApp = portlet.getPortletApp();
        if (!portletOnLayout && portlet.isAjaxable()) {
            Portlet rootPortlet = portlet.getRootPortlet();
            for (String footerPortalCss : portlet.getFooterPortalCss()) {
                if (!HttpUtil.hasProtocol((String)footerPortalCss)) {
                    footerPortalCss = String.valueOf(PortalUtil.getPathContext()) + footerPortalCss;
                    footerPortalCss = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)footerPortalCss, (long)rootPortlet.getTimestamp());
                }
                footerCssSet.add(footerPortalCss);
            }
            for (String footerPortalJavaScript : portlet.getFooterPortalJavaScript()) {
                if (!HttpUtil.hasProtocol((String)footerPortalJavaScript)) {
                    footerPortalJavaScript = String.valueOf(PortalUtil.getPathContext()) + footerPortalJavaScript;
                    footerPortalJavaScript = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)footerPortalJavaScript, (long)rootPortlet.getTimestamp());
                }
                footerJavaScriptSet.add(footerPortalJavaScript);
            }
            for (String footerPortletCss : portlet.getFooterPortletCss()) {
                if (!HttpUtil.hasProtocol((String)footerPortletCss)) {
                    footerPortletCss = String.valueOf(portletApp.getContextPath()) + footerPortletCss;
                    footerPortletCss = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)footerPortletCss, (long)rootPortlet.getTimestamp());
                }
                footerCssSet.add(footerPortletCss);
            }
            for (String footerPortletJavaScript : portlet.getFooterPortletJavaScript()) {
                if (!HttpUtil.hasProtocol((String)footerPortletJavaScript)) {
                    footerPortletJavaScript = String.valueOf(portletApp.getContextPath()) + footerPortletJavaScript;
                    footerPortletJavaScript = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)footerPortletJavaScript, (long)rootPortlet.getTimestamp());
                }
                footerJavaScriptSet.add(footerPortletJavaScript);
            }
            for (String headerPortalCss : portlet.getHeaderPortalCss()) {
                if (!HttpUtil.hasProtocol((String)headerPortalCss)) {
                    headerPortalCss = String.valueOf(PortalUtil.getPathContext()) + headerPortalCss;
                    headerPortalCss = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)headerPortalCss, (long)rootPortlet.getTimestamp());
                }
                headerCssSet.add(headerPortalCss);
            }
            for (String headerPortalJavaScript : portlet.getHeaderPortalJavaScript()) {
                if (!HttpUtil.hasProtocol((String)headerPortalJavaScript)) {
                    headerPortalJavaScript = String.valueOf(PortalUtil.getPathContext()) + headerPortalJavaScript;
                    headerPortalJavaScript = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)headerPortalJavaScript, (long)rootPortlet.getTimestamp());
                }
                headerJavaScriptSet.add(headerPortalJavaScript);
            }
            for (String headerPortletCss : portlet.getHeaderPortletCss()) {
                if (!HttpUtil.hasProtocol((String)headerPortletCss)) {
                    headerPortletCss = String.valueOf(portletApp.getContextPath()) + headerPortletCss;
                    headerPortletCss = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)headerPortletCss, (long)rootPortlet.getTimestamp());
                }
                headerCssSet.add(headerPortletCss);
            }
            for (String headerPortletJavaScript : portlet.getHeaderPortletJavaScript()) {
                if (!HttpUtil.hasProtocol((String)headerPortletJavaScript)) {
                    headerPortletJavaScript = String.valueOf(portletApp.getContextPath()) + headerPortletJavaScript;
                    headerPortletJavaScript = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)headerPortletJavaScript, (long)rootPortlet.getTimestamp());
                }
                headerJavaScriptSet.add(headerPortletJavaScript);
            }
        }
        String footerCssPaths = JSONFactoryUtil.serialize((Object)footerCssSet.toArray(new String[footerCssSet.size()]));
        jsonObject.put("footerCssPaths", JSONFactoryUtil.createJSONArray((String)footerCssPaths));
        String footerJavaScriptPaths = JSONFactoryUtil.serialize((Object)footerJavaScriptSet.toArray(new String[footerJavaScriptSet.size()]));
        jsonObject.put("footerJavaScriptPaths", JSONFactoryUtil.createJSONArray((String)footerJavaScriptPaths));
        String headerCssPaths = JSONFactoryUtil.serialize((Object)headerCssSet.toArray(new String[headerCssSet.size()]));
        jsonObject.put("headerCssPaths", JSONFactoryUtil.createJSONArray((String)headerCssPaths));
        String headerJavaScriptPaths = JSONFactoryUtil.serialize((Object)headerJavaScriptSet.toArray(new String[headerJavaScriptSet.size()]));
        jsonObject.put("headerJavaScriptPaths", JSONFactoryUtil.createJSONArray((String)headerJavaScriptPaths));
    }
}

