/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RESTProxyAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(RESTProxyAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String url = ParamUtil.getString((HttpServletRequest)request, (String)"url");
        if (!this.validate(url)) {
            return null;
        }
        Http.Options options = new Http.Options();
        int pos = url.indexOf(63);
        if (pos != -1) {
            options.setBody(url.substring(pos + 1), "application/x-www-form-urlencoded", "UTF-8");
            options.setLocation(url.substring(0, pos));
        } else {
            options.setLocation(url);
        }
        options.setPost(true);
        String content = HttpUtil.URLtoString((Http.Options)options);
        ServletResponseUtil.write((HttpServletResponse)response, (String)content);
        return null;
    }

    protected boolean validate(String url) {
        if (Validator.isNull((String)url) || !HttpUtil.hasDomain((String)url)) {
            return false;
        }
        String domain = StringUtil.split((String)HttpUtil.getDomain((String)url), (char)':')[0];
        try {
            CompanyLocalServiceUtil.getCompanyByVirtualHost((String)domain);
            return true;
        }
        catch (Exception exception) {
            try {
                LayoutSetLocalServiceUtil.getLayoutSet((String)domain);
                return true;
            }
            catch (Exception exception2) {
                Object[] allowedDomains = PropsValues.REST_PROXY_DOMAINS_ALLOWED;
                if (allowedDomains.length > 0 && !ArrayUtil.contains((Object[])allowedDomains, (Object)domain)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("URL " + url + " is not allowed"));
                    }
                    return false;
                }
                return true;
            }
        }
    }
}

