/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouterUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.HeaderCacheServletResponse;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionRequestFactory;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.ActionResponseFactory;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.EventImpl;
import com.liferay.portlet.EventRequestFactory;
import com.liferay.portlet.EventRequestImpl;
import com.liferay.portlet.EventResponseFactory;
import com.liferay.portlet.EventResponseImpl;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.InvokerPortletImpl;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.ResourceRequestFactory;
import com.liferay.portlet.ResourceResponseFactory;
import com.liferay.portlet.StateAwareResponseImpl;
import com.liferay.portlet.login.util.LoginUtil;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(LayoutAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HeaderCacheServletResponse headerCacheServletResponse = null;
        headerCacheServletResponse = response instanceof HeaderCacheServletResponse ? (HeaderCacheServletResponse)response : new HeaderCacheServletResponse(response);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        Boolean layoutDefault = (Boolean)request.getAttribute("LAYOUT_DEFAULT");
        if (layoutDefault != null && layoutDefault.booleanValue()) {
            Layout requestedLayout = (Layout)request.getAttribute("REQUESTED_LAYOUT");
            if (requestedLayout != null) {
                String redirectParam = "redirect";
                if (Validator.isNotNull((String)PropsValues.AUTH_LOGIN_PORTLET_NAME)) {
                    redirectParam = String.valueOf(PortalUtil.getPortletNamespace((String)PropsValues.AUTH_LOGIN_PORTLET_NAME)) + redirectParam;
                }
                String authLoginURL = null;
                if (PrefsPropsUtil.getBoolean(themeDisplay.getCompanyId(), "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED) || PrefsPropsUtil.getBoolean(themeDisplay.getCompanyId(), "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED)) {
                    authLoginURL = themeDisplay.getURLSignIn();
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PortalUtil.getSiteLoginURL((ThemeDisplay)themeDisplay);
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PropsValues.AUTH_LOGIN_URL;
                }
                if (Validator.isNull((String)authLoginURL)) {
                    PortletURL loginURL = LoginUtil.getLoginURL(request, themeDisplay.getPlid());
                    authLoginURL = loginURL.toString();
                }
                authLoginURL = HttpUtil.setParameter((String)authLoginURL, (String)"p_p_id", (String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                authLoginURL = HttpUtil.setParameter((String)authLoginURL, (String)redirectParam, (String)currentURL);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect requested layout to " + authLoginURL));
                }
                headerCacheServletResponse.sendRedirect(authLoginURL);
            } else {
                String redirect = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect default layout to " + redirect));
                }
                headerCacheServletResponse.sendRedirect(redirect);
            }
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("p_l_id is " + plid));
        }
        if (plid > 0L) {
            ActionForward actionForward = this.processLayout(mapping, request, (HttpServletResponse)headerCacheServletResponse, plid);
            String contentType = response.getContentType();
            CacheResponseUtil.setHeaders((HttpServletResponse)response, (Map)headerCacheServletResponse.getHeaders());
            if (contentType != null) {
                response.setContentType(contentType);
            }
            return actionForward;
        }
        try {
            this.forwardLayout(request);
            return mapping.findForward("/common/forward_jsp.jsp");
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)headerCacheServletResponse);
            CacheResponseUtil.setHeaders((HttpServletResponse)response, (Map)headerCacheServletResponse.getHeaders());
            return null;
        }
    }

    protected void forwardLayout(HttpServletRequest request) throws Exception {
        String forwardURL;
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        long plid = 0L;
        String layoutFriendlyURL = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (layout != null) {
            plid = layout.getPlid();
            layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        if (Validator.isNull(forwardURL = layoutFriendlyURL)) {
            forwardURL = String.valueOf(themeDisplay.getPathMain()) + "/portal/layout?p_l_id=" + plid;
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
            forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
            forwardURL = HttpUtil.addParameter((String)forwardURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward layout to " + forwardURL));
        }
        request.setAttribute("FORWARD_URL", (Object)forwardURL);
    }

    protected List<LayoutTypePortlet> getLayoutTypePortlets(long groupId, boolean privateLayout) throws Exception {
        ArrayList<LayoutTypePortlet> layoutTypePortlets = new ArrayList<LayoutTypePortlet>();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (String)"portlet");
        for (Layout layout : layouts) {
            if (!layout.isTypePortlet()) continue;
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlets.add(layoutTypePortlet);
        }
        return layoutTypePortlets;
    }

    protected long getScopeGroupId(HttpServletRequest request, LayoutTypePortlet layoutTypePortlet, String portletId) throws PortalException, SystemException {
        long scopeGroupId = 0L;
        Layout layoutTypePortletLayout = layoutTypePortlet.getLayout();
        Layout requestLayout = (Layout)request.getAttribute("LAYOUT");
        try {
            request.setAttribute("LAYOUT", (Object)layoutTypePortletLayout);
            scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request, (String)portletId);
        }
        finally {
            request.setAttribute("LAYOUT", (Object)requestLayout);
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = PortalUtil.getScopeGroupId((Layout)layoutTypePortletLayout, (String)portletId);
        }
        return scopeGroupId;
    }

    protected void includeLayoutContent(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay, Layout layout) throws Exception {
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        String path = "/html";
        if (BrowserSnifferUtil.isWap((HttpServletRequest)request)) {
            path = "/wap";
        }
        path = themeDisplay.isStateExclusive() || Validator.isNotNull((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id")) ? (layout.isTypePanel() ? String.valueOf(path) + "/portal/layout/view/panel.jsp" : (layout.isTypeControlPanel() ? String.valueOf(path) + "/portal/layout/view/control_panel.jsp" : String.valueOf(path) + "/portal/layout/view/portlet.jsp")) : String.valueOf(path) + PortalUtil.getLayoutViewPage((Layout)layout);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)unsyncStringWriter);
        String contentType = pipingServletResponse.getContentType();
        requestDispatcher.include((ServletRequest)request, (ServletResponse)pipingServletResponse);
        if (contentType != null) {
            pipingServletResponse.setContentType(contentType);
        }
        request.setAttribute("LAYOUT_CONTENT", (Object)unsyncStringWriter.getStringBundler());
    }

    protected void processEvent(PortletRequestImpl portletRequestImpl, StateAwareResponseImpl stateAwareResponseImpl, List<LayoutTypePortlet> layoutTypePortlets, LayoutTypePortlet layoutTypePortlet, Portlet portlet, Event event) throws Exception {
        HttpServletRequest request = portletRequestImpl.getHttpServletRequest();
        HttpServletResponse response = stateAwareResponseImpl.getHttpServletResponse();
        HttpSession session = request.getSession();
        String portletId = portlet.getPortletId();
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        WindowState windowState = null;
        windowState = layoutTypePortlet.hasStateMaxPortletId(portletId) ? WindowState.MAXIMIZED : (layoutTypePortlet.hasStateMinPortletId(portletId) ? WindowState.MINIMIZED : WindowState.NORMAL);
        PortletMode portletMode = null;
        portletMode = layoutTypePortlet.hasModeAboutPortletId(portletId) ? LiferayPortletMode.ABOUT : (layoutTypePortlet.hasModeConfigPortletId(portletId) ? LiferayPortletMode.CONFIG : (layoutTypePortlet.hasModeEditPortletId(portletId) ? PortletMode.EDIT : (layoutTypePortlet.hasModeEditDefaultsPortletId(portletId) ? LiferayPortletMode.EDIT_DEFAULTS : (layoutTypePortlet.hasModeEditGuestPortletId(portletId) ? LiferayPortletMode.EDIT_GUEST : (layoutTypePortlet.hasModeHelpPortletId(portletId) ? PortletMode.HELP : (layoutTypePortlet.hasModePreviewPortletId(portletId) ? LiferayPortletMode.PREVIEW : (layoutTypePortlet.hasModePrintPortletId(portletId) ? LiferayPortletMode.PRINT : PortletMode.VIEW)))))));
        long scopeGroupId = this.getScopeGroupId(request, layoutTypePortlet, portletId);
        Layout layoutTypePortletLayout = layoutTypePortlet.getLayout();
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((long)scopeGroupId, (Layout)layoutTypePortletLayout, (String)portletId, null);
        EventRequestImpl eventRequestImpl = EventRequestFactory.create(request, portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layoutTypePortletLayout.getPlid());
        eventRequestImpl.setEvent(this.serializeEvent(event, invokerPortlet.getPortletClassLoader()));
        Layout layout = stateAwareResponseImpl.getLayout();
        EventResponseImpl eventResponseImpl = EventResponseFactory.create(eventRequestImpl, response, portletId, stateAwareResponseImpl.getUser(), layout);
        eventRequestImpl.defineObjects(portletConfig, (PortletResponse)eventResponseImpl);
        try {
            InvokerPortletImpl.clearResponse(session, layout.getPrimaryKey(), portletId, LanguageUtil.getLanguageId((PortletRequest)eventRequestImpl));
            invokerPortlet.processEvent((EventRequest)eventRequestImpl, (EventResponse)eventResponseImpl);
            if (eventResponseImpl.isCalledSetRenderParameter()) {
                HashMap<String, String[]> renderParameterMap = new HashMap<String, String[]>();
                MapUtil.copy(eventResponseImpl.getRenderParameterMap(), renderParameterMap);
                RenderParametersPool.put(request, layout.getPlid(), portletId, renderParameterMap);
            }
            this.processEvents(eventRequestImpl, eventResponseImpl, layoutTypePortlets);
        }
        finally {
            eventRequestImpl.cleanUp();
        }
    }

    protected void processEvents(PortletRequestImpl portletRequestImpl, StateAwareResponseImpl stateAwareResponseImpl, List<LayoutTypePortlet> layoutTypePortlets) throws Exception {
        List<Event> events = stateAwareResponseImpl.getEvents();
        if (events.size() == 0) {
            return;
        }
        for (Event event : events) {
            javax.xml.namespace.QName qName = event.getQName();
            for (LayoutTypePortlet layoutTypePortlet : layoutTypePortlets) {
                List portlets = layoutTypePortlet.getAllPortlets();
                for (Portlet portlet : portlets) {
                    QName processingQName = portlet.getProcessingEvent(qName.getNamespaceURI(), qName.getLocalPart());
                    if (processingQName == null) continue;
                    this.processEvent(portletRequestImpl, stateAwareResponseImpl, layoutTypePortlets, layoutTypePortlet, portlet, event);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ActionForward processLayout(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, long plid) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        try {
            Layout layout = themeDisplay.getLayout();
            boolean resetLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_l_reset", (boolean)PropsValues.LAYOUT_DEFAULT_P_L_RESET);
            String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
            Layout previousLayout = (Layout)session.getAttribute("PREVIOUS_LAYOUT");
            if (previousLayout == null || layout.getPlid() != previousLayout.getPlid()) {
                session.setAttribute("PREVIOUS_LAYOUT", (Object)layout);
                if (themeDisplay.isSignedIn() && PropsValues.AUDIT_MESSAGE_COM_LIFERAY_PORTAL_MODEL_LAYOUT_VIEW && MessageBusUtil.hasMessageListener((String)"liferay/audit")) {
                    User user = themeDisplay.getUser();
                    AuditMessage auditMessage = new AuditMessage("VIEW", user.getCompanyId(), user.getUserId(), user.getFullName(), Layout.class.getName(), String.valueOf(layout.getPlid()));
                    AuditRouterUtil.route((AuditMessage)auditMessage);
                }
            }
            if (!PropsValues.TCK_URL && resetLayout && (Validator.isNull((String)portletId) || previousLayout != null && layout.getPlid() != previousLayout.getPlid())) {
                RenderParametersPool.clear(request, plid);
            }
            if (themeDisplay.isLifecycleAction()) {
                Portlet portlet = this.processPortletRequest(request, response, "ACTION_PHASE");
                if (portlet != null) {
                    ActionResponseImpl actionResponseImpl = (ActionResponseImpl)request.getAttribute("javax.portlet.response");
                    String redirectLocation = actionResponseImpl.getRedirectLocation();
                    if (Validator.isNotNull((String)redirectLocation)) {
                        response.sendRedirect(redirectLocation);
                        return null;
                    }
                    if (portlet.isActionURLRedirect()) {
                        this.redirectActionURL(request, response, actionResponseImpl, portlet);
                        return null;
                    }
                }
            } else if (themeDisplay.isLifecycleRender()) {
                this.processPortletRequest(request, response, "RENDER_PHASE");
            }
            if (themeDisplay.isLifecycleResource()) {
                this.processPortletRequest(request, response, "RESOURCE_PHASE");
                return null;
            }
            if (response.isCommitted()) {
                return null;
            }
            if (layout != null) {
                this.includeLayoutContent(request, response, themeDisplay, layout);
                if (themeDisplay.isStateExclusive()) {
                    this.renderExclusive(request, response, themeDisplay);
                    return null;
                }
            }
            ActionForward actionForward = mapping.findForward("portal.layout");
            return actionForward;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
        finally {
            PortletRequest portletRequest;
            if (!ServerDetector.isResin() && (portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request")) != null) {
                PortletRequestImpl portletRequestImpl = (PortletRequestImpl)portletRequest;
                portletRequestImpl.cleanUp();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Portlet processPortletRequest(HttpServletRequest request, HttpServletResponse response, String lifecycle) throws Exception {
        session = request /* !! */ .getSession();
        companyId = PortalUtil.getCompanyId((HttpServletRequest)request /* !! */ );
        user = PortalUtil.getUser((HttpServletRequest)request /* !! */ );
        layout = (Layout)request /* !! */ .getAttribute("LAYOUT");
        portletId = ParamUtil.getString((HttpServletRequest)request /* !! */ , (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        if (portlet == null) {
            return null;
        }
        themeDisplay = (ThemeDisplay)request /* !! */ .getAttribute("THEME_DISPLAY");
        themeDisplay.setScopeGroupId(PortalUtil.getScopeGroupId((HttpServletRequest)request /* !! */ , (String)portletId));
        servletContext = (ServletContext)request /* !! */ .getAttribute("CTX");
        invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        if (user != null) {
            InvokerPortletImpl.clearResponse(session, layout.getPrimaryKey(), portletId, LanguageUtil.getLanguageId((HttpServletRequest)request /* !! */ ));
        }
        portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        portletContext = portletConfig.getPortletContext();
        windowState = WindowStateFactory.getWindowState((String)ParamUtil.getString((HttpServletRequest)request /* !! */ , (String)"p_p_state"));
        if (layout.isTypeControlPanel() && (windowState == null || windowState.equals((Object)WindowState.NORMAL) || Validator.isNull((String)windowState.toString()))) {
            windowState = WindowState.MAXIMIZED;
        }
        portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)request /* !! */ , (String)"p_p_mode"));
        portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)request /* !! */ , (String)portletId);
        portletPreferences = null;
        portletPreferences = PortalUtil.isAllowAddPortletDefaultResource((HttpServletRequest)request /* !! */ , (Portlet)portlet) != false ? PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds) : PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
        this.processPublicRenderParameters(request /* !! */ , layout, portlet);
        if (lifecycle.equals("ACTION_PHASE")) {
            contentType = request /* !! */ .getHeader("Content-Type");
            if (LayoutAction._log.isDebugEnabled()) {
                LayoutAction._log.debug((Object)("Content type " + contentType));
            }
            uploadServletRequest = null;
            try {
                if (contentType != null && contentType.startsWith("multipart/form-data")) {
                    invokerPortletConfigImpl = (PortletConfigImpl)invokerPortlet.getPortletConfig();
                    if (invokerPortlet.isStrutsPortlet() || invokerPortletConfigImpl != null && !invokerPortletConfigImpl.isWARFile()) {
                        uploadServletRequest = new UploadServletRequestImpl(request /* !! */ );
                        request /* !! */  = uploadServletRequest;
                    }
                }
                if (PropsValues.AUTH_TOKEN_CHECK_ENABLED && invokerPortlet.isCheckAuthToken()) {
                    AuthTokenUtil.check((HttpServletRequest)request /* !! */ );
                }
                actionRequestImpl = ActionRequestFactory.create(request /* !! */ , portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
                actionResponseImpl = ActionResponseFactory.create(actionRequestImpl, response, portletId, user, layout, windowState, portletMode);
                actionRequestImpl.defineObjects(portletConfig, (PortletResponse)actionResponseImpl);
                serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequestImpl);
                ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
                invokerPortlet.processAction((ActionRequest)actionRequestImpl, (ActionResponse)actionResponseImpl);
                actionResponseImpl.transferHeaders(response);
                RenderParametersPool.put(request /* !! */ , layout.getPlid(), portletId, actionResponseImpl.getRenderParameterMap());
                layoutTypePortlets = null;
                if (actionResponseImpl.getEvents().isEmpty()) ** GOTO lbl72
                if (PropsValues.PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET) {
                    layoutTypePortlets = this.getLayoutTypePortlets(layout.getGroupId(), layout.isPrivateLayout());
                } else if (layout.isTypePortlet()) {
                    layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                    layoutTypePortlets = new ArrayList<LayoutTypePortlet>();
                    layoutTypePortlets.add(layoutTypePortlet);
                }
                this.processEvents(actionRequestImpl, actionResponseImpl, layoutTypePortlets);
                actionRequestImpl.defineObjects(portletConfig, (PortletResponse)actionResponseImpl);
            }
            finally {
                if (uploadServletRequest != null) {
                    uploadServletRequest.cleanUp();
                }
                ServiceContextThreadLocal.popServiceContext();
            }
        } else if (lifecycle.equals("RENDER_PHASE") || lifecycle.equals("RESOURCE_PHASE")) {
            PortalUtil.updateWindowState((String)portletId, (User)user, (Layout)layout, (WindowState)windowState, (HttpServletRequest)request /* !! */ );
            PortalUtil.updatePortletMode((String)portletId, (User)user, (Layout)layout, (PortletMode)portletMode, (HttpServletRequest)request /* !! */ );
        }
lbl72:
        // 5 sources

        if (lifecycle.equals("RESOURCE_PHASE")) {
            portletDisplay = themeDisplay.getPortletDisplay();
            portletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            portletDisplay.setId(portletId);
            portletDisplay.setRootPortletId(portlet.getRootPortletId());
            portletDisplay.setInstanceId(portlet.getInstanceId());
            portletDisplay.setResourcePK(portletPrimaryKey);
            portletDisplay.setPortletName(portletConfig.getPortletName());
            portletDisplay.setNamespace(PortalUtil.getPortletNamespace((String)portletId));
            webDAVStorage = portlet.getWebDAVStorageInstance();
            if (webDAVStorage != null) {
                portletDisplay.setWebDAVEnabled(true);
            } else {
                portletDisplay.setWebDAVEnabled(false);
            }
            resourceRequestImpl = ResourceRequestFactory.create(request /* !! */ , portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
            resourceResponseImpl = ResourceResponseFactory.create(resourceRequestImpl, response, portletId, companyId);
            resourceRequestImpl.defineObjects(portletConfig, (PortletResponse)resourceResponseImpl);
            try {
                serviceContext = ServiceContextFactory.getInstance((PortletRequest)resourceRequestImpl);
                ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
                invokerPortlet.serveResource((ResourceRequest)resourceRequestImpl, (ResourceResponse)resourceResponseImpl);
            }
            finally {
                ServiceContextThreadLocal.popServiceContext();
            }
        }
        return portlet;
    }

    protected void processPublicRenderParameters(HttpServletRequest request, Layout layout, Portlet portlet) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Map<String, String[]> publicRenderParameters = PublicRenderParametersPool.get(request, layout.getPlid());
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            PublicRenderParameter publicRenderParameter;
            String name = (String)enu.nextElement();
            Object[] values = request.getParameterValues(name);
            QName qName = PortletQNameUtil.getQName((String)name);
            if (qName == null || (publicRenderParameter = portlet.getPublicRenderParameter(qName.getNamespaceURI(), qName.getLocalPart())) == null) continue;
            String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
            if (name.startsWith("p_r_p_")) {
                Object[] oldValues;
                if (themeDisplay.isLifecycleAction() && (oldValues = publicRenderParameters.get(publicRenderParameterName)) != null && oldValues.length != 0) {
                    values = (String[])ArrayUtil.append((Object[])values, (Object[])oldValues);
                }
                publicRenderParameters.put(publicRenderParameterName, (String[])values);
                continue;
            }
            publicRenderParameters.remove(publicRenderParameterName);
        }
    }

    protected void redirectActionURL(HttpServletRequest request, HttpServletResponse response, ActionResponseImpl actionResponseImpl, Portlet portlet) throws Exception {
        ActionRequestImpl actionRequestImpl = (ActionRequestImpl)request.getAttribute("javax.portlet.request");
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequestImpl, actionRequestImpl.getPortletName(), layout.getPlid(), "RENDER_PHASE");
        Map<String, String[]> renderParameters = actionResponseImpl.getRenderParameterMap();
        for (Map.Entry<String, String[]> entry : renderParameters.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            portletURL.setParameter(key, value);
        }
        response.sendRedirect(portletURL.toString());
    }

    protected void renderExclusive(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay) throws Exception {
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)request.getAttribute("javax.portlet.request");
        RenderResponseImpl renderResponseImpl = (RenderResponseImpl)request.getAttribute("javax.portlet.response");
        StringServletResponse stringResponse = (StringServletResponse)renderRequestImpl.getAttribute("STRING_SERVLET_RESPONSE");
        if (stringResponse == null) {
            stringResponse = (StringServletResponse)renderResponseImpl.getHttpServletResponse();
            Portlet portlet = this.processPortletRequest(request, response, "RENDER_PHASE");
            InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, null);
            invokerPortlet.render((RenderRequest)renderRequestImpl, (RenderResponse)renderResponseImpl);
            if (Validator.isNull((String)stringResponse.getString())) {
                stringResponse.setString(null);
            }
        }
        renderResponseImpl.transferHeaders(response);
        if (stringResponse.isCalledGetOutputStream()) {
            UnsyncByteArrayOutputStream ubaos = stringResponse.getUnsyncByteArrayOutputStream();
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(ubaos.unsafeGetByteArray(), 0, ubaos.size());
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)renderResponseImpl.getResourceName(), (InputStream)is, (String)renderResponseImpl.getContentType());
        } else if (stringResponse.isCalledGetWriter()) {
            byte[] content = stringResponse.getString().getBytes("UTF-8");
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)renderResponseImpl.getResourceName(), (byte[])content, (String)renderResponseImpl.getContentType());
        }
        renderRequestImpl.cleanUp();
    }

    protected Event serializeEvent(Event event, ClassLoader portletClassLoader) {
        Serializable value;
        block4: {
            value = event.getValue();
            if (value == null) {
                return event;
            }
            Class<?> valueClass = value.getClass();
            String valueClassName = valueClass.getName();
            try {
                Class<?> loadedValueClass = portletClassLoader.loadClass(valueClassName);
                if (loadedValueClass.equals(valueClass)) {
                    return event;
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)(String.valueOf(portletClassLoader.toString()) + " does not contain " + valueClassName), (Throwable)cnfe);
            }
        }
        EventImpl eventImpl = (EventImpl)event;
        String base64Value = eventImpl.getBase64Value();
        value = (Serializable)Base64.stringToObject((String)base64Value, (ClassLoader)portletClassLoader);
        return new EventImpl(event.getName(), event.getQName(), value);
    }
}

