/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util.test;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.NumericStringRandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.randomizerbumpers.UniqueStringRandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.test.randomizerbumpers.FriendlyURLRandomizerBumper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class LayoutTestUtil {
    public static Layout addLayout(Group group) throws Exception {
        return LayoutTestUtil.addLayout(group.getGroupId());
    }

    public static Layout addLayout(Group group, boolean privateLayout) throws Exception {
        return LayoutTestUtil.addLayout(group.getGroupId(), privateLayout);
    }

    public static Layout addLayout(Group group, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled) throws Exception {
        return LayoutTestUtil.addLayout(group.getGroupId(), privateLayout, layoutPrototype, linkEnabled);
    }

    public static Layout addLayout(Group group, long parentLayoutPlid) throws Exception {
        return LayoutTestUtil.addLayout(group.getGroupId(), parentLayoutPlid);
    }

    public static Layout addLayout(long groupId) throws Exception {
        return LayoutTestUtil.addLayout(groupId, false);
    }

    public static Layout addLayout(long groupId, boolean privateLayout) throws Exception {
        return LayoutTestUtil.addLayout(groupId, privateLayout, null, false);
    }

    public static Layout addLayout(long groupId, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled) throws Exception {
        return LayoutTestUtil.addLayout(groupId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[]{FriendlyURLRandomizerBumper.INSTANCE, NumericStringRandomizerBumper.INSTANCE, UniqueStringRandomizerBumper.INSTANCE}), privateLayout, layoutPrototype, linkEnabled);
    }

    public static Layout addLayout(long groupId, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> friendlyURLMap) throws Exception {
        return LayoutTestUtil.addLayout(groupId, privateLayout, nameMap, friendlyURLMap, false);
    }

    public static Layout addLayout(long groupId, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> friendlyURLMap, boolean hidden) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        return LayoutLocalServiceUtil.addLayout((long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, nameMap, nameMap, new HashMap(), new HashMap(), new HashMap(), (String)"portlet", (String)"", (boolean)hidden, friendlyURLMap, (ServiceContext)serviceContext);
    }

    public static Layout addLayout(long groupId, long parentLayoutPlid) throws Exception {
        Layout layout = LayoutTestUtil.addLayout(groupId, false);
        LayoutLocalServiceUtil.updateParentLayoutId((long)layout.getPlid(), (long)parentLayoutPlid);
        return LayoutLocalServiceUtil.fetchLayout((long)layout.getPlid());
    }

    public static Layout addLayout(long groupId, String name, boolean privateLayout) throws Exception {
        return LayoutTestUtil.addLayout(groupId, name, privateLayout, null, false);
    }

    public static Layout addLayout(long groupId, String name, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled) throws Exception {
        return LayoutTestUtil.addLayout(groupId, name, privateLayout, layoutPrototype, linkEnabled, false);
    }

    public static Layout addLayout(long groupId, String name, boolean privateLayout, LayoutPrototype layoutPrototype, boolean linkEnabled, boolean hidden) throws Exception {
        String friendlyURL = "/" + FriendlyURLNormalizerUtil.normalize((String)name);
        try {
            return LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)friendlyURL);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            String description = "This is a test page.";
            ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext();
            if (layoutPrototype != null) {
                serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)Boolean.valueOf(linkEnabled));
                serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
            }
            return LayoutLocalServiceUtil.addLayout((long)TestPropsValues.getUserId(), (long)groupId, (boolean)privateLayout, (long)0L, (String)name, null, (String)description, (String)"portlet", (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
        }
    }

    public static Layout addLayout(long groupId, String name, long parentLayoutPlid) throws Exception {
        Layout layout = LayoutTestUtil.addLayout(groupId, name, false);
        LayoutLocalServiceUtil.updateParentLayoutId((long)layout.getPlid(), (long)parentLayoutPlid);
        return LayoutLocalServiceUtil.fetchLayout((long)layout.getPlid());
    }

    public static LayoutPrototype addLayoutPrototype(String name) throws Exception {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        return LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)TestPropsValues.getUserId(), (long)TestPropsValues.getCompanyId(), nameMap, (Map)null, (boolean)true, (ServiceContext)ServiceContextTestUtil.getServiceContext());
    }

    public static LayoutSetPrototype addLayoutSetPrototype(String name) throws Exception {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        return LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype((long)TestPropsValues.getUserId(), (long)TestPropsValues.getCompanyId(), nameMap, (Map)null, (boolean)true, (boolean)true, (ServiceContext)ServiceContextTestUtil.getServiceContext());
    }

    public static String addPortletToLayout(Layout layout, String portletId) throws Exception {
        Map<String, String[]> preferenceMap = null;
        return LayoutTestUtil.addPortletToLayout(layout, portletId, preferenceMap);
    }

    public static String addPortletToLayout(Layout layout, String portletId, Map<String, String[]> preferenceMap) throws Exception {
        long userId = TestPropsValues.getUserId();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        List columns = layoutTemplate.getColumns();
        String columnId = (String)columns.get(0);
        return LayoutTestUtil.addPortletToLayout(userId, layout, portletId, columnId, preferenceMap);
    }

    public static String addPortletToLayout(long userId, Layout layout, String portletId, String columnId, Map<String, String[]> preferenceMap) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        String newPortletId = layoutTypePortlet.addPortletId(userId, portletId, columnId, -1);
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        if (preferenceMap == null) {
            return newPortletId;
        }
        PortletPreferences portletPreferences = LayoutTestUtil.getPortletPreferences(layout, newPortletId);
        for (Map.Entry<String, String[]> entry : preferenceMap.entrySet()) {
            portletPreferences.setValues(entry.getKey(), entry.getValue());
        }
        portletPreferences.store();
        return newPortletId;
    }

    public static Layout addTypeLinkToLayoutLayout(long groupId, long linkedToLayoutId) throws Exception {
        Layout layout = LayoutTestUtil.addLayout(groupId, false);
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("linkToLayoutId", String.valueOf(linkedToLayoutId));
        layout.setType("link_to_layout");
        LayoutLocalServiceUtil.updateLayout((Layout)layout);
        return layout;
    }

    public static String getLayoutTemplateId(Layout layout) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.getLayoutTemplateId();
    }

    public static PortletPreferences getPortletPreferences(Layout layout, String portletId) throws Exception {
        return PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, null);
    }

    public static PortletPreferences getPortletPreferences(long plid, String portletId) throws Exception {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        return LayoutTestUtil.getPortletPreferences(layout, portletId);
    }

    public static List<Portlet> getPortlets(Layout layout) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.getPortlets();
    }

    public static boolean isLayoutColumnCustomizable(Layout layout, String columnId) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.isColumnCustomizable(columnId);
    }

    public static Layout updateLayoutColumnCustomizable(Layout layout, String columnId, boolean customizable) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setTypeSettingsProperty(CustomizedPages.namespaceColumnId((String)columnId), String.valueOf(customizable));
        layoutTypePortlet.setUpdatePermission(customizable);
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }

    public static Layout updateLayoutPortletPreference(Layout layout, String portletId, String portletPreferenceName, String portletPreferenceValue) throws Exception {
        PortletPreferences layoutPortletPreferences = LayoutTestUtil.getPortletPreferences(layout, portletId);
        layoutPortletPreferences.setValue(portletPreferenceName, portletPreferenceValue);
        layoutPortletPreferences.store();
        return LayoutLocalServiceUtil.getLayout((long)layout.getPlid());
    }

    public static Layout updateLayoutPortletPreferences(Layout layout, String portletId, Map<String, String> portletPreferences) throws Exception {
        PortletPreferences layoutPortletPreferences = LayoutTestUtil.getPortletPreferences(layout, portletId);
        for (Map.Entry<String, String> entry : portletPreferences.entrySet()) {
            layoutPortletPreferences.setValue(entry.getKey(), entry.getValue());
        }
        layoutPortletPreferences.store();
        return LayoutLocalServiceUtil.getLayout((long)layout.getPlid());
    }

    public static Layout updateLayoutTemplateId(Layout layout, String layoutTemplateId) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(TestPropsValues.getUserId(), layoutTemplateId);
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }
}

