/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule.callback;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.test.rule.callback.TestCallback;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.test.log.CaptureAppender;
import com.liferay.portal.test.log.Log4JLoggerTestUtil;
import com.liferay.portal.test.rule.ExpectedDBType;
import com.liferay.portal.test.rule.ExpectedLog;
import com.liferay.portal.test.rule.ExpectedLogs;
import com.liferay.portal.test.rule.ExpectedMultipleLogs;
import com.liferay.portal.test.rule.ExpectedType;
import com.liferay.portal.test.rule.LogAssertionAppender;
import com.liferay.portal.test.rule.LogAssertionHandler;
import com.liferay.portal.test.rule.LogAssertionUncaughtExceptionHandler;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.runner.Description;

public class LogAssertionTestCallback
implements TestCallback<List<CaptureAppender>, List<CaptureAppender>> {
    public static final LogAssertionTestCallback INSTANCE = new LogAssertionTestCallback();
    private static final Map<Thread, Error> _concurrentFailures = new ConcurrentHashMap<Thread, Error>();
    private static volatile Thread _thread;
    private static volatile Thread.UncaughtExceptionHandler _uncaughtExceptionHandler;

    public static void caughtFailure(Error error) {
        Thread currentThread = Thread.currentThread();
        if (currentThread == _thread) {
            throw error;
        }
        Error previousError = _concurrentFailures.put(currentThread, error);
        if (previousError != null) {
            error.addSuppressed(previousError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endAssert(List<ExpectedLogs> expectedLogsList, List<CaptureAppender> captureAppenders) {
        StringBundler sb = new StringBundler();
        for (CaptureAppender captureAppender : captureAppenders) {
            try {
                for (LoggingEvent loggingEvent : captureAppender.getLoggingEvents()) {
                    String renderedMessage = loggingEvent.getRenderedMessage();
                    if (LogAssertionTestCallback.isExpected(expectedLogsList, renderedMessage)) continue;
                    sb.append(renderedMessage);
                    sb.append("\n\n");
                }
            }
            finally {
                captureAppender.close();
            }
        }
        if (sb.index() != 0) {
            sb.setIndex(sb.index() - 1);
            Assert.fail((String)sb.toString());
        }
        Thread.setDefaultUncaughtExceptionHandler(_uncaughtExceptionHandler);
        _thread = null;
        try {
            for (Map.Entry entry : _concurrentFailures.entrySet()) {
                Thread thread = (Thread)entry.getKey();
                Error error = (Error)entry.getValue();
                UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                error.printStackTrace((PrintWriter)new UnsyncPrintWriter((Writer)unsyncStringWriter));
                sb.append("Thread ");
                sb.append((Object)thread);
                sb.append(" caught concurrent failure: ");
                sb.append((Object)error);
                sb.append("\n");
                sb.append(unsyncStringWriter.toString());
                sb.append("\n\n");
            }
            if (sb.index() != 0) {
                sb.setIndex(sb.index() - 1);
                Assert.fail((String)sb.toString());
            }
        }
        finally {
            _concurrentFailures.clear();
        }
    }

    public static List<CaptureAppender> startAssert(List<ExpectedLogs> expectedLogsList) {
        _thread = Thread.currentThread();
        _uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new LogAssertionUncaughtExceptionHandler(_uncaughtExceptionHandler));
        ArrayList<CaptureAppender> captureAppenders = new ArrayList<CaptureAppender>(expectedLogsList.size());
        for (ExpectedLogs expectedLogs : expectedLogsList) {
            Class<?> clazz = expectedLogs.loggerClass();
            captureAppenders.add(Log4JLoggerTestUtil.configureLog4JLogger(clazz.getName(), Level.toLevel((String)expectedLogs.level())));
        }
        LogAssertionTestCallback.installJdk14Handler();
        LogAssertionTestCallback.installLog4jAppender();
        return captureAppenders;
    }

    public void afterClass(Description description, List<CaptureAppender> captureAppenders) {
        ExpectedMultipleLogs expectedMultipleLogs = (ExpectedMultipleLogs)description.getAnnotation(ExpectedMultipleLogs.class);
        ArrayList<ExpectedLogs> expectedLogsList = new ArrayList<ExpectedLogs>();
        if (expectedMultipleLogs == null) {
            ExpectedLogs expectedLogs = (ExpectedLogs)description.getAnnotation(ExpectedLogs.class);
            if (expectedLogs != null) {
                expectedLogsList.add(expectedLogs);
            }
        } else {
            Collections.addAll(expectedLogsList, expectedMultipleLogs.expectedMultipleLogs());
        }
        LogAssertionTestCallback.endAssert(expectedLogsList, captureAppenders);
    }

    public void afterMethod(Description description, List<CaptureAppender> captureAppenders, Object target) {
        this.afterClass(description, captureAppenders);
    }

    public List<CaptureAppender> beforeClass(Description description) {
        ExpectedMultipleLogs expectedMultipleLogs = (ExpectedMultipleLogs)description.getAnnotation(ExpectedMultipleLogs.class);
        ArrayList<ExpectedLogs> expectedLogsList = new ArrayList<ExpectedLogs>();
        if (expectedMultipleLogs == null) {
            ExpectedLogs expectedLogs = (ExpectedLogs)description.getAnnotation(ExpectedLogs.class);
            if (expectedLogs != null) {
                expectedLogsList.add(expectedLogs);
            }
        } else {
            Collections.addAll(expectedLogsList, expectedMultipleLogs.expectedMultipleLogs());
        }
        return LogAssertionTestCallback.startAssert(expectedLogsList);
    }

    public List<CaptureAppender> beforeMethod(Description description, Object target) {
        return this.beforeClass(description);
    }

    protected static void installJdk14Handler() {
        Logger logger = Logger.getLogger("");
        logger.removeHandler(LogAssertionHandler.INSTANCE);
        logger.addHandler(LogAssertionHandler.INSTANCE);
    }

    protected static void installLog4jAppender() {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
        logger.removeAppender((Appender)LogAssertionAppender.INSTANCE);
        logger.addAppender((Appender)LogAssertionAppender.INSTANCE);
    }

    protected static boolean isExpected(List<ExpectedLogs> expectedLogsList, String renderedMessage) {
        for (ExpectedLogs expectedLogs : expectedLogsList) {
            for (ExpectedLog expectedLog : expectedLogs.expectedLogs()) {
                ExpectedType expectedType;
                ExpectedDBType expectedDBType = expectedLog.expectedDBType();
                if (expectedDBType != ExpectedDBType.NONE) {
                    DB db = DBManagerUtil.getDB();
                    if (expectedDBType.getDBType() != db.getDBType()) continue;
                }
                if (!((expectedType = expectedLog.expectedType()) == ExpectedType.CONTAINS ? renderedMessage.contains(expectedLog.expectedLog()) : (expectedType == ExpectedType.EXACT ? renderedMessage.equals(expectedLog.expectedLog()) : (expectedType == ExpectedType.POSTFIX ? renderedMessage.endsWith(expectedLog.expectedLog()) : expectedType == ExpectedType.PREFIX && renderedMessage.startsWith(expectedLog.expectedLog()))))) continue;
                return true;
            }
        }
        return false;
    }

    private LogAssertionTestCallback() {
    }
}

