/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule.callback;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.test.rule.callback.BaseTestCallback;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.junit.runner.Description;

public class DestinationAwaitTestCallback
extends BaseTestCallback<Set<CountDownLatch>, Void> {
    public static final DestinationAwaitTestCallback INSTANCE = new DestinationAwaitTestCallback("liferay/document_library_sync_event_processor", "liferay/hot_deploy");
    private final String[] _destinationNames;

    public DestinationAwaitTestCallback(String ... destinationNames) {
        this._destinationNames = destinationNames;
    }

    public void afterClass(Description description, Set<CountDownLatch> endCountDownLatches) throws Throwable {
        endCountDownLatches.forEach(CountDownLatch::countDown);
    }

    public Set<CountDownLatch> beforeClass(Description description) throws InterruptedException {
        HashSet<CountDownLatch> endCountdownLatches = new HashSet<CountDownLatch>();
        for (String destinationName : this._destinationNames) {
            final Destination destination = MessageBusUtil.getDestination((String)destinationName);
            if (destination == null) {
                if (System.getenv("JENKINS_HOME") == null) continue;
                throw new IllegalStateException(destinationName + " is not available");
            }
            final CountDownLatch startCountDownLatch = new CountDownLatch(1);
            final CountDownLatch endCountDownLatch = new CountDownLatch(1);
            final Message countDownMessage = new Message();
            destination.register(new MessageListener(){

                public void receive(Message message) {
                    if (countDownMessage == message) {
                        startCountDownLatch.countDown();
                        try {
                            endCountDownLatch.await();
                            destination.unregister((MessageListener)this);
                        }
                        catch (InterruptedException ie) {
                            ReflectionUtil.throwException((Throwable)ie);
                        }
                    }
                }
            });
            destination.send(countDownMessage);
            startCountDownLatch.await();
            endCountdownLatches.add(endCountDownLatch);
        }
        return endCountdownLatches;
    }
}

