/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.rule.BaseTestRule;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TransactionalTestRule
implements TestRule {
    public static final TransactionalTestRule INSTANCE = new TransactionalTestRule(Propagation.SUPPORTS, null);
    private final String _originBundleSymbolicName;
    private final TransactionConfig _transactionConfig;

    public TransactionalTestRule(Propagation propagation) {
        this(propagation, null);
    }

    public TransactionalTestRule(Propagation propagation, String originBundleSymbolicName) {
        this._originBundleSymbolicName = originBundleSymbolicName;
        this._transactionConfig = TransactionConfig.Factory.create((Propagation)propagation, (Class[])new Class[]{PortalException.class, SystemException.class}, (Class[])new Class[0]);
    }

    public Statement apply(Statement statement, final Description description) {
        Statement currentStatement = statement;
        while (true) {
            if (currentStatement instanceof BaseTestRule.StatementWrapper) {
                BaseTestRule.StatementWrapper statementWrapper = (BaseTestRule.StatementWrapper)currentStatement;
                currentStatement = statementWrapper.getStatement();
                continue;
            }
            if (currentStatement instanceof RunRules) {
                currentStatement = (Statement)ReflectionTestUtil.getFieldValue((Object)currentStatement, (String)"statement");
                continue;
            }
            if (currentStatement instanceof RunBefores) {
                this.replaceFrameworkMethods(currentStatement, "befores");
                currentStatement = (Statement)ReflectionTestUtil.getFieldValue((Object)currentStatement, (String)"next");
                continue;
            }
            if (!(currentStatement instanceof RunAfters)) break;
            this.replaceFrameworkMethods(currentStatement, "afters");
            currentStatement = (Statement)ReflectionTestUtil.getFieldValue((Object)currentStatement, (String)"next");
        }
        return new BaseTestRule.StatementWrapper(statement){

            public void evaluate() throws Throwable {
                try (Closeable closeable = TransactionalTestRule._installTransactionExecutor(TransactionalTestRule.this._originBundleSymbolicName);){
                    TransactionInvokerUtil.invoke((TransactionConfig)TransactionalTestRule.this.getTransactionConfig((Transactional)description.getAnnotation(Transactional.class)), (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                statement.evaluate();
                            }
                            catch (Throwable t) {
                                ReflectionUtil.throwException((Throwable)t);
                            }
                            return null;
                        }
                    });
                }
            }
        };
    }

    public TransactionConfig getTransactionConfig(Transactional transactional) {
        if (transactional != null) {
            return TransactionConfig.Factory.create((Isolation)transactional.isolation(), (Propagation)transactional.propagation(), (boolean)transactional.readOnly(), (int)transactional.timeout(), (Class[])transactional.rollbackFor(), (String[])transactional.rollbackForClassName(), (Class[])transactional.noRollbackFor(), (String[])transactional.noRollbackForClassName());
        }
        return this._transactionConfig;
    }

    protected void replaceFrameworkMethods(Statement statement, String name) {
        ArrayList<FrameworkMethod> newFrameworkMethods = new ArrayList<FrameworkMethod>();
        List frameworkMethods = (List)ReflectionTestUtil.getFieldValue((Object)statement, (String)name);
        for (FrameworkMethod frameworkMethod : frameworkMethods) {
            if (frameworkMethod instanceof TransactionalFrameworkMethod) {
                newFrameworkMethods.add(frameworkMethod);
                continue;
            }
            newFrameworkMethods.add(new TransactionalFrameworkMethod(frameworkMethod.getMethod(), this.getTransactionConfig((Transactional)frameworkMethod.getAnnotation(Transactional.class)), this._originBundleSymbolicName));
        }
        ReflectionTestUtil.setFieldValue((Object)statement, (String)name, newFrameworkMethods);
    }

    private static Closeable _installTransactionExecutor(String originBundleSymbolicName) throws InvalidSyntaxException {
        if (originBundleSymbolicName == null) {
            return () -> {};
        }
        ThreadLocal transactionExecutorsThreadLocal = (ThreadLocal)ReflectionTestUtil.getFieldValue(TransactionExecutorThreadLocal.class, (String)"_transactionExecutorThreadLocal");
        Deque transactionExecutors = (Deque)transactionExecutorsThreadLocal.get();
        Bundle bundle = FrameworkUtil.getBundle(TransactionalTestRule.class);
        BundleContext bundleContext = bundle.getBundleContext();
        Object[] serviceReferences = bundleContext.getAllServiceReferences(TransactionExecutor.class.getName(), "(origin.bundle.symbolic.name=" + originBundleSymbolicName + ")");
        Assert.assertEquals((String)StringBundler.concat((String[])new String[]{"Expected 1 TransactionExecutor for ", originBundleSymbolicName, ", actually have ", Arrays.toString(serviceReferences)}), (long)1L, (long)serviceReferences.length);
        Object serviceReference = serviceReferences[0];
        TransactionExecutor portletTransactionExecutor = (TransactionExecutor)bundleContext.getService((ServiceReference)serviceReference);
        if (portletTransactionExecutor == transactionExecutors.peek()) {
            return () -> {};
        }
        transactionExecutors.push(portletTransactionExecutor);
        return () -> TransactionalTestRule.lambda$_installTransactionExecutor$2(transactionExecutors, bundleContext, (ServiceReference)serviceReference);
    }

    private static /* synthetic */ void lambda$_installTransactionExecutor$2(Deque transactionExecutors, BundleContext bundleContext, ServiceReference serviceReference) throws IOException {
        transactionExecutors.pop();
        bundleContext.ungetService(serviceReference);
    }

    protected static class TransactionalFrameworkMethod
    extends FrameworkMethod {
        private final String _originBundleSymbolicName;
        private final TransactionConfig _transactionConfig;

        public Object invokeExplosively(final Object target, final Object ... params) throws Throwable {
            try (Closeable closeable = TransactionalTestRule._installTransactionExecutor(this._originBundleSymbolicName);){
                Object object = TransactionInvokerUtil.invoke((TransactionConfig)this._transactionConfig, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try {
                            return TransactionalFrameworkMethod.super.invokeExplosively(target, params);
                        }
                        catch (Throwable t) {
                            ReflectionUtil.throwException((Throwable)t);
                            return null;
                        }
                    }
                });
                return object;
            }
        }

        protected TransactionalFrameworkMethod(Method method, TransactionConfig transactionConfig, String originBundleSymbolicName) {
            super(method);
            this._transactionConfig = transactionConfig;
            this._originBundleSymbolicName = originBundleSymbolicName;
        }
    }
}

