/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.test;

import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletPreferences;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BasePortletDataHandlerTestCase {
    protected Element missingReferencesElement;
    protected PortletDataContext portletDataContext;
    protected PortletDataHandler portletDataHandler;
    protected String portletId;
    protected Element rootElement;
    @DeleteAfterTestRun
    protected Group stagingGroup;
    protected ZipWriter zipWriter;

    @Before
    public void setUp() throws Exception {
        this.stagingGroup = GroupTestUtil.addGroup();
        this.portletId = this.getPortletId();
        this.portletDataHandler = this.getPortletDataHandler(this.portletId);
    }

    @Test
    public void testAddDefaultData() throws Exception {
        this.initContext();
        PortletPreferences portletPreferences = this.portletDataHandler.addDefaultData(this.portletDataContext, this.portletId, (PortletPreferences)new PortletPreferencesImpl());
        this.validateDefaultData(portletPreferences);
    }

    @Test
    public void testDataLevel() throws Exception {
        Assert.assertEquals((Object)this.getDataLevel(), (Object)this.portletDataHandler.getDataLevel());
    }

    @Test
    public void testDeleteData() throws Exception {
        if (!this.isDeleteDataTested()) {
            return;
        }
        this.initContext();
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        this.addStagedModels();
        this.portletDataContext.setEndDate(this.getEndDate());
        this.portletDataHandler.deleteData(this.portletDataContext, this.portletId, (PortletPreferences)portletPreferences);
        List<StagedModel> stagedModels = this.getStagedModels();
        Assert.assertEquals((String)stagedModels.toString(), (long)0L, (long)stagedModels.size());
        for (String preferenceKey : this.portletDataHandler.getDataPortletPreferences()) {
            String portletPreference = portletPreferences.getValue(preferenceKey, "");
            Assert.assertEquals((Object)"", (Object)portletPreference);
        }
    }

    @Test
    public void testExportImportData() throws Exception {
        if (!this.isExportImportDataTested()) {
            return;
        }
        this.initContext();
        this.addStagedModels();
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        this.portletDataContext.setEndDate(this.getEndDate());
        String exportData = this.portletDataHandler.exportData(this.portletDataContext, this.portletId, (PortletPreferences)portletPreferences);
        Document document = SAXReaderUtil.read((String)exportData);
        Element rootElement = document.getRootElement();
        List<StagedModel> exportedStagedModels = this.getStagedModels();
        for (StagedModel stagedModel : exportedStagedModels) {
            Class modelClass = stagedModel.getModelClass();
            Element element = rootElement.element(modelClass.getSimpleName());
            List stagedModelNodes = element.content();
            boolean contains = false;
            for (Node node : stagedModelNodes) {
                if (!(node instanceof Element)) continue;
                Element nodeElement = (Element)node;
                Attribute uuidAttribute = nodeElement.attribute("uuid");
                String uuid = uuidAttribute.getValue();
                if (!Objects.equals(stagedModel.getUuid(), uuid)) continue;
                contains = true;
            }
            Assert.assertTrue((boolean)contains);
        }
        ZipWriter exportZipWriter = this.portletDataContext.getZipWriter();
        this.initContext();
        Group cleanGroup = GroupTestUtil.addGroup();
        UserIdStrategy testUserIdStrategy = new UserIdStrategy(){

            public long getUserId(String userUuid) {
                try {
                    return TestPropsValues.getUserId();
                }
                catch (Exception e) {
                    return 0L;
                }
            }
        };
        this.portletDataContext.setUserIdStrategy(testUserIdStrategy);
        this.portletDataContext.setDataStrategy("DATA_STRATEGY_MIRROR");
        this.portletDataContext.setZipReader(ZipReaderFactoryUtil.getZipReader((File)exportZipWriter.getFile()));
        this.portletDataContext.setScopeGroupId(cleanGroup.getGroupId());
        this.portletDataContext.setGroupId(cleanGroup.getGroupId());
        this.portletDataContext.clearScopedPrimaryKeys();
        this.portletDataHandler.importData(this.portletDataContext, this.portletId, (PortletPreferences)portletPreferences, exportData);
        List<StagedModel> importedStagedModels = this.getStagedModels();
        HashSet<String> exportedUuidSet = new HashSet<String>();
        HashSet<String> importedUuidSet = new HashSet<String>();
        for (StagedModel stagedModel : exportedStagedModels) {
            exportedUuidSet.add(stagedModel.getUuid());
        }
        for (StagedModel stagedModel : importedStagedModels) {
            importedUuidSet.add(stagedModel.getUuid());
        }
        Assert.assertEquals(exportedUuidSet, importedUuidSet);
    }

    @Test
    public void testGetDataPortletPreferences() {
        Assert.assertArrayEquals((Object[])this.getDataPortletPreferences(), (Object[])this.portletDataHandler.getDataPortletPreferences());
    }

    @Test
    public void testGetExportConfigurationControls() throws Exception {
        if (!this.isGetExportConfigurationControlsTested()) {
            return;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)this.portletId);
        this.initContext();
        PortletDataHandlerControl[] portletDataHandlerControls = null;
        if (this.portletDataHandler.isDisplayPortlet()) {
            portletDataHandlerControls = this.portletDataHandler.getExportControls();
        }
        PortletDataHandlerControl[] testPortletDataHandlerControls = this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, false);
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, -1L, false), testPortletDataHandlerControls);
        testPortletDataHandlerControls = this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, true);
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, -1L, true), testPortletDataHandlerControls);
        testPortletDataHandlerControls = this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, this.portletDataContext.getPlid(), false);
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, this.portletDataContext.getPlid(), false), testPortletDataHandlerControls);
        testPortletDataHandlerControls = this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, this.portletDataContext.getPlid(), true);
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, this.portletDataContext.getPlid(), true), testPortletDataHandlerControls);
    }

    @Test
    public void testGetExportControls() throws Exception {
        this._assertControls(this.getExportControls(), this.portletDataHandler.getExportControls());
    }

    @Test
    public void testGetExportMetadataControls() throws Exception {
        this._assertControls(this.getExportMetadataControls(), this.portletDataHandler.getExportMetadataControls());
    }

    @Test
    public void testGetExportModelCount() throws Exception {
        if (!this.isGetExportModelCountTested()) {
            return;
        }
        this.initContext();
        this.addStagedModels();
        this.portletDataContext.setEndDate(this.getEndDate());
        this.portletDataHandler.prepareManifestSummary(this.portletDataContext);
        ManifestSummary manifestSummary = this.portletDataContext.getManifestSummary();
        Assert.assertEquals((long)this.getExportModelCount(), (long)this.portletDataHandler.getExportModelCount(manifestSummary));
    }

    @Test
    public void testGetImportConfigurationControls() throws Exception {
        PortletDataHandlerControl[] testPortletDataHandlerControls = this.portletDataHandler.getImportConfigurationControls(new String[]{"setup"});
        this._assertControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, null, null, null)}, testPortletDataHandlerControls);
        testPortletDataHandlerControls = this.portletDataHandler.getImportConfigurationControls(new String[]{"archived-setups"});
        this._assertControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_ARCHIVED_SETUPS", "configuration-templates", true, false, null, null, null)}, testPortletDataHandlerControls);
        testPortletDataHandlerControls = this.portletDataHandler.getImportConfigurationControls(new String[]{"user-preferences"});
        this._assertControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_USER_PREFERENCES", "user-preferences", true, false, null, null, null)}, testPortletDataHandlerControls);
    }

    @Test
    public void testGetImportControls() throws Exception {
        this._assertControls(this.getImportControls(), this.portletDataHandler.getImportControls());
    }

    @Test
    public void testGetImportMetadataControls() throws Exception {
        this._assertControls(this.getImportMetadataControls(), this.portletDataHandler.getImportMetadataControls());
    }

    @Test
    public void testGetStagingControls() throws Exception {
        this._assertControls(this.getStagingControls(), this.portletDataHandler.getStagingControls());
    }

    @Test
    public void testIsDataPortalLevel() {
        Assert.assertEquals((Object)this.isDataPortalLevel(), (Object)this.portletDataHandler.isDataPortalLevel());
    }

    @Test
    public void testIsDataPortletInstanceLevel() {
        Assert.assertEquals((Object)this.isDataPortletInstanceLevel(), (Object)this.portletDataHandler.isDataPortletInstanceLevel());
    }

    @Test
    public void testIsDataSiteLevel() {
        Assert.assertEquals((Object)this.isDataSiteLevel(), (Object)this.portletDataHandler.isDataSiteLevel());
    }

    @Test
    public void testIsDisplayPortlet() throws Exception {
        Assert.assertEquals((Object)this.isDisplayPortlet(), (Object)this.portletDataHandler.isDisplayPortlet());
    }

    @Test
    public void testPrepareManifestSummary() throws Exception {
        this.initContext();
        this.addStagedModels();
        this.portletDataContext.setEndDate(this.getEndDate());
        this.portletDataHandler.prepareManifestSummary(this.portletDataContext);
        ManifestSummary manifestSummary = this.portletDataContext.getManifestSummary();
        ManifestSummary expectedManifestSummary = (ManifestSummary)manifestSummary.clone();
        manifestSummary.resetCounters();
        this.portletDataHandler.exportData(this.portletDataContext, this.portletId, (PortletPreferences)new PortletPreferencesImpl());
        this.checkManifestSummary(expectedManifestSummary);
    }

    @Test
    public void testValidateSchemaVersion() throws Exception {
        Assert.assertTrue((boolean)this.portletDataHandler.validateSchemaVersion(this.getSchemaVersion()));
    }

    protected void addBooleanParameter(Map<String, String[]> parameterMap, String namespace, String name, boolean value) {
        PortletDataHandlerBoolean portletDataHandlerBoolean = new PortletDataHandlerBoolean(namespace, name);
        parameterMap.put(portletDataHandlerBoolean.getNamespacedControlName(), new String[]{String.valueOf(value)});
    }

    protected void addParameters(Map<String, String[]> parameterMap) {
    }

    protected abstract void addStagedModels() throws Exception;

    protected void checkManifestSummary(ManifestSummary expectedManifestSummary) {
        ManifestSummary manifestSummary = this.portletDataContext.getManifestSummary();
        this.checkManifestSummaryReferrerClassNames(manifestSummary);
        for (String manifestSummaryKey : expectedManifestSummary.getManifestSummaryKeys()) {
            String[] keyParts = StringUtil.split((String)manifestSummaryKey, (String)"#");
            long expectedModelAdditionCount = expectedManifestSummary.getModelAdditionCount(manifestSummaryKey);
            StagedModelType stagedModelType = new StagedModelType(keyParts[0]);
            if (keyParts.length > 1) {
                stagedModelType = new StagedModelType(keyParts[0], keyParts[1]);
            }
            long modelAdditionCount = manifestSummary.getModelAdditionCount(stagedModelType);
            if (expectedModelAdditionCount == 0L) {
                Assert.assertFalse((modelAdditionCount > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((long)expectedModelAdditionCount, (long)modelAdditionCount);
        }
    }

    protected void checkManifestSummaryReferrerClassNames(ManifestSummary manifestSummary) {
        for (String manifestSummaryKey : manifestSummary.getManifestSummaryKeys()) {
            Assert.assertFalse((boolean)manifestSummaryKey.endsWith("referrer-class-name-all"));
            Assert.assertFalse((boolean)manifestSummaryKey.endsWith("referrer-class-name-any"));
        }
    }

    protected DataLevel getDataLevel() {
        return DataLevel.SITE;
    }

    protected String[] getDataPortletPreferences() {
        return StringPool.EMPTY_ARRAY;
    }

    protected Date getEndDate() {
        return new Date();
    }

    protected PortletDataHandlerControl[] getExportConfigurationControls(long companyId, long groupId, PortletDataHandlerControl[] portletDataHandlerControls, long plid, boolean privateLayout) {
        if (plid < 0L) {
            return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, portletDataHandlerControls, null, null)};
        }
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[0];
    }

    protected long getExportModelCount() {
        List<StagedModel> stagedModels = this.getStagedModels();
        return stagedModels.size();
    }

    protected PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandler getPortletDataHandler(String portletId) {
        try {
            Registry registry = RegistryUtil.getRegistry();
            Collection portletDataHandlers = registry.getServices(PortletDataHandler.class, "(javax.portlet.name=" + portletId + ")");
            Iterator iterator = portletDataHandlers.iterator();
            return (PortletDataHandler)iterator.next();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getPortletId();

    protected String getSchemaVersion() {
        return "1.0.0";
    }

    protected List<StagedModel> getStagedModels() {
        return new ArrayList<StagedModel>();
    }

    protected PortletDataHandlerControl[] getStagingControls() {
        return new PortletDataHandlerControl[0];
    }

    protected Date getStartDate() {
        return new Date(System.currentTimeMillis() - 3600000L);
    }

    protected void initContext() throws Exception {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        this.addParameters(parameterMap);
        this.zipWriter = ZipWriterFactoryUtil.getZipWriter();
        this.portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)this.stagingGroup.getCompanyId(), (long)this.stagingGroup.getGroupId(), parameterMap, (Date)this.getStartDate(), (Date)this.getEndDate(), (ZipWriter)this.zipWriter);
        this.rootElement = SAXReaderUtil.createElement((String)"root");
        this.portletDataContext.setExportDataRootElement(this.rootElement);
        this.missingReferencesElement = SAXReaderUtil.createElement((String)"missing-references");
        this.portletDataContext.setMissingReferencesElement(this.missingReferencesElement);
        this.portletDataContext.setPortletId(this.portletId);
    }

    protected boolean isDataPortalLevel() {
        DataLevel dataLevel = this.getDataLevel();
        return dataLevel.equals((Object)DataLevel.PORTAL);
    }

    protected boolean isDataPortletInstanceLevel() {
        DataLevel dataLevel = this.getDataLevel();
        return dataLevel.equals((Object)DataLevel.PORTLET_INSTANCE);
    }

    protected boolean isDataSiteLevel() {
        DataLevel dataLevel = this.getDataLevel();
        return dataLevel.equals((Object)DataLevel.SITE);
    }

    protected boolean isDeleteDataTested() {
        return false;
    }

    protected boolean isDisplayPortlet() {
        return this.isDataPortletInstanceLevel() && ArrayUtil.isNotEmpty((Object[])this.portletDataHandler.getDataPortletPreferences());
    }

    protected boolean isExportImportDataTested() {
        return false;
    }

    protected boolean isGetExportConfigurationControlsTested() {
        return false;
    }

    protected boolean isGetExportModelCountTested() {
        return false;
    }

    protected void validateDefaultData(PortletPreferences portletPreferences) throws Exception {
    }

    private void _assertControls(PortletDataHandlerControl[] expectedControls, PortletDataHandlerControl[] actualControls) throws Exception {
        for (PortletDataHandlerControl expectedControl : expectedControls) {
            boolean contains = false;
            for (PortletDataHandlerControl actualControl : actualControls) {
                if (!Objects.equals(expectedControl.getControlName(), actualControl.getControlName()) || !Objects.equals(expectedControl.getControlLabel(), actualControl.getControlLabel()) || expectedControl.isDisabled() != actualControl.isDisabled()) continue;
                contains = true;
                break;
            }
            Assert.assertTrue((boolean)contains);
        }
    }
}

