/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.test.rule;

import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.rule.BaseTestRule;
import com.liferay.portal.kernel.test.rule.SynchronousDestinationTestRule;
import com.liferay.portal.kernel.test.rule.TimeoutTestRule;
import com.liferay.portal.kernel.test.rule.callback.CompanyProviderTestCallback;
import com.liferay.portal.kernel.test.rule.callback.DeleteAfterTestRunTestCallback;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.test.rule.callback.ClearThreadLocalTestCallback;
import com.liferay.portal.test.rule.callback.DestinationAwaitTestCallback;
import com.liferay.portal.test.rule.callback.InjectTestCallback;
import com.liferay.portal.test.rule.callback.LogAssertionTestCallback;
import com.liferay.portal.test.rule.callback.MainServletTestCallback;
import com.liferay.portal.test.rule.callback.SybaseDumpTransactionLogTestCallback;
import com.liferay.portal.test.rule.callback.UniqueStringRandomizerBumperTestCallback;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.log4j.Level;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

import org.springframework.mock.web.MockServletContext;

/**
 * @author Shuyang Zhou
 */
public class LiferayIntegrationTestRule extends AggregateTestRule {

	public LiferayIntegrationTestRule() {
		super(false, _getTestRules());
	}

	private static TestRule[] _getTestRules() {
		List<TestRule> testRules = new ArrayList<>();

		if (System.getenv("JENKINS_HOME") != null) {
			testRules.add(TimeoutTestRule.INSTANCE);
		}

		testRules.add(LogAssertionTestRule.INSTANCE);
		testRules.add(_springInitializationTestRule);
		testRules.add(_sybaseDumpTransactionLogTestRule);
		testRules.add(_clearThreadLocalTestRule);
		testRules.add(_uniqueStringRandomizerBumperTestRule);
		testRules.add(_mainServletTestRule);
		testRules.add(_destinationAwaitTestRule);
		testRules.add(_companyProviderTestRule);
		testRules.add(_deleteAfterTestRunTestRule);
		testRules.add(SynchronousDestinationTestRule.INSTANCE);
		testRules.add(_injectTestRule);

		return testRules.toArray(new TestRule[0]);
	}

	private static final TestRule _clearThreadLocalTestRule =
		new BaseTestRule<>(ClearThreadLocalTestCallback.INSTANCE);
	private static final TestRule _companyProviderTestRule = new BaseTestRule<>(
		CompanyProviderTestCallback.INSTANCE);
	private static final TestRule _deleteAfterTestRunTestRule =
		new BaseTestRule<>(DeleteAfterTestRunTestCallback.INSTANCE);
	private static final TestRule _destinationAwaitTestRule =
		new BaseTestRule<>(DestinationAwaitTestCallback.INSTANCE);
	private static final TestRule _injectTestRule = new BaseTestRule<>(
		InjectTestCallback.INSTANCE);
	private static final TestRule _mainServletTestRule = new BaseTestRule<>(
		MainServletTestCallback.INSTANCE);

	private static final TestRule _springInitializationTestRule =
		new TestRule() {

			@Override
			public Statement apply(
				Statement statement, Description description) {

				return new BaseTestRule.StatementWrapper(statement) {

					@Override
					public void evaluate() throws Throwable {
						if (!InitUtil.isInitialized()) {
							List<String> configLocations = ListUtil.fromArray(
								PropsUtil.getArray(PropsKeys.SPRING_CONFIGS));

							boolean configureLog4j = false;

							if (GetterUtil.getBoolean(
									SystemProperties.get(
										"log4j.configure.on.startup"),
									true)) {

								SystemProperties.set(
									"log4j.configure.on.startup", "false");

								configureLog4j = true;
							}

							Log4JUtil.setLevel(
								DialectDetector.class.getName(),
								Level.INFO.toString(), false);

							ClassPathUtil.initializeClassPaths(
								new MockServletContext());
							PortalClassPathUtil.initializeClassPaths(
								new MockServletContext());

							InitUtil.initWithSpring(
								configLocations, true, true);

							if (configureLog4j) {
								Log4JUtil.configureLog4J(
									InitUtil.class.getClassLoader());

								LogAssertionTestCallback.startAssert(
									Collections.<ExpectedLogs>emptyList());
							}

							if (System.getProperty("external-properties") ==
									null) {

								System.setProperty(
									"external-properties",
									"portal-test.properties");
							}
						}

						statement.evaluate();
					}

				};
			}

		};

	private static final TestRule _sybaseDumpTransactionLogTestRule =
		new BaseTestRule<>(SybaseDumpTransactionLogTestCallback.INSTANCE);
	private static final TestRule _uniqueStringRandomizerBumperTestRule =
		new BaseTestRule<>(UniqueStringRandomizerBumperTestCallback.INSTANCE);

}