Liferay.Loader.define("porygon-theme@2.0.12/js/top_search.es", ['exports', 'metal/src/async/async', 'metal/src/core', 'metal-dom/src/dom', 'metal-state/src/State'], function (exports, _async, _core, _dom, _State2) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _async2 = _interopRequireDefault(_async);

	var _core2 = _interopRequireDefault(_core);

	var _dom2 = _interopRequireDefault(_dom);

	var _State3 = _interopRequireDefault(_State2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var TopSearch = function (_State) {
		_inherits(TopSearch, _State);

		/**
   * @inheritDoc
   */
		function TopSearch() {
			_classCallCheck(this, TopSearch);

			var _this = _possibleConstructorReturn(this, (TopSearch.__proto__ || Object.getPrototypeOf(TopSearch)).call(this));

			_this.search_ = _dom2.default.toElement('#search');
			_this.searchIcon_ = _dom2.default.toElement('#banner .btn-search');
			_this.searchInput_ = _dom2.default.toElement('#banner .search-input');

			if (_this.searchInput_) {
				_dom2.default.addClasses(_this.searchInput_, 'visible-xs');

				_dom2.default.on(_this.searchIcon_, 'click', function (e) {
					return _this.onSearchIconClick_(e);
				});
				_dom2.default.on(_this.searchInput_, 'blur', function (e) {
					return _this.onSearchInputBlur_(e);
				});
				_dom2.default.on(_this.searchInput_, 'keydown', function (e) {
					return _this.onSearchInputKeyDown_(e);
				});

				_this.on('visibleChanged', function (e) {
					return _this.onVisibleChanged_(e);
				});
			} else {
				_this.searchIcon_.setAttribute('disabled', 'disabled');

				_dom2.default.addClasses(_this.searchIcon_, 'disabled');
			}
			return _this;
		}

		/**
   * Toggles the visibility of the search component when the user
   * clicks on the search icon
   *
   * @param  {MouseEvent} event
   * @protected
   */


		_createClass(TopSearch, [{
			key: 'onSearchIconClick_',
			value: function onSearchIconClick_(event) {
				this.visible = _dom2.default.hasClass(this.searchInput_, 'visible-xs');
			}
		}, {
			key: 'onSearchInputBlur_',
			value: function onSearchInputBlur_(event) {
				var _this2 = this;

				_async2.default.nextTick(function () {
					var stateActiveElementBlur = document.activeElement !== _this2.searchIcon_ && document.activeElement !== _this2.searchInput_;

					if (stateActiveElementBlur && (!_this2.searchInput_.value || _this2.searchInput_.value === '')) {
						_this2.visible = false;
					}
				});
			}
		}, {
			key: 'onSearchInputKeyDown_',
			value: function onSearchInputKeyDown_(event) {
				this.visible = event.keyCode !== 27;
			}
		}, {
			key: 'onVisibleChanged_',
			value: function onVisibleChanged_(event) {
				var updateFn = this.visible ? 'addClasses' : 'removeClasses';

				_dom2.default[updateFn](document.body, 'search-opened');
				_dom2.default[updateFn](this.search_, 'focus');
				_dom2.default[updateFn](this.searchIcon_, 'open');

				_dom2.default.toggleClasses(this.searchInput_, 'visible-xs');

				if (this.visible) {
					this.searchInput_.focus();
				}
			}
		}]);

		return TopSearch;
	}(_State3.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */
	TopSearch.STATE = {
		/**
   * Indicates if the component is visible or not.
   * @type {Object}
   */
		visible: {
			validator: _core2.default.isBoolean,
			value: false
		}
	};

	exports.default = TopSearch;
});
//# sourceMappingURL=top_search.es.js.map
