/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osb.provisioning.rest.client.resource.v1_0;

import com.liferay.osb.provisioning.rest.client.http.HttpInvoker;
import com.liferay.osb.provisioning.rest.client.problem.Problem;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface AccountResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteAccountContactByEmailAddresContactEmailAddressRole(String var1, String var2, String[] var3) throws Exception;

    public HttpInvoker.HttpResponse deleteAccountContactByEmailAddresContactEmailAddressRoleHttpResponse(String var1, String var2, String[] var3) throws Exception;

    public void putAccountContactByEmailAddresContactEmailAddressRole(String var1, String var2, String[] var3, String var4, String var5) throws Exception;

    public HttpInvoker.HttpResponse putAccountContactByEmailAddresContactEmailAddressRoleHttpResponse(String var1, String var2, String[] var3, String var4, String var5) throws Exception;

    public static class AccountResourceImpl
    implements AccountResource {
        private static final Logger _logger = Logger.getLogger(AccountResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteAccountContactByEmailAddresContactEmailAddressRole(String accountKey, String contactEmailAddress, String[] contactRoleNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteAccountContactByEmailAddresContactEmailAddressRoleHttpResponse(accountKey, contactEmailAddress, contactRoleNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteAccountContactByEmailAddresContactEmailAddressRoleHttpResponse(String accountKey, String contactEmailAddress, String[] contactRoleNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (contactRoleNames != null) {
                for (int i = 0; i < contactRoleNames.length; ++i) {
                    httpInvoker.parameter("contactRoleNames", String.valueOf(contactRoleNames[i]));
                }
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/provisioning-rest/v1.0/accounts/{accountKey}/contacts/by-email-address/{contactEmailAddress}/roles");
            httpInvoker.path("accountKey", accountKey);
            httpInvoker.path("contactEmailAddress", contactEmailAddress);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void putAccountContactByEmailAddresContactEmailAddressRole(String accountKey, String contactEmailAddress, String[] contactRoleNames, String firstName, String lastName) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putAccountContactByEmailAddresContactEmailAddressRoleHttpResponse(accountKey, contactEmailAddress, contactRoleNames, firstName, lastName);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse putAccountContactByEmailAddresContactEmailAddressRoleHttpResponse(String accountKey, String contactEmailAddress, String[] contactRoleNames, String firstName, String lastName) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body("[]", "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            if (contactRoleNames != null) {
                for (int i = 0; i < contactRoleNames.length; ++i) {
                    httpInvoker.parameter("contactRoleNames", String.valueOf(contactRoleNames[i]));
                }
            }
            if (firstName != null) {
                httpInvoker.parameter("firstName", String.valueOf(firstName));
            }
            if (lastName != null) {
                httpInvoker.parameter("lastName", String.valueOf(lastName));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/provisioning-rest/v1.0/accounts/{accountKey}/contacts/by-email-address/{contactEmailAddress}/roles");
            httpInvoker.path("accountKey", accountKey);
            httpInvoker.path("contactEmailAddress", contactEmailAddress);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        private AccountResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login;
        private String _password;
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public AccountResource build() {
            return new AccountResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

