/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.ECPContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateECPContext
extends AbstractConditionalProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateECPContext.class);
    @Nonnull
    private Function<ProfileRequestContext, ECPContext> ecpContextCreationStrategy = Functions.compose((Function)new ChildContextLookup(ECPContext.class, true), (Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(EncryptionContext.class), (Function)new OutboundMessageContextLookup());
    @Nullable
    private SecureRandom randomGenerator;
    private boolean requireEncryption;

    public PopulateECPContext() throws NoSuchAlgorithmException {
        try {
            this.randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1PRNG is required to be supported by the JVM but is not", e);
        }
        this.requireEncryption = true;
    }

    public void setECPContextCreationStrategy(@Nonnull Function<ProfileRequestContext, ECPContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ecpContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"ECPContext creation strategy cannot be null");
    }

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    public void setRandomGenerator(@Nullable SecureRandom generator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.randomGenerator = generator;
    }

    public void setRequireEncryption(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireEncryption = flag;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ECPContext ecpContext = (ECPContext)this.ecpContextCreationStrategy.apply((Object)profileRequestContext);
        if (ecpContext == null) {
            this.log.error("{} Error creating ECPContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        ecpContext.setRequestAuthenticated(SAMLBindingSupport.isMessageSigned((MessageContext)profileRequestContext.getInboundMessageContext()));
        this.log.debug("{} RequestAuthenticated: {}", (Object)this.getLogPrefix(), (Object)ecpContext.isRequestAuthenticated());
        boolean generateKey = true;
        if (this.requireEncryption) {
            generateKey = false;
            EncryptionContext encryptionCtx = (EncryptionContext)this.encryptionContextLookupStrategy.apply((Object)profileRequestContext);
            if (encryptionCtx != null) {
                boolean bl = generateKey = encryptionCtx.getAssertionEncryptionParameters() != null;
            }
        }
        if (generateKey) {
            this.log.debug("{} Generating session key for use by ECP peers", (Object)this.getLogPrefix());
            byte[] key = new byte[32];
            this.randomGenerator.nextBytes(key);
            ecpContext.setSessionKey(key);
        } else {
            this.log.debug("{} Assertion encryption is not enabled, skipping session key generation", (Object)this.getLogPrefix());
            ecpContext.setSessionKey(null);
        }
    }
}

