/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Manifest;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.JavaVersion;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class JarHell {
    private JarHell() {
    }

    @SuppressForbidden(reason="command line tool")
    public static void main(String[] args) throws Exception {
        System.out.println("checking for jar hell...");
        JarHell.checkJarHell();
        System.out.println("no jar hell found");
    }

    public static void checkJarHell() throws Exception {
        ClassLoader loader = JarHell.class.getClassLoader();
        ESLogger logger = Loggers.getLogger(JarHell.class);
        if (logger.isDebugEnabled()) {
            logger.debug("java.class.path: {}", System.getProperty("java.class.path"));
            logger.debug("sun.boot.class.path: {}", System.getProperty("sun.boot.class.path"));
            if (loader instanceof URLClassLoader) {
                logger.debug("classloader urls: {}", Arrays.toString(((URLClassLoader)loader).getURLs()));
            }
        }
        JarHell.checkJarHell(JarHell.parseClassPath());
    }

    public static URL[] parseClassPath() {
        return JarHell.parseClassPath(System.getProperty("java.class.path"));
    }

    @SuppressForbidden(reason="resolves against CWD because that is how classpaths work")
    static URL[] parseClassPath(String classPath) {
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        String[] elements = classPath.split(pathSeparator);
        URL[] urlElements = new URL[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            if (element.isEmpty()) {
                throw new IllegalStateException("Classpath should not contain empty elements! (outdated shell script from a previous version?) classpath='" + classPath + "'");
            }
            if (element.startsWith("/") && "\\".equals(fileSeparator) && (element = element.replace("/", "\\")).length() >= 3 && element.charAt(2) == ':') {
                element = element.substring(1);
            }
            try {
                urlElements[i] = PathUtils.get(element, new String[0]).toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urlElements;
    }

    @SuppressForbidden(reason="needs JarFile for speed, just reading entries")
    public static void checkJarHell(URL[] urls) throws Exception {
    }

    static void checkManifest(Manifest manifest, Path jar) {
        String targetVersion = manifest.getMainAttributes().getValue("X-Compile-Target-JDK");
        if (targetVersion != null) {
            JarHell.checkVersionFormat(targetVersion);
            JarHell.checkJavaVersion(jar.toString(), targetVersion);
        }
        String systemESVersion = Version.CURRENT.toString();
        String targetESVersion = manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Version");
        if (targetESVersion != null && !targetESVersion.equals(systemESVersion)) {
            throw new IllegalStateException(jar + " requires Elasticsearch " + targetESVersion + ", your system: " + systemESVersion);
        }
    }

    public static void checkVersionFormat(String targetVersion) {
        if (!JavaVersion.isValid(targetVersion)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "version string must be a sequence of nonnegative decimal integers separated by \".\"'s and may have leading zeros but was %s", targetVersion));
        }
    }

    public static void checkJavaVersion(String resource, String targetVersion) {
        JavaVersion version = JavaVersion.parse(targetVersion);
        if (JavaVersion.current().compareTo(version) < 0) {
            throw new IllegalStateException(String.format(Locale.ROOT, "%s requires Java %s:, your system: %s", resource, targetVersion, JavaVersion.current().toString()));
        }
    }

    static void checkClass(Map<String, Path> clazzes, String clazz, Path jarpath) {
        Path previous = clazzes.put(clazz, jarpath);
        if (previous != null) {
            if (previous.equals(jarpath)) {
                if (clazz.startsWith("org.apache.xmlbeans")) {
                    return;
                }
                throw new IllegalStateException("jar hell!" + System.lineSeparator() + "class: " + clazz + System.lineSeparator() + "exists multiple times in jar: " + jarpath + " !!!!!!!!!");
            }
            if (clazz.startsWith("org.apache.log4j")) {
                return;
            }
            if (clazz.equals("org.joda.time.base.BaseDateTime")) {
                return;
            }
            throw new IllegalStateException("jar hell!" + System.lineSeparator() + "class: " + clazz + System.lineSeparator() + "jar1: " + previous + System.lineSeparator() + "jar2: " + jarpath);
        }
    }
}

