/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.activation;

import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.axiom.ext.activation.SizeAwareDataSource;

public class DataSourceUtils {
    private static final Class<?> byteArrayDataSourceClass;

    public static long getSize(DataSource ds) {
        if (ds instanceof SizeAwareDataSource) {
            return ((SizeAwareDataSource)ds).getSize();
        }
        if (byteArrayDataSourceClass != null && byteArrayDataSourceClass.isInstance(ds)) {
            try {
                return ((ByteArrayInputStream)ds.getInputStream()).available();
            }
            catch (IOException ex) {
                return -1L;
            }
        }
        if (ds instanceof FileDataSource) {
            return ((FileDataSource)ds).getFile().length();
        }
        return -1L;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("jakarta.mail.util.ByteArrayDataSource");
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        byteArrayDataSourceClass = clazz;
    }
}

