/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.configurator.impl.logger.SystemLogger;

public class WorkerQueue
implements Runnable {
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    private final Thread backgroundThread;
    private volatile boolean stopped = false;

    public WorkerQueue() {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        this.backgroundThread = threadFactory.newThread(this);
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.setName("Apache Felix Configurator Worker Thread");
        this.backgroundThread.start();
    }

    public void stop() {
        this.stopped = true;
        this.backgroundThread.interrupt();
    }

    public void enqueue(Runnable r) {
        if (!this.stopped) {
            this.tasks.add(r);
        }
    }

    @Override
    public void run() {
        while (true) {
            Runnable r = null;
            if (!this.stopped) {
                try {
                    r = this.tasks.take();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            if (r == null) continue;
            try {
                r.run();
                continue;
            }
            catch (Throwable t) {
                SystemLogger.error("Error processing task" + t.getMessage(), t);
                continue;
            }
            break;
        }
    }
}

